/****************************************************************************
**
**  Name:  symadd.h
**
**  Description:
**     Prototypes for the functions to add to the symbol memory pool
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/symbol/symadd.h_v  $
** 
**    Rev 1.0   13 Feb 1997 09:06:20   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:16:44   gene
** Initial revision.
** 
**    Rev 1.6   13 Dec 1991 12:25:58   brucea
** Added prototype for SymAddGetModuleName
** 
**    Rev 1.5   08 Nov 1991 13:51:16   john
** Moved prototype for InitBasicTypes to typetbl.h
** 
**    Rev 1.4   30 Oct 1991 15:58:46   john
** Moved function prototypes for some initialization code here.
** 
**    Rev 1.3   23 Oct 1991 17:12:58   john
** Removed EXPORT keyword from a function that was not exportable.
** 
**    Rev 1.2   11 Oct 1991 15:05:04   brucea
** No change.
** 
**    Rev 1.1   03 Oct 1991 16:45:36   john
** structures moved back to symmgr.h
** 
**    Rev 1.0   03 Oct 1991 11:58:44   john
** Initial revision.
** 
**  $Header:   S:/tbird/mt2_68k/symbol/symadd.h_v   1.0   13 Feb 1997 09:06:20   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _SYMADD_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _MEMMANAG_
#include "memmanag.h"
#endif
#ifndef _SYMMGR_
#include "symmgr.h"
#endif
#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/***************************************************************************
** InitSymTable
**
** Description: Initializes the symbol table.
**
** Input Parameters:
**    none:
** Output Parameters:
**    none:
** Errors:
**    ER_OUT_OF_MEMORY:
** NOTE: no BaseSymbol is created on initialization.  This means that any
**    loader must first create a base (and its index) before using it.
***************************************************************************/
RETCODE InitSymTable(VOID);

//--------------------------------------------------------------------------
// SymAddGetoduleName
//--------------------------------------------------------------------------
RETCODE
SymAddGetModuleName(SYM_DESCRIPTOR module, LPSTR modName);


/****************************************************************************
**
**  SymInitSymServer
**
**  Description:
**     Initializes the symbol server
**     
**  Parameters:
**     input:
**        cliHandle:  the handle of the cli server
**        dllHandle:  the handle of the symbol server
**     output:
**        none:
**        (returns): error code
**
*****************************************************************************/

RETCODE SymInitSymServer(HANDLE cliHandle,HANDLE dllHandle);


/******************************** E O F ***********************************/
