/*************************************************************************
**
** $Log:   S:/tbird/mt2_68k/trace/trigwdlg.c_v  $
** 
**    Rev 1.3   04 Jun 1998 15:24:48   Gene
** Fixed a bug of event restore GPF. If restore event before opening the trigger
** windows will cause a GPF.
** 
**    Rev 1.2   18 Mar 1997 09:04:56   gene
** 
**    Rev 1.14   09 Jan 1997 09:52:24   cjchen
** 
**    Rev 1.13   19 Dec 1996 17:43:18   cjchen
** 
**    Rev 1.13   19 Dec 1996 17:42:32   cjchen
** 
**    Rev 1.12   19 Dec 1996 09:05:16   cjchen
** 
**    Rev 1.11   12 Dec 1996 14:12:20   cjchen
** 
**    Rev 1.10   12 Dec 1996 11:25:22   cjchen
** 
**    Rev 1.9   22 Nov 1996 14:31:34   cjchen
** 
**    Rev 1.8   07 Nov 1996 18:21:50   cjchen
** 
**    Rev 1.7   29 Oct 1996 16:20:22   cjchen
** 
**    Rev 1.6   22 Oct 1996 18:17:44   cjchen
** 
**    Rev 1.5   18 Oct 1996 17:47:12   cjchen
** 
**    Rev 1.4   17 Oct 1996 09:13:38   cjchen
** 
**    Rev 1.3   11 Oct 1996 17:22:40   cjchen
** 
**    Rev 1.2   09 Oct 1996 14:43:28   cjchen
** 
**    Rev 1.1   08 Oct 1996 17:31:00   cjchen
** 
**    Rev 1.0   06 Sep 1996 16:49:20   cjchen
** Initial revision.
** 
**    Rev 1.2   12 Aug 1996 08:44:44   cjchen
** 
**    Rev 1.1   24 Jul 1996 09:37:44   cjchen
** add TrigTriggerClose in wm_destroy
** 
**    Rev 1.0   23 Jul 1996 13:52:14   cjchen
** Initial revision.
** 
**    Rev 1.2   17 Jun 1996 15:56:16   cjchen
** modified the tab space
** 
**    Rev 1.1   14 Jun 1996 08:18:20   cjchen
** 
**    Rev 1.0   10 Jun 1996 08:34:42   cjchen
** Initial revision.
** $Header:   S:/tbird/mt2_68k/trace/trigwdlg.c_v   1.3   04 Jun 1998 15:24:48   Gene  $
****************************************************************************/

                /************************
                *                       *
                *   INCLUDE FILE        *
                *                       *
                *************************/

#ifndef __WINDOW_H
#include "windows.h"
#endif

#include <commdlg.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _SDTEMPL_
#include "sdtempl.h"
#endif

#ifndef _TRIG_
#include "trig.h"
#endif

#ifndef _EVENT_
#include "event.h"
#endif

#ifndef _TRACE_
#include "trace.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#ifndef _TRITWDLG_
#include "trigwdlg.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

                /***********************
                *                      *
                *     DEFINITIONS      *
                *                      *
                ************************/
#define MAXLEN           40
#define COMBOXWIDTH
#define COMBOXHEIGHT
#define EDITWIDHT
#define EDITHEIGHT
#define PUSHBSWIDTH
#define PUSHBSHEIGHT
#define OPENFILE        "MICEPACK.INI"
               /************************
               *                       *
               *     EXTERNAL          *
               *                       *
               *************************/
extern HINSTANCE hLib;
               /************************
               *                       *
               *       LOCAL           *
               *                       *
               *************************/
static HANDLE hInst;
CHAR szString[128];
CHAR szAppName[20];
HINSTANCE hInst;
HWND hWndTrig=NULL;

PRIVATE BOOLEAN registeredClasses = FALSE;
HWND hWndEvtCondition[11];
HWND hWndEvtEnable[11];
HWND hWndEvtExtIn[11];
HWND hWndEvtSeq[11];
HWND hWndEvtAction[11][16];
HWND hWndTmCounter[2];
HWND hWndEvtUnit[2];

int nEvtCond,nEvtColumn,nEvtAction;
int  nTop,nLeft,cxAveChar,cyHeight,widthX,heightY;
DESCRIPTOR theTrigger=NULL,theEvent=NULL;
U16 buttonID,flagCounterDec_Hex=IDM_COUNTER_DEC;
CHAR flagTMCO_0,flagTMCO_1;
FARPROC lpExtInSelectProc,lpSelExtOutProc,lpSelSeqProc;
FARPROC lpfnOldEdit,lpTraceControlProc;
char initStr[]="(Clear)";
char tmcounterUnit[2][10];
U32 epClock;

               /************************
               *                       *
               *       PROTOTYPE       *
               *                       *
               *************************/
void SetupList(U16 *);
EVENT_COND ConvEvtCond(int);
ACTION_MASK ConvEvtAction(int);
ACTION_MASK ConvLevel2ActionMask(int);
void SetupCheckBox(HWND);
void HandleActiveWindow(void);
void TrigExtInSelect(HWND);
//void GetExtButtonTitle(void);
void ClearActionGroup(void);
void SetupLevel(HWND);
long FAR PASCAL WndProc (HWND, UINT, UINT, LONG);
long FAR PASCAL EditProc(HWND, UINT, UINT, LONG);
BOOL FAR PASCAL SelSeqProc (HWND , UINT ,UINT ,LONG);
BOOL FAR PASCAL SelExtOutProc (HWND , UINT ,UINT ,LONG);
RETCODE CreateEvtPresenter(HINSTANCE, S16, S16, S16, S16);
RETCODE TmCounter2Server(U8,U8 *,U32 *);
RETCODE Server2TmCounter(U8,U32);
RETCODE ErrMessageBoxL(char *);
int nCwRegisterClasses(void);
void InitialCheckBox(HWND,HFONT);
void HandleSeqOrExtOutAction(HWND);
BOOLEAN ConvActionMask2One(ACTION_MASK ,ACTION_MASK);
ACTION_MASK WhichBitsWillClear(ACTION_MASK);
void UpdateTmCounterWindow(HWND);
VOID ToolBarMsg(WPARAM WParam, LPARAM LParam);
BOOL FAR PASCAL TraceControlDlgProc(HWND ,UINT ,UINT ,LONG);
RETCODE UpdateServer(HWND);
RETCODE TrcTraceControl(HWND);
RETCODE TimerUnitInt2Str(U8,char *);
RETCODE AppendTmCounterUnit(char *,U8,char *);
/*****************************************************************************
**
**  CreateEvtPresenter
**
*****************************************************************************/
RETCODE CreateEvtPresenter(HINSTANCE hInstance, S16 left, S16 top,
                              S16 width, S16 height) {
   int nRc;  // return value from Register Classes
   RETCODE err;
   strcpy(szAppName, "Trigger");
   hInst = hInstance;
   nTop=top;
   nLeft=left;
   if(!registeredClasses) {
      /* register window classes if first instance of application */
      if ((nRc = nCwRegisterClasses()) == -1) {
         // TODO: Replace this with ErrDisplayFormattedError
         strcpy(szString, "Error registering virtual listbox or peripheral");
         MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
         return nRc;
      }
      registeredClasses = TRUE;
   }

   if (!left && !width) {
      left = CW_USEDEFAULT;
      width = CW_USEDEFAULT;
   }
   
   //initialize trigger server
   if ((err=TrigTriggerOpen(&theTrigger,"","default"))!=GOOD) {
      ErrDisplayError(err,FORCE_POPUP);
      return GOOD;
   }
   TrigSeqLevelSet(theTrigger,0);
   if (theEvent==NULL)
       EvtOpenEvent(&theEvent,"default");

   /* create peripheral window */
   hWndTrig = CreateWindow((LPSTR) szAppName,    /* Window class name    */
                           (LPSTR)"Trigger - Level 0",  /* title         */
                           (WS_CAPTION     |     /* Title and Min/Max    */
                           WS_SYSMENU      |     /* Add system menu box  */
                           WS_MINIMIZEBOX  |     /* Add minimize box     */
                          /* WS_MAXIMIZEBOX  |      Add maximize box     */
                          /* WS_THICKFRAME   |  */
                           WS_CLIPCHILDREN |     /* don't draw in child ares */
                           WS_OVERLAPPED),
                           left, top,         
                           300, 400,
                           NULL,                 /* Parent window's handle */
                           NULL,                 /* Default to Class Menu */
                           hInst,                /* Instance of window */
                           NULL);       /* Create struct for WM_CREATE */

   //ShowWindow (hWndTrig,SW_SHOWNORMAL);
   UpdateWindow (hWndTrig);
   return GOOD;
}
/*****************************************************************************
**
**  ToolBarMsg
**
*****************************************************************************/
VOID ToolBarMsg(WPARAM WParam, LPARAM LParam)   {
   HWND hToolBar;
   // Pass a message off to the toolbar window
   if (GetToolBarHandle((HANDLE FAR *) &hToolBar) == GOOD) {
      SendMessage(hToolBar, WM_COMMAND, WParam, LParam);
   }
}
/*****************************************************************
*                                                                *
*         EvtWndProc                                             *
*                                                                *
******************************************************************/
long FAR PASCAL TrigWndProc (HWND hWnd, UINT message,
         UINT wParam, LONG lParam) {

HDC            hDc; 
PAINTSTRUCT    ps;
TEXTMETRIC     tm;
static HMENU          hMenu;
HFONT          hFont,hOldFont,hButtonFont;
HPEN           h2Pen,hOldPen;
HWND           evtWindow;
DWORD          dwValue;
static short   cyInterLine;
static short   cxChar, cyChar, cxLength;
char  szString01[] ="      Condition";
char  szString011[]="      Actions   ";
char  szString02[] =" event  ";
char  szString021[]="  enable";
char  szString03[] ="seq";
char  szString04[] ="brk";
//char  szString05[] =" tq     tdis    ton    toff";
char  szString051[]="in";
char  szString052[]="end";
char  szString053[]="on";
char  szString054[]="off";
char  szString055[]="trace";
//char  szString06[] ="    inc0    rst0";
char  szString064[]="inc";
char  szString065[]="rst";
char  szString066[]="counter0";
char  szString067[]="timer0";
//char  szString061[]=" t0on  t0off  t0rst";
char  szString061[]="start";
char  szString062[]="stop";
char  szString063[]="rst";
//char  szString07[] ="    inc1    rst1";
char  szString074[]="inc";
char  szString075[]="rst";
char  szString076[]="counter1";
char  szString077[]="timer1";
//char  szString071[]=" t1on  t1off  t1rst";
char  szString071[]="start";
char  szString072[]="stop";
char  szString073[]="rst";
char  szString08[] ="out";
char  szString081[]="trigger";
char  szString11[] ="Trig In";
char  szString20[] ="cnt0";
char  szString21[] ="cnt1";
char  szString22[] ="tm0";
char  szString23[] ="tm1";
char str[MAXLEN]="0",str1[MAXLEN];
char szString100[100];
U32 c3;
U16 num,curLevel;
int    i,j,height1,height2,tempX,intervalX;
RECT winRect,cliRect;
RETCODE err;
U8 statusExt;
U8 timerUnit;
COUNTER_TYPE function;
HWND tempHandle;
WORD tempControlId;
BOOLEAN flagQualify;

   switch (message) {
      case WM_CREATE:
         hDc = GetDC(hWnd);
         hButtonFont=CreateFont(16,6,0,0,
                  FW_BOLD,0,0,0,ANSI_CHARSET,
                  OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                  DEFAULT_QUALITY, FIXED_PITCH|FF_ROMAN,
                  "TmsRmn");
         hFont=CreateFont(16,6,0,0,
                  FW_NORMAL,0,0,0,ANSI_CHARSET,
                  OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                  DEFAULT_QUALITY, FIXED_PITCH|FF_ROMAN,
                  "TmsRmn");
         hOldFont=SelectObject(hDc,hFont);
         GetTextMetrics(hDc,&tm);
         cxChar = tm.tmMaxCharWidth;
         cxAveChar = tm.tmAveCharWidth;
         cyChar = tm.tmHeight + 3 * tm.tmExternalLeading ;
         cyInterLine = 0.5 * tm.tmHeight;
         cxLength = 10*cxChar;
         cyHeight = 1.7 * cyChar;
         ReleaseDC(hWnd,hDc);

         hMenu=LoadMenu(hInst,
                  "DialogMenu");
         SetMenu(hWnd,hMenu);

         //externalout menu hign-low-high_z
         if ((err=TrigOutActionGet(theTrigger,&statusExt))!=GOOD)
            ErrDisplayError(err,FORCE_POPUP);
         else
              {
            CheckMenuItem(hMenu,IDM_TRIGOEXLOW+statusExt,
                  MF_BYCOMMAND|MF_CHECKED);
         }
         //externalIn menu high-low
         if ((err=TrigExtEventGet(theTrigger,&statusExt))!=GOOD)
            ErrDisplayError(err,FORCE_POPUP);
         else {
            CheckMenuItem(hMenu,IDM_TRIGOINLOW+(int)statusExt,
                  MF_BYCOMMAND|MF_CHECKED);
         }

         // time unit
         if ((err=TrigModeUnitGet(theTrigger,0,&timerUnit))!=GOOD)
            ErrDisplayError(err,FORCE_POPUP);
         else {
            if (timerUnit==0)
               CheckMenuItem(hMenu,IDM_TRIGOTM0EP,MF_BYCOMMAND|MF_CHECKED);
            else {
               CheckMenuItem(hMenu,IDM_TRIGOTM0TM,MF_BYCOMMAND|MF_CHECKED);
               timerUnit=timerUnit+100;
               CheckMenuItem(hMenu,timerUnit,MF_BYCOMMAND|MF_CHECKED);
            }
         }
         if ((err=TrigModeUnitGet(theTrigger,1,&timerUnit))!=GOOD)
            ErrDisplayError(err,FORCE_POPUP);
         else {
            if (timerUnit==0)
               CheckMenuItem(hMenu,IDM_TRIGOTM1EP,MF_BYCOMMAND|MF_CHECKED);
            else {
               CheckMenuItem(hMenu,IDM_TRIGOTM1TM,MF_BYCOMMAND|MF_CHECKED);
               timerUnit=timerUnit+110;
               CheckMenuItem(hMenu,timerUnit,MF_BYCOMMAND|MF_CHECKED);
            }
         }
         //get epclock
         epClock=GetPrivateProfileInt("SystemInfo","EPClock",20,
            OPENFILE);

         //counter unit
         GetPrivateProfileString("TrigInfo","counterValue","dec",
            str,sizeof(str),OPENFILE);
         if (strcmp(str,"dec")==0) {
            flagCounterDec_Hex=IDM_COUNTER_DEC;
            CheckMenuItem(hMenu,IDM_COUNTER_DEC,MF_BYCOMMAND|MF_CHECKED);
         }
         else {
            flagCounterDec_Hex=IDM_COUNTER_HEX;
            CheckMenuItem(hMenu,IDM_COUNTER_HEX,MF_BYCOMMAND|MF_CHECKED);
         }

         RegisterHelpEntry(8,hWnd,HE_TRIGGER);
         InitialCheckBox(hWnd,hButtonFont);

         //timer and counter status
         if ((err=TrigCounterFunctionGet(theTrigger,&function))!=GOOD)
            ErrDisplayError(err,FORCE_POPUP);
         else {
            switch(function) {
               case COUNT_COUNT:
                  flagTMCO_0='C';
                  flagTMCO_1='C';
                  break;
               //case COUNT_TIMER:
               case TIMER_COUNT:
                  flagTMCO_0='C';
                  flagTMCO_1='T';
                  break;
               //case TIMER_COUNT:
               case COUNT_TIMER:
                  flagTMCO_0='T';
                  flagTMCO_1='C';
                  break;
               case TIMER_TIMER:
                  flagTMCO_0='T';
                  flagTMCO_1='T';
                  break;
            }
         }

         for (i=0;i<8;i++) {
            hWndEvtCondition[i] = CreateWindow( "combobox",NULL,
               WS_CHILD | WS_VISIBLE | WS_VSCROLL
               | CBS_DROPDOWNLIST |CBS_SORT,
               4*cxAveChar,cyHeight*(3+i)+5*i,23*cxAveChar,3*cyHeight,
               hWnd, 200+i*20,
               GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
            hWndEvtEnable[i]=CreateWindow("button",NULL,
               WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
               28*cxAveChar,cyHeight*(3+i+0.2)+5*i,3*cxAveChar,0.6*cyHeight,
               hWnd,200+20*i+1,
               GetWindowWord(hWnd,GWW_HINSTANCE),NULL);
            nEvtCond=i;
            SetupLevel(hWnd);
         }

         hWndTmCounter[0] = CreateWindow( "button", NULL,
            WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
            cxAveChar,cyHeight*(3+8)+5*8,6*cxAveChar,cyHeight,
            hWnd, IDB_TMCOUNTER_0,
            GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
         SendMessage(hWndTmCounter[0],WM_SETFONT,hButtonFont,0);

         hWndEvtCondition[8] = CreateWindow( "edit",NULL,
            WS_CHILD | WS_VISIBLE | WS_BORDER |WS_CLIPSIBLINGS
            |ES_AUTOHSCROLL,
            7*cxAveChar,cyHeight*(3+8)+5*8,17*cxAveChar,cyHeight,
            hWnd, 200+20*8,
            GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
         SendMessage(hWndEvtCondition[8],WM_SETFONT,hFont,0);

         hWndEvtEnable[8]=CreateWindow("button",NULL,
            WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
            28*cxAveChar,cyHeight*(3+8+0.2)+5*8,3*cxAveChar,0.6*cyHeight,
            hWnd,200+20*8+1,
            GetWindowWord(hWnd,GWW_HINSTANCE),NULL);

         hWndEvtUnit[0] = CreateWindow( "static","",
            WS_CHILD | WS_VISIBLE,
            24*cxAveChar,cyHeight*(3+8+0.2)+5*8,3*cxAveChar,cyHeight,
            hWnd, NULL,
            GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
         SendMessage(hWndEvtUnit[0],WM_SETFONT,hButtonFont,0);

         nEvtCond=8;
         SetupLevel(hWnd);

         hWndTmCounter[1] = CreateWindow( "button", NULL,
            WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
            cxAveChar,cyHeight*(3+9)+5*9,6*cxAveChar,cyHeight,
            hWnd, IDB_TMCOUNTER_1,
            GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
         SendMessage(hWndTmCounter[1],WM_SETFONT,hButtonFont,0);

         hWndEvtCondition[9] = CreateWindow( "edit",NULL,
            WS_CHILD | WS_VISIBLE | WS_BORDER |WS_CLIPSIBLINGS
            |ES_AUTOHSCROLL,
            7*cxAveChar,cyHeight*(3+9)+5*9,17*cxAveChar,cyHeight,
            hWnd, 200+20*9,
            GetWindowWord(hWnd,GWW_HINSTANCE), NULL);
         SendMessage(hWndEvtCondition[9],WM_SETFONT,hFont,0);

         lpfnOldEdit = (FARPROC)GetWindowLong(
            hWndEvtCondition[8],GWL_WNDPROC);
         SetWindowLong(hWndEvtCondition[8],GWL_WNDPROC,
            (LONG)MakeProcInstance((FARPROC)EditProc,
             GetWindowWord(hWnd,GWW_HINSTANCE)));
         SetWindowLong(hWndEvtCondition[9],GWL_WNDPROC,
            (LONG)MakeProcInstance((FARPROC)EditProc,
             GetWindowWord(hWnd,GWW_HINSTANCE)));

         hWndEvtEnable[9]=CreateWindow("button",NULL,
            WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
            28*cxAveChar,cyHeight*(3+9+0.2)+5*9,3*cxAveChar,0.6*cyHeight,
            hWnd,200+20*9+1,
            GetWindowWord(hWnd,GWW_HINSTANCE),NULL);

         hWndEvtUnit[1]=CreateWindow("static","",
            WS_CHILD|WS_VISIBLE,
            24*cxAveChar,cyHeight*(3+9+0.2)+5*9,3*cxAveChar,0.6*cyHeight,
            hWnd,NULL,
            GetWindowWord(hWnd,GWW_HINSTANCE),NULL);
         SendMessage(hWndEvtUnit[1],WM_SETFONT,hButtonFont,0);

         nEvtCond=9;
         SetupLevel(hWnd);

         //timer and counter status
         if ((err=TrigCounterFunctionGet(theTrigger,&function))!=GOOD)
            ErrDisplayError(err,FORCE_POPUP);
         else {
            switch(function) {
               case COUNT_COUNT:
                  SetWindowText(hWndTmCounter[0],szString20);
                  SetWindowText(hWndTmCounter[1],szString21);
                  break;
               //case COUNT_TIMER:
               case TIMER_COUNT:
                  SetWindowText(hWndTmCounter[0],szString20);
                  SetWindowText(hWndTmCounter[1],szString23);
                  break;
               //case TIMER_COUNT:
               case COUNT_TIMER:
                  SetWindowText(hWndTmCounter[0],szString22);
                  SetWindowText(hWndTmCounter[1],szString21);
                  break;
               case TIMER_TIMER:
                  SetWindowText(hWndTmCounter[0],szString22);
                  SetWindowText(hWndTmCounter[1],szString23);
                  break;
            }
         }

         hWndEvtCondition[10] = CreateWindow( "static","Trigger   In",
            WS_CHILD|WS_VISIBLE,
            5*cxAveChar,cyHeight*(3+10.2)+5*10,18*cxAveChar,0.8*cyHeight,
            hWnd, 200+20*10,
            GetWindowWord(hWnd,GWW_HINSTANCE), NULL);

         hWndEvtEnable[10]=CreateWindow("button",NULL,
            WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
            28*cxAveChar,cyHeight*(3+10+0.2)+5*10,3*cxAveChar,0.6*cyHeight,
            hWnd,200+20*10+1,
            GetWindowWord(hWnd,GWW_HINSTANCE),NULL);

         nEvtCond=10;
         SetupLevel(hWnd);
         //UpdateWindow(hWnd);
         GetWindowRect(hWnd,&winRect);
         GetClientRect(hWnd,&cliRect);
         height1=winRect.bottom-winRect.top;
         height2=cliRect.bottom-cliRect.top;
         widthX=100*cxAveChar;
         heightY=cyHeight*13.2+5*11+(height1-height2);
         MoveWindow(hWnd,nTop,nLeft,widthX,
            heightY,1);
         return 0;
      case WM_MOVE:
      case WM_LBUTTONDOWN:
         tempHandle=GetFocus();
         tempControlId=GetWindowWord(tempHandle,GWW_ID);
         if (tempControlId>=200 && tempControlId <=500)
            SendMessage(tempHandle,CB_SHOWDROPDOWN,FALSE,0);
         break;
      case WM_COMMAND:
         if (wParam>=200 && wParam <=500) {
            nEvtCond=(wParam-200)/20;
            nEvtColumn=(wParam-200)%20;
            if (nEvtColumn>3)
               nEvtAction=nEvtColumn-4;
            //if (nEvtColumn==0 && HIWORD(lParam)==CBN_KILLFOCUS) {
            if (nEvtColumn==0 && HIWORD(lParam)==CBN_CLOSEUP) {
               HandleActiveWindow();
               return 0;
            }
            if (nEvtColumn==0 && HIWORD(lParam)==CBN_SETFOCUS) {
               SetupList(&num);
               if (num==0) {
                  EvtExistsWindow(&evtWindow);
                  if (evtWindow==NULL)
                     EvtOpenWindow(hWnd,50,50,0,0,NULL,NULL,&evtWindow);
                  else
                     BringWindowToTop(evtWindow);
               }
               return 0;
            }
            if (nEvtColumn==0 && HIWORD(lParam)==EN_KILLFOCUS) {
               HandleActiveWindow();
               return 0;
            }
            /*
            if (nEvtCond==10 && HIWORD(lParam)==BN_CLICKED
                   && nEvtColumn==0 ) {
               TrigExtSettingDlg(hWnd);
               GetExtButtonTitle();
               return 0;
            }
            */
            if (HIWORD(lParam)==BN_CLICKED) {
               dwValue=SendMessage(LOWORD(lParam),BM_GETCHECK,0,0);
               TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
               GetWindowText(hWndEvtCondition[nEvtCond],str,MAXLEN);
               if (nEvtColumn==1 && dwValue!=0 && nEvtCond<8
                      && (strcmp(str,initStr)==0)) {
                  SendMessage(hWndEvtEnable[nEvtCond], BM_SETCHECK, 0, 0);
                  ErrDisplayFormattedError(ER_NO_ACTIVE_EVENT, FORCE_POPUP,
                     NULL,NULL,NULL,MB_OK,(S16 FAR *) &buttonID);
                  return 0;
               }
               if (nEvtColumn==1) {
                  err=TrigEventEnableSet(theTrigger,dwValue);
                  if (err==GOOD)
                     SetupCheckBox(hWnd);
                  else {
                     SendMessage(LOWORD(lParam),BM_SETCHECK,!dwValue,0);
                     ErrDisplayFormattedError(err, FORCE_POPUP,
                        NULL,NULL,NULL,MB_OK,(S16 FAR *) &buttonID);
                  }
               }
               if (nEvtColumn==2)
                  err=TrigExtSet(theTrigger,dwValue);
               if (nEvtColumn>2 && nEvtColumn<20) {
                  if (nEvtColumn==3) {
                     HandleSeqOrExtOutAction(hWnd);
                  }
                  else
                     if (dwValue!=0) {
                        ClearActionGroup();
                        TrigActionSet(theTrigger,ConvEvtAction(nEvtAction));
                        SendMessage(LOWORD(lParam),BM_SETCHECK,1,0);
                     }
                     else
                        TrigActionClear(theTrigger,ConvEvtAction(nEvtAction));
               }
            return 0;
            }
         }
         switch(wParam) {
            case IDM_EVTWBKPT:
               ToolBarMsg(MENU_OFFSET + BREAKPOINT_WINDOW, lParam);
               break;
            case IDM_EVTWCPU:
               ToolBarMsg(MENU_OFFSET + CPU_WINDOW, lParam);
               break;
            case IDM_EVTWMEMORY:
               ToolBarMsg(MENU_OFFSET + MEMORY_WINDOW, lParam);
               break;
            case IDM_EVTWPERIPHERAL:
               ToolBarMsg(MENU_OFFSET + PERIPHERAL_WINDOW, lParam);
               break;
            case IDM_EVTWSHELL:
               ToolBarMsg(MENU_OFFSET + SHELL_WINDOW, lParam);
               break;
            case IDM_EVTWSOURCE:
               ToolBarMsg(MENU_OFFSET + SOURCE_WINDOW, lParam);
               break;
            case IDM_EVTWSTACK:
               ToolBarMsg(MENU_OFFSET + STACK_WINDOW, lParam);
               break;
            case IDM_EVTWSTATUS:
               ToolBarMsg(MENU_OFFSET + STATUS_WINDOW, lParam);
               break;
            case IDM_EVTWSPA:
               ToolBarMsg(MENU_OFFSET + SPA_WINDOW, lParam);
               break;
            case IDM_EVTWTOOLBAR:
               ToolBarMsg(MENU_OFFSET + TOOLBAR_WINDOW, lParam);
               break;
            case IDM_EVTWTRACE:
               ToolBarMsg(MENU_OFFSET + TRACE_WINDOW, lParam);
               break;
            case IDM_EVTWTRIGGER:
               ToolBarMsg(MENU_OFFSET + TRIGGER_WINDOW, lParam);
               break;
            case IDM_EVTWVARIABLE:
               ToolBarMsg(MENU_OFFSET + VARIABLE_WINDOW, lParam);
               break;
            case IDB_TMCOUNTER_0:
               GetWindowText(hWndTmCounter[0],str,MAXLEN);
               TrigSeqLevelGet(theTrigger,&curLevel);
               for (nEvtCond=0;nEvtCond<11;nEvtCond++) {
                  TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
                  for (j=0;j<4;j++) {
                     TrigSeqLevelSet(theTrigger,j);
                     TrigActionClear(theTrigger,CNT0_INC_MASK);
                     TrigActionClear(theTrigger,TC0_RST_MASK);
                  }
               }
               TrigSeqLevelSet(theTrigger,curLevel);
               SetWindowText(hWndEvtCondition[8],"1");
               if (strcmp(str,szString20)==0) {
                  GetWindowText(hWndTmCounter[1],str,MAXLEN);
                  if (strcmp(str,szString21)==0)
                     //err=TrigCounterFunctionSet(theTrigger,TIMER_COUNT);
                     err=TrigCounterFunctionSet(theTrigger,COUNT_TIMER);
                  else
                     err=TrigCounterFunctionSet(theTrigger,TIMER_TIMER);
                  TrigCounterFunctionGet(theTrigger,&function);
                  //if (function==TIMER_COUNT || function==TIMER_TIMER) {
                  if (function==COUNT_TIMER || function==TIMER_TIMER) {
                      SetWindowText(hWndTmCounter[0],szString22);
                      flagTMCO_0='T';
                  }
               }
               else {
                  GetWindowText(hWndTmCounter[1],str,MAXLEN);
                  if (strcmp(str,szString21)==0)
                     err=TrigCounterFunctionSet(theTrigger,COUNT_COUNT);
                  else
                     //err=TrigCounterFunctionSet(theTrigger,COUNT_TIMER);
                     err=TrigCounterFunctionSet(theTrigger,TIMER_COUNT);
                  TrigCounterFunctionGet(theTrigger,&function);
                  //if (function==COUNT_COUNT || function==COUNT_TIMER) {
                  if (function==COUNT_COUNT || function==TIMER_COUNT) {
                     SetWindowText(hWndTmCounter[0],szString20);
                     flagTMCO_0='C';
                  }
               }
               UpdateTmCounterWindow(hWnd);
               SendMessage(hWnd,WM_COMMAND,200+20*8,
                  MAKELONG(0,EN_KILLFOCUS));
               AppendTmCounterUnit(str,0,str1);
               //SetFocus(hWndEvtCondition[8]);
               return 0;
            case IDB_TMCOUNTER_1:
               GetWindowText(hWndTmCounter[1],str,MAXLEN);
               TrigSeqLevelGet(theTrigger,&curLevel);
               for (nEvtCond=0;nEvtCond<11;nEvtCond++) {
                  TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
                  for (j=0;j<4;j++) {
                     TrigSeqLevelSet(theTrigger,j);
                     TrigActionClear(theTrigger,CNT1_INC_MASK);
                     TrigActionClear(theTrigger,TC1_RST_MASK);
                  }
               }
               TrigSeqLevelSet(theTrigger,curLevel);
               SetWindowText(hWndEvtCondition[9],"1");
               if (strcmp(str,szString21)==0) {
                  GetWindowText(hWndTmCounter[0],str,MAXLEN);
                  if (strcmp(str,szString20)==0)
                     //err=TrigCounterFunctionSet(theTrigger,COUNT_TIMER);
                     err=TrigCounterFunctionSet(theTrigger,TIMER_COUNT);
                  else
                     err=TrigCounterFunctionSet(theTrigger,TIMER_TIMER);
                  TrigCounterFunctionGet(theTrigger,&function);
                  //if (function==COUNT_TIMER || function==TIMER_TIMER){
                  if (function==TIMER_COUNT || function==TIMER_TIMER){
                     SetWindowText(hWndTmCounter[1],szString23);
                     flagTMCO_1='T';
                  }
               }
               else {
                  GetWindowText(hWndTmCounter[0],str,MAXLEN);
                  if (strcmp(str,szString20)==0)
                     err=TrigCounterFunctionSet(theTrigger,COUNT_COUNT);
                  else
                     //err=TrigCounterFunctionSet(theTrigger,TIMER_COUNT);
                     err=TrigCounterFunctionSet(theTrigger,COUNT_TIMER);
                  TrigCounterFunctionGet(theTrigger,&function);
                  //if (function==COUNT_COUNT || function==TIMER_COUNT) {
                  if (function==COUNT_COUNT || function==COUNT_TIMER) {
                     SetWindowText(hWndTmCounter[1],szString21);
                     flagTMCO_1='C';
                  }
               }
               UpdateTmCounterWindow(hWnd);
               SendMessage(hWnd,WM_COMMAND,200+20*9,
                  MAKELONG(0,EN_KILLFOCUS));
               AppendTmCounterUnit(str,1,str1);
               //SetFocus(hWndEvtCondition[9]);
               return 0;
            case IDM_TRIGOTM0EP:
            //case IDM_UNIT_H_0:
            //case IDM_UNIT_M_0:
            case IDM_UNIT_S_0:
            case IDM_UNIT_MM_0:
            case IDM_UNIT_UM_0:
               CheckMenuItem(hMenu,IDM_TRIGOTM0EP,MF_BYCOMMAND|MF_UNCHECKED);
               for (i=IDM_UNIT_S_0;i<IDM_UNIT_UM_0+1;i++)
                  CheckMenuItem(hMenu,i,MF_BYCOMMAND|MF_UNCHECKED);
               if (wParam==IDM_TRIGOTM0EP)
                  TrigModeUnitSet(theTrigger,0,0);
               else
                  TrigModeUnitSet(theTrigger,0,(wParam-100));
               TrigModeUnitGet(theTrigger,0,&timerUnit);
               if (timerUnit==0)
                  CheckMenuItem(hMenu,IDM_TRIGOTM0EP,
                     MF_BYCOMMAND|MF_CHECKED);
               else
                  CheckMenuItem(hMenu,100+timerUnit,
                     MF_BYCOMMAND|MF_CHECKED);
               AppendTmCounterUnit(str,0,str1);
               SendMessage(hWnd,WM_COMMAND,200+20*8,
                  MAKELONG(0,EN_KILLFOCUS));
               //SetFocus(hWndEvtCondition[8]);
               return 0;
            case IDM_TRIGOTM1EP:
            //case IDM_UNIT_H_1:
            //case IDM_UNIT_M_1:
            case IDM_UNIT_S_1:
            case IDM_UNIT_MM_1:
            case IDM_UNIT_UM_1:
               CheckMenuItem(hMenu,IDM_TRIGOTM1EP,MF_BYCOMMAND|MF_UNCHECKED);
               for (i=IDM_UNIT_S_1;i<IDM_UNIT_UM_1+1;i++)
                  CheckMenuItem(hMenu,i,MF_BYCOMMAND|MF_UNCHECKED);
               if (wParam==IDM_TRIGOTM1EP)
                  TrigModeUnitSet(theTrigger,1,0);
               else
                  TrigModeUnitSet(theTrigger,1,(wParam-110));
               TrigModeUnitGet(theTrigger,1,&timerUnit);
               if (timerUnit==0)
                  CheckMenuItem(hMenu,IDM_TRIGOTM1EP,
                     MF_BYCOMMAND|MF_CHECKED);
               else
                  CheckMenuItem(hMenu,110+timerUnit,
                     MF_BYCOMMAND|MF_CHECKED);
               AppendTmCounterUnit(str,1,str1);
               SendMessage(hWnd,WM_COMMAND,200+20*9,
                  MAKELONG(0,EN_KILLFOCUS));
               //SetFocus(hWndEvtCondition[9]);
               return 0;
            case IDM_COUNTER_DEC:
            case IDM_COUNTER_HEX:
               CheckMenuItem(hMenu,IDM_COUNTER_DEC,MF_BYCOMMAND|MF_UNCHECKED);
               CheckMenuItem(hMenu,IDM_COUNTER_HEX,MF_BYCOMMAND|MF_UNCHECKED);
               CheckMenuItem(hMenu,wParam,MF_BYCOMMAND|MF_CHECKED);
               flagCounterDec_Hex=wParam;
               return 0;
            case IDM_TRIGL0:
               SetWindowText(hWnd,"Trigger - Level 0");
               SetFocus(hWndEvtEnable[0]);
               TrigSeqLevelSet(theTrigger,0);
               for (i=0;i<11;i++) {
                 nEvtCond=i;
                 SetupLevel(hWnd);
               }
               UpdateWindow(hWnd);
               return 0;
            case IDM_TRIGL1:
               SetWindowText(hWnd,"Trigger - Level 1");
               SetFocus(hWndEvtEnable[0]);
               TrigSeqLevelSet(theTrigger,1);
               for (i=0;i<11;i++) {
                 nEvtCond=i;
                 SetupLevel(hWnd);
               }
               UpdateWindow(hWnd);
               return 0;
            case IDM_TRIGL2:
               SetWindowText(hWnd,"Trigger - Level 2");
               SetFocus(hWndEvtEnable[0]);
               TrigSeqLevelSet(theTrigger,2);
               for(i=0;i<11;i++) {
                 nEvtCond=i;
                 SetupLevel(hWnd);
               }
               UpdateWindow(hWnd);
               return 0;
            case IDM_TRIGL3:
               SetWindowText(hWnd,"Trigger - Level 3");
               SetFocus(hWndEvtEnable[0]);
               TrigSeqLevelSet(theTrigger,3);
               for(i=0;i<11;i++) {
                 nEvtCond=i;
                 SetupLevel(hWnd);
               }
               UpdateWindow(hWnd);
               return 0;
            case IDM_TRIGOCONTROL:
               TrcTraceControl(hWnd);
               return 0;
            case IDM_TRIGOEXLOW:
            case IDM_TRIGOEXHIGH:
            case IDM_TRIGOEXHIGHZ:
               CheckMenuItem(hMenu,IDM_TRIGOEXLOW,MF_BYCOMMAND|MF_UNCHECKED);
               CheckMenuItem(hMenu,IDM_TRIGOEXHIGH,MF_BYCOMMAND|MF_UNCHECKED);
               CheckMenuItem(hMenu,IDM_TRIGOEXHIGHZ,MF_BYCOMMAND|MF_UNCHECKED);
               if (wParam==IDM_TRIGOEXLOW)   i=IDM_TRIGOEXLOW;
               if (wParam==IDM_TRIGOEXHIGH)  i=IDM_TRIGOEXHIGH;
               if (wParam==IDM_TRIGOEXHIGHZ) i=IDM_TRIGOEXHIGHZ;
               CheckMenuItem(hMenu,i,MF_BYCOMMAND|MF_CHECKED);
               if ((err=TrigOutActionSet(theTrigger,i-IDM_TRIGOEXLOW))!=GOOD)
                  ErrDisplayError(err,FORCE_POPUP);
               return 0;
            case IDM_TRIGOINLOW:
            case IDM_TRIGOINHIGH:
               CheckMenuItem(hMenu,IDM_TRIGOINHIGH,MF_BYCOMMAND|MF_UNCHECKED);
               CheckMenuItem(hMenu,IDM_TRIGOINLOW,MF_BYCOMMAND|MF_UNCHECKED);
               if (wParam==IDM_TRIGOINLOW)   i=IDM_TRIGOINLOW;
               if (wParam==IDM_TRIGOINHIGH)  i=IDM_TRIGOINHIGH;
               CheckMenuItem(hMenu,i,MF_BYCOMMAND|MF_CHECKED);
               if ((err=TrigExtEventSet(theTrigger,i-IDM_TRIGOINLOW))!=GOOD)
                  ErrDisplayError(err,FORCE_POPUP);
               return 0;
            case IDM_TRIGHINDEX:
               WinHelp(hWnd, "PWRVIEWS.HLP", HELP_CONTEXT, HE_CONTENTS);
               return 0;
            case IDM_TRIGHHELP:
               WinHelp(hWnd, "PWRVIEWS.HLP", HELP_HELPONHELP, HE_CONTENTS);
               return 0;
            case IDM_TRIGHEVENT:
               WinHelp(hWnd, "PWRVIEWS.HLP", HELP_CONTEXT, HE_TRIGGER);
               return 0;
            case IDM_TRIGEEVENTS:
               EvtExistsWindow(&evtWindow);
               if (evtWindow==NULL)
                  EvtOpenWindow(hWnd,50,50,0,0,NULL,NULL,&evtWindow);
               else
                  BringWindowToTop(evtWindow);
               return 0;
            case IDM_TRIGACCEPT:
               if ((err=TrigCheckQualify(theTrigger,&flagQualify))!=GOOD)
                  return err;
               if (flagQualify) {
                  strcpy(szString100,"Trace Qualify has been set. Therefore, instruction mode in trace window can't be used");
                  ErrMessageBoxL(szString100);
               }
               if ((err=TrigTriggerAccept(theTrigger))==GOOD) {
                  strcpy(str,"Accept successfully!!");
                  ErrMessageBoxL(str);
               }
               else {
                  strcpy(str,"Can't be accepted !!");
                  ErrMessageBoxL(str);
               }
               return 0;
            case IDM_TRIGFEXIT:
               //DestroyWindow(hWnd);
               SendMessage(hWnd,WM_CLOSE,0,0);
               return 0;
         }
         break;
      case WM_PAINT :
         hDc=BeginPaint(hWnd,&ps);
         /*
         h2Pen=CreatePen(PS_SOLID,2,RGB(0,0,0));
         hOldPen=SelectObject(hDc,h2Pen);
         */
         height1=14.2*cyHeight+5*11;
         //Rectangle(hDc,0,0,widthX-2,height1);
         for (i=0;i<8;i++) {
            itoa((U16)i,str,10);
            TextOut(hDc,1.5*cxAveChar,cyHeight*(3.2+i)+5*i,str,
               strlen(str));
         }
         intervalX=5*cxAveChar;
         tempX=24*cxAveChar;
         hFont=CreateFont(1.25*cyChar,0.8*cxAveChar,0,0,
                  FW_NORMAL,0,0,0,ANSI_CHARSET,
                  OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                  DEFAULT_QUALITY, FIXED_PITCH|FF_ROMAN,
                  "TmsRmn");
         hOldFont=SelectObject(hDc,hFont);
         //edit, combox control name
         // condition , actions
         TextOut(hDc,cxAveChar,0.1*cyHeight,szString01,lstrlen(szString01));
         TextOut(hDc,2*tempX,0.1*cyHeight,szString011,lstrlen(szString011));
         MoveTo(hDc,0,0.9*cyHeight);
         LineTo(hDc,widthX,0.9*cyHeight);
         //MoveTo(hDc,0,height1);
         //LineTo(hDc,widthX,height1);
         //event , enable
         TextOut(hDc,5*cxAveChar,1.5*cyHeight,
            szString02,lstrlen(szString02));
         TextOut(hDc,22*cxAveChar,1.5*cyHeight,
            szString021,lstrlen(szString021));
         MoveTo(hDc,0,2.9*cyHeight);
         LineTo(hDc,105*cxAveChar,2.9*cyHeight);
         //seq
         tempX=33*cxAveChar;
         TextOut(hDc,tempX,1.5*cyHeight,
            szString03,lstrlen(szString03));
         MoveTo(hDc,tempX-cxAveChar,0);
         LineTo(hDc,tempX-cxAveChar,height1);
         //h2Pen=SelectObject(hDc,hOldPen);
         //brk
         tempX=tempX+intervalX;
         TextOut(hDc,tempX,1.5*cyHeight,
            szString04,lstrlen(szString04));
         MoveTo(hDc,tempX-cxAveChar,0.9*cyHeight);
         LineTo(hDc,tempX-cxAveChar,height1);
         //trace in,end,on,off
         tempX=tempX+intervalX;
         TextOut(hDc,tempX+6*cxAveChar,cyHeight,
            szString055,lstrlen(szString055));
         MoveTo(hDc,tempX-cxAveChar,1.9*cyHeight);
         LineTo(hDc,widthX,1.9*cyHeight);
         TextOut(hDc,tempX+0.5*cxAveChar,2*cyHeight,
            szString051,lstrlen(szString051));
         TextOut(hDc,tempX+3.5*cxAveChar,2*cyHeight,
            szString052,lstrlen(szString052));
         TextOut(hDc,tempX+8.5*cxAveChar,2*cyHeight,
            szString053,lstrlen(szString053));
         TextOut(hDc,tempX+12.5*cxAveChar,2*cyHeight,
            szString054,lstrlen(szString054));
         MoveTo(hDc,tempX-cxAveChar,0.9*cyHeight);
         LineTo(hDc,tempX-cxAveChar,height1);
         //counter0 inc,rst  timer0 start,stop,rst
         tempX=tempX+3.5*intervalX;
         if (flagTMCO_0=='C') {
            TextOut(hDc,tempX+2.5*cxAveChar,cyHeight,
               szString066,lstrlen(szString066));
            TextOut(hDc,tempX+3*cxAveChar,2*cyHeight,
               szString064,lstrlen(szString064));
            TextOut(hDc,tempX+8*cxAveChar,2*cyHeight,
               szString065,lstrlen(szString065));
        }
        else {
           TextOut(hDc,tempX+4*cxAveChar,cyHeight,
              szString067,lstrlen(szString067));
           TextOut(hDc,tempX,2*cyHeight,
              szString061,lstrlen(szString061));
           TextOut(hDc,tempX+5.5*cxAveChar,2*cyHeight,
              szString062,lstrlen(szString062));
           TextOut(hDc,tempX+11*cxAveChar,2*cyHeight,
              szString063,lstrlen(szString063));
         }
         MoveTo(hDc,tempX-cxAveChar,0.9*cyHeight);
         LineTo(hDc,tempX-cxAveChar,height1);
         //counter1 inc,rst   timer1 start,stop,rst
         tempX=tempX+3*intervalX;
         if (flagTMCO_1=='C') {
            TextOut(hDc,tempX+2.5*cxAveChar,cyHeight,
               szString076,lstrlen(szString076));
            TextOut(hDc,tempX+3*cxAveChar,2*cyHeight,
               szString074,lstrlen(szString074));
            TextOut(hDc,tempX+8*cxAveChar,2*cyHeight,
               szString075,lstrlen(szString075));
         }
         else {
            TextOut(hDc,tempX+4*cxAveChar,cyHeight,
               szString077,lstrlen(szString077));
            TextOut(hDc,tempX,2*cyHeight,
               szString071,lstrlen(szString071));
            TextOut(hDc,tempX+5.5*cxAveChar,2*cyHeight,
               szString072,lstrlen(szString072));
            TextOut(hDc,tempX+11*cxAveChar,2*cyHeight,
               szString073,lstrlen(szString073));
         }
         MoveTo(hDc,tempX-cxAveChar,0.9*cyHeight);
         LineTo(hDc,tempX-cxAveChar,height1);
         //trig out
         tempX=tempX+3*intervalX;
         TextOut(hDc,tempX,cyHeight,
            szString081,lstrlen(szString081));
         TextOut(hDc,tempX+2*cxAveChar,2*cyHeight,
            szString08,lstrlen(szString08));
         MoveTo(hDc,tempX-cxAveChar,0.9*cyHeight);
         LineTo(hDc,tempX-cxAveChar,height1);
         hFont=SelectObject(hDc,hOldFont);
         DeleteObject(hFont);
         DeleteObject(h2Pen);
         EndPaint(hWnd,&ps);
         return 0;
      case WM_CLOSE:
         TrigModeUnitGet(theTrigger,0,&timerUnit);
         TimerUnitInt2Str(timerUnit,str);
         WritePrivateProfileString("TrigInfo","timer0Unit",str,
            OPENFILE);
         TrigModeUnitGet(theTrigger,1,&timerUnit);
         TimerUnitInt2Str(timerUnit,str);
         WritePrivateProfileString("TrigInfo","timer1Unit",str,
            OPENFILE);
         if (flagCounterDec_Hex==IDM_COUNTER_DEC)
            WritePrivateProfileString("TrigInfo","counterValue","dec",
               OPENFILE);
         else
            WritePrivateProfileString("TrigInfo","counterValue","hex",
               OPENFILE);
         TrigOutActionGet(theTrigger,&statusExt);
         if (statusExt==1)
            WritePrivateProfileString("TrigInfo","ExternalOut","high",
               OPENFILE);
         if (statusExt==0)
            WritePrivateProfileString("TrigInfo","ExternalOut","low",
               OPENFILE);
         if (statusExt==2)
            WritePrivateProfileString("TrigInfo","ExternalOut","high-z",
               OPENFILE);
         TrigExtEventGet(theTrigger,&statusExt);
         if (statusExt==0)
            WritePrivateProfileString("TrigInfo","trigIn","low",
               OPENFILE);
         if (statusExt==1)
            WritePrivateProfileString("TrigInfo","trigIn","high",
               OPENFILE);
         DeleteObject(hOldFont);
         if ((err=TrigTriggerClose(theTrigger))!=GOOD){
            ErrDisplayError(err,FORCE_POPUP);
            break;
         }
         DestroyWindow(hWnd);
         hWndTrig=NULL;
         break;
      case WM_DESTROY :
         //SelectObject(hDc,hOldFont);
         hWndTrig=NULL;
         //PostQuitMessage (0);
         break;
   }
   return DefWindowProc (hWnd, message, wParam, lParam);
}
/************************************************************************
**
**          TimerUnitInt2Str
**
************************************************************************/
RETCODE TimerUnitInt2Str(U8 timerUnit,char *str) {
   switch(timerUnit) {
      case 0:  strcpy(str,"ep");
               return GOOD;
      case 3:  strcpy(str,"s");
               return GOOD;
      case 4:  strcpy(str,"ms");
               return GOOD;
      case 5:  strcpy(str,"us");
               return GOOD;
      }
}
/************************************************************************
**
**          HandleActiveWindow
**
************************************************************************/
void HandleActiveWindow() {
U32 i;
U16 nSel,nLevel;
int buttonID;
char str[MAXLEN],str1[MAXLEN];
RETCODE err;
U32 numclock;

   if (nEvtColumn==0) {
      TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
      switch(nEvtCond) {
         case 8:
            GetWindowText(hWndEvtCondition[8],str,MAXLEN);
            //i=atol(str);
            //GetWindowText(hWndTmCounter[0],str,MAXLEN);
            if ((err=TmCounter2Server(0,str,&numclock))==GOOD)
               if ((err=TrigCounterValueSet(theTrigger,0,
                  numclock))!=GOOD)
                     ErrDisplayError(err,FORCE_POPUP);
                     /*
                     ErrDisplayFormattedError(err, FORCE_POPUP,
                        NULL,NULL,NULL,0,(S16 FAR *) &buttonID);
                     */
            TrigCounterValueGet(theTrigger,0,&i);
            GetWindowText(hWndTmCounter[0],str,MAXLEN);
            if ((strcmp(str,"cnt0")==0) &&
               (flagCounterDec_Hex==IDM_COUNTER_HEX))
               ultoa(Server2TmCounter(0,i),str,16);

            else
               ultoa(Server2TmCounter(0,i),str,10);
            AppendTmCounterUnit(str,0,str1);
            SetWindowText(hWndEvtCondition[8],str1);
            break;
         case 9:
            GetWindowText(hWndEvtCondition[9],str,MAXLEN);
            //i=atol(str);
            //GetWindowText(hWndTmCounter[1],str,MAXLEN);
            if ((err=TmCounter2Server(1,str,&numclock))==GOOD)
               if ((err=TrigCounterValueSet(theTrigger,1,
                  numclock))!=GOOD)
                     ErrDisplayError(err,FORCE_POPUP);
                     /*
                     ErrDisplayFormattedError(err, FORCE_POPUP,
                        NULL,NULL,NULL,0,(S16 FAR *) &buttonID);
                     */
            TrigCounterValueGet(theTrigger,1,&i);
            GetWindowText(hWndTmCounter[1],str,MAXLEN);
            if ((strcmp(str,"cnt1")==0) &&
               (flagCounterDec_Hex==IDM_COUNTER_HEX))
               ultoa(Server2TmCounter(1,i),str,16);
            else
               ultoa(Server2TmCounter(1,i),str,10);
            AppendTmCounterUnit(str,1,str1);
            SetWindowText(hWndEvtCondition[9],str1);
            break;
         case 10:
            break;
         default:
            nSel=(WORD)SendMessage(hWndEvtCondition[nEvtCond],
                    CB_GETCURSEL, 0, 0L);
            SendMessage(hWndEvtCondition[nEvtCond], CB_GETLBTEXT,
               nSel, (DWORD)str);
            TrigSeqLevelGet(theTrigger,&nLevel);
            if (strcmp(str,initStr)==0)
               for (i=0;i<4;i++) {
                  TrigSeqLevelSet(theTrigger,i);
                  TrigClearTrigNameEnableAction();
               }
            else
               for (i=0;i<4;i++) {
                  TrigSeqLevelSet(theTrigger,i);
                  TrigEventNameSet(theTrigger,str);
               }
            TrigSeqLevelSet(theTrigger,nLevel);
            break;
      } //end of switch
   }  //end of if
}
/************************************************************************
**
**        TrigClearTrigNameEnableAction
**
************************************************************************/
RETCODE EXPORT TrigClearTrigNameEnableAction(VOID) {
U8 i;
U16 num,nLevel;
   TrigEventNameSet(theTrigger,"\0");
   TrigEventEnableSet(theTrigger,0);
   for (i=0;i<16;i++)
      TrigActionClear(theTrigger,ConvEvtAction(i));
   TrigSeqLevelGet(theTrigger,&nLevel);
   TrigActionSet(theTrigger,nLevel);
   SendMessage(hWndTrig,WM_COMMAND,200+20*nEvtCond+1,
      MAKELONG(0,BN_CLICKED));
   SetupList(&num);
   /*
   for (i=0;i<16;i++)
      ShowWindow(hWndEvtAction[nEvtCond][i],SW_HIDE);
   ShowWindow(hWndEvtSeq[nEvtCond],SW_HIDE);
   SendMessage(hWndEvtEnable[nEvtCond], BM_SETCHECK, 0, 0);
   UpdateWindow(hWndTrig);
   */
   return GOOD;
}
/*****************************************************************************
**
**  nCwRegisterClasses
**
*****************************************************************************/
int nCwRegisterClasses(VOID) {
   WNDCLASS   wndclass;    /* struct to define a window class */
   HINSTANCE  hInstance;
   HWND hToolBar;
   memset(&wndclass, 0x00, sizeof(WNDCLASS));

   if (GetToolBarHandle((HANDLE FAR *) &hToolBar) == GOOD) {
      hInstance = ((HINSTANCE) GetWindowWord(hToolBar, GWW_HINSTANCE));
      wndclass.hIcon = LoadIcon(hInstance, "TRIGGER");
   }
   /* load WNDCLASS with window's characteristics */
   wndclass.style = CS_HREDRAW | CS_VREDRAW; // | CS_BYTEALIGNWINDOW;
   wndclass.lpfnWndProc = TrigWndProc;

   /* Extra storage for Class and Window objects  */
   wndclass.cbClsExtra = 0;
   wndclass.cbWndExtra = 0;
   wndclass.hInstance = hInst;
   wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);

   /* Create brush for erasing background */
   wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
   wndclass.lpszMenuName = NULL;   /* Menu Name is App Name */
   wndclass.lpszClassName = szAppName; /* Class Name is App Name */
   if(!RegisterClass(&wndclass))
      return -1;
   return(0);
}
/*****************************************************************************
**
**  TrigOpenWindow
**
*****************************************************************************/
RETCODE EXPORT TrigOpenWindow(HWND parent,int left,int top,int width,
     int height,DWORD dwStyle,DWORD dwExStyle,HWND *evtWindow) {
RETCODE err=GOOD;

   if (hWndTrig == NULL) {
      err = CreateEvtPresenter(hLib, left, top,
               width, height);
      *evtWindow = hWndTrig;
   }
   return err;
}
/*****************************************************************************
**
**  TrigCloseWindow
**
*****************************************************************************/
RETCODE EXPORT TrigCloseWindow() {
   if (hWndTrig != NULL) {
      TrigTriggerClose(theTrigger);
      hWndTrig = NULL;
   }
   return GOOD;
}
/*****************************************************************************
**
**  TrigExistsWindow
**
*****************************************************************************/
RETCODE EXPORT TrigExistsWindow(HWND *EvtHandle) {
   *EvtHandle = hWndTrig;
   return (GOOD);
}
/*******************************************************************
**
**                    Local Function
**
********************************************************************/
/****************************************************************
**
**      GetExtButtonTitle
**
******************************************************************/
/*
void GetExtButtonTitle() {
U8  extInBit;
BOOLEAN extEnable;
char extInLH[3];
char ButtonTitle[20];
   strcpy(ButtonTitle,"Clear");
   TrigExtEventGet(theTrigger,&extInBit,&extEnable);

   if (extEnable)
      wsprintf(extInLH,"%s","high");
   else
      strcpy(extInLH,"low");
   if (extInBit<8)
      wsprintf(ButtonTitle,"Bit %d %s",extInBit,extInLH);
   SetWindowText(hWndEvtCondition[10],ButtonTitle);
}
*/
/****************************************************************
**
**     ClearActionGroup
**
****************************************************************/
void ClearActionGroup() {
int start,end,i;
   /* trace on off disable qualify*/
   if (nEvtColumn==4)
      start=end=0;
   if (nEvtColumn==15)
      start=end=11;
   if (nEvtColumn>=5 && nEvtColumn<=8) {
      start=1;
      end=4;
   }
   if (nEvtColumn>=9 && nEvtColumn<=11) {
      start=5;
      end=4;
   }
   if (nEvtColumn>=12 && nEvtColumn<=14) {
      start=8;
      end=7;
   }
   if (nEvtColumn==16 || nEvtColumn==17) {
      start=12;
      end=13;
   }
   if (nEvtColumn==18 || nEvtColumn==19) {
      start=14;
      end=15;
   }
   for (i=start;i<=end;i++) {
      SendMessage(hWndEvtAction[nEvtCond][i], BM_SETCHECK, 0, 0);
      TrigActionClear(theTrigger,WhichBitsWillClear(ConvEvtAction(i)));
   }
}
/*************************************************************
**
**   AddActionChecks
**
**************************************************************/
void AddActionChecks(HWND hWnd){
int i;

   if (nEvtCond>=0 && nEvtCond<11) {
      for (i=0;i<5;i++)
         ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
      ShowWindow(hWndEvtAction[nEvtCond][11],SW_SHOW);
      if (flagTMCO_0=='T')
         for (i=5;i<8;i++)
            ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
      else
         for (i=12;i<14;i++)
            ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
      if (flagTMCO_1=='T')
         for (i=8;i<11;i++)
            ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
      else
         for (i=14;i<16;i++)
            ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
   }
}
/*****************************************************************
**
**       SetupList
**
*****************************************************************/
void SetupList(U16 *num) {
int i,j;
char evtName[MAXLEN];
HWND evtWindow;

   SendMessage(hWndEvtCondition[nEvtCond],CB_RESETCONTENT,0,0);
   /* Go to event server and get the list of defined
      events and send them to the combo box. */
   EvtNumDefinedEvents(theEvent,num);
   SendMessage(hWndEvtCondition[nEvtCond],CB_ADDSTRING,0,
      (DWORD)initStr);
   for (i=0;i<*num;i++) {
      EvtGetNextEvent(theEvent,evtName,MAXLEN);
      if (lstrlen(evtName)!=0)
         SendMessage(hWndEvtCondition[nEvtCond],
            CB_ADDSTRING,0,(DWORD)evtName);
   }
   TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
   TrigEventNameGet(theTrigger,evtName,MAXLEN);
   if (evtName[0]=='\0')
      strcpy(evtName,initStr);
   SendMessage(hWndEvtCondition[nEvtCond],CB_SELECTSTRING,
      0,(LPSTR)evtName);
   SetWindowText(hWndEvtCondition[nEvtCond],(LPSTR)evtName);
}
/***************************************************************
**
**            ConvEvtCond
**
****************************************************************/
EVENT_COND ConvEvtCond(int line){
   switch(line) {
      case 0:  return EV0_COND;
      case 1:  return EV1_COND;
      case 2:  return EV2_COND;
      case 3:  return EV3_COND;
      case 4:  return EV4_COND;
      case 5:  return EV5_COND;
      case 6:  return EV6_COND;
      case 7:  return EV7_COND;
      case 8:  return TC0_COND;
      case 9:  return TC1_COND;
      case 10: return EXT_COND;
   }
   return 0;
}
/*****************************************************************
**
**           ConvEvtAction
**
******************************************************************/
ACTION_MASK ConvEvtAction(int col) {
   switch(col) {
      case 0: return BRK_MASK;
      case 1: return TRC_QUAL_MASK;
      case 2: return TRC_DIS_MASK;
      case 3: return TRC_START_MASK;
      case 4: return TRC_STOP_MASK;
      case 5: return TMR0_START_MASK;
      case 6: return TMR0_STOP_MASK;
      case 7: return TC0_RST_MASK;
      case 8: return TMR1_START_MASK;
      case 9: return TMR1_STOP_MASK;
      case 10: return TC1_RST_MASK;
      case 11: return TRIG_OUT_MASK;
      case 12: return CNT0_INC_MASK;
      case 13: return TC0_RST_MASK;
      case 14: return CNT1_INC_MASK;
      case 15: return TC1_RST_MASK;
   }
   return 0;
}
/*****************************************************************
**
**           ConvLevel2ActionMask
**
******************************************************************/
ACTION_MASK ConvLevel2ActionMask(int level) {
   switch(level) {
      case 0: return LV0_MASK;
      case 1: return LV1_MASK;
      case 2: return LV2_MASK;
      case 3: return LV3_MASK;
   }
   return 0;
}
/*****************************************************************
**
**        SetupCheckBox
**
******************************************************************/
void SetupCheckBox(HWND hWnd) {
BOOLEAN c1,c2;
int i,j;
ACTION_MASK actionMask;
int value;
char str[MAXLEN];
U16 seqLevel;

   TrigEventEnableGet(theTrigger,&c1);
   SendMessage(hWndEvtEnable[nEvtCond],BM_SETCHECK,c1,0);
   //ShowWindow(hWndEvtExtIn[nEvtCond],SW_HIDE);
   ShowWindow(hWndEvtSeq[nEvtCond],SW_HIDE);
   for(i=0;i<16;i++) {
      ShowWindow(hWndEvtAction[nEvtCond][i],SW_HIDE);
   }
   if (c1!=0) {
      /*
      if (nEvtCond>=0 && nEvtCond <10)
         ShowWindow(hWndEvtExtIn[nEvtCond],SW_SHOW);
      */
      ShowWindow(hWndEvtSeq[nEvtCond],SW_SHOW);
      AddActionChecks(hWnd);
      TrigExtGet(theTrigger,&c2);
      if (c2!=0)
         value=1;
      else
        value=0;
      SendMessage(hWndEvtExtIn[nEvtCond],BM_SETCHECK,value,0);
      TrigActionGet(theTrigger,&actionMask);
      for(j=0;j<16;j++) {
         nEvtAction=j;
         if (ConvActionMask2One(actionMask,ConvEvtAction(nEvtAction)))
            SendMessage(hWndEvtAction[nEvtCond][j],BM_SETCHECK,1,0);
         else
            SendMessage(hWndEvtAction[nEvtCond][j],BM_SETCHECK,0,0);
      }
      for (j=0;j<4;j++)
        if (ConvActionMask2One(actionMask,ConvLevel2ActionMask(j))) {
           TrigSeqLevelGet(theTrigger,&seqLevel);
           if (j==seqLevel)
              SetWindowText(hWndEvtSeq[nEvtCond],"no");
           else {
              itoa((U16)j,str,10);
              SetWindowText(hWndEvtSeq[nEvtCond],str);
           }
           break;
         }
   }
}
/******************************************************************
**
**      SetupLevel
**
********************************************************************/
void SetupLevel(HWND hWnd) {
char evtName[MAXLEN];
char str[MAXLEN]="0",str1[MAXLEN];
U32 c3;
U16 num,xx;

   if (nEvtCond>=0 && nEvtCond<=7) {
      SetupList(&num);
      /*
      TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
      TrigEventNameGet(theTrigger,evtName,MAXLEN);
      SendMessage(hWndEvtCondition[nEvtCond],CB_SELECTSTRING,
         0,(DWORD)evtName);
      */
      SetupCheckBox(hWnd);
   }
   if (nEvtCond==8) {
      TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
      TrigCounterValueGet(theTrigger,0,&c3);
      if (flagTMCO_0=='C' &&
         (flagCounterDec_Hex==IDM_COUNTER_HEX))
         ultoa(Server2TmCounter(0,c3),str,16);
      else
         ultoa(Server2TmCounter(0,c3),str,10);
      //wsprintf(str,"%lu",Server2TmCounter(0,c3));
      AppendTmCounterUnit(str,0,str1);
      SetWindowText(hWndEvtCondition[8],(LPSTR)str1);
      SetupCheckBox(hWnd);
   }
   if (nEvtCond==9) {
      TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
      TrigCounterValueGet(theTrigger,1,&c3);
      if (flagTMCO_1=='C' &&
         (flagCounterDec_Hex==IDM_COUNTER_HEX))
         ultoa(Server2TmCounter(1,c3),str,16);
      else
         ultoa(Server2TmCounter(1,c3),str,10);
      //wsprintf(str,"%lu",Server2TmCounter(1,c3));
      AppendTmCounterUnit(str,1,str1);
      SetWindowText(hWndEvtCondition[9],(LPSTR)str1);
      SetupCheckBox(hWnd);
   }
   if (nEvtCond==10) {
      TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
      //GetExtButtonTitle();
      SetupCheckBox(hWnd);
   }
}
/***************************************************************
**
**         AppendTmCounterUnit
**
****************************************************************/
RETCODE AppendTmCounterUnit(char *digitStr,U8 no,char *hasUnitStr) {
U8 timerUnit;
   strcpy(hasUnitStr,digitStr);
   SetWindowText(hWndEvtUnit[no],"");
   if ((flagTMCO_0=='C' && no==0) || (flagTMCO_1=='C' && no==1)) {
      if (flagCounterDec_Hex==IDM_COUNTER_HEX)
         wsprintf(hasUnitStr,"0x%s",digitStr);
   }
   else {
      TrigModeUnitGet(theTrigger,no,&timerUnit);
      if (timerUnit==0)
         SetWindowText(hWndEvtUnit[no],"clk");
      else if (timerUnit==3)
         SetWindowText(hWndEvtUnit[no],"s");
      else if (timerUnit==4)
         SetWindowText(hWndEvtUnit[no],"ms");
      else if (timerUnit==5)
         SetWindowText(hWndEvtUnit[no],"us");
   }
   return GOOD;
}
/***************************************************************
**
**            InitialCheckBox
**
****************************************************************/
void InitialCheckBox(HWND hWnd,HFONT hButtonFont) {
int i,j;
int tempX,intervalX,tempTmX;
   intervalX=5*cxAveChar;
   for (i=0;i<11;i++) {
      tempX=34*cxAveChar;
      hWndEvtSeq[i]=CreateWindow("button",NULL,
         WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,
         tempX-1.5*cxAveChar,cyHeight*(3+i+0.2)+5*i,
         4.0*cxAveChar,0.7*cyHeight,
         hWnd,200+20*i+3,
         hInst,NULL);
      SendMessage(hWndEvtSeq[i],WM_SETFONT,hButtonFont,0);
      ShowWindow(hWndEvtSeq[i],SW_HIDE);
      tempX=tempTmX=tempX+intervalX-0.5*cxAveChar;
      j=0;
      hWndEvtAction[i][j]=CreateWindow("button",NULL,
         WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
         tempX+j*intervalX,cyHeight*(3+i+0.2)+5*i,
         3*cxAveChar,0.6*cyHeight,
         hWnd,200+20*i+j+4,
         hInst,NULL);
      ShowWindow(hWndEvtAction[i][j],SW_HIDE);
      tempX=tempX+intervalX;
      for (j=1;j<5;j++) {
          hWndEvtAction[i][j]=CreateWindow("button",NULL,
             WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
             tempX+(j-1)*4*cxAveChar,cyHeight*(3+i+0.2)+5*i,
             3*cxAveChar,0.6*cyHeight,
             hWnd,200+20*i+j+4,
             hInst,NULL);
          ShowWindow(hWndEvtAction[i][j],SW_HIDE);
      }
      tempX=tempX+3.5*intervalX;
      //j=5 -- j=10
      for (j=0;j<3;j++) {
          hWndEvtAction[i][j+5]=CreateWindow("button",NULL,
             WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
             tempX+j*intervalX,cyHeight*(3+i+0.2)+5*i,
             3*cxAveChar,0.6*cyHeight,
             hWnd,200+20*i+j+9,
             hInst,NULL);
          ShowWindow(hWndEvtAction[i][j+5],SW_HIDE);
      }
      tempX=tempX+3*intervalX;
      for (j=0;j<3;j++) {
          hWndEvtAction[i][j+8]=CreateWindow("button",NULL,
             WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
             tempX+j*intervalX,cyHeight*(3+i+0.2)+5*i,
             3*cxAveChar,0.6*cyHeight,
             hWnd,200+20*i+j+12,
             hInst,NULL);
          ShowWindow(hWndEvtAction[i][j+8],SW_HIDE);
      }
      //j=11
      tempX=tempX+3*intervalX;
      hWndEvtAction[i][11]=CreateWindow("button",NULL,
         WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
         tempX+2*cxAveChar,cyHeight*(3+i+0.2)+5*i,
         3*cxAveChar,0.6*cyHeight,
         hWnd,200+20*i+15,
         hInst,NULL);
      ShowWindow(hWndEvtAction[i][11],SW_HIDE);

      tempTmX=tempTmX+4.5*intervalX;
      for (j=0;j<2;j++) {
         hWndEvtAction[i][12+j]=CreateWindow("button",NULL,
            WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
            tempTmX+3*cxAveChar+j*5*cxAveChar,cyHeight*(3+i+0.2)+5*i,
            3*cxAveChar,0.6*cyHeight,
            hWnd,200+20*i+16+j,
            hInst,NULL);
         ShowWindow(hWndEvtAction[i][12+j],SW_HIDE);
      }
      tempTmX=tempTmX+3*intervalX;
      for (j=0;j<2;j++) {
         hWndEvtAction[i][14+j]=CreateWindow("button",NULL,
            WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,
            tempTmX+3*cxAveChar+j*5*cxAveChar,cyHeight*(3+i+0.2)+5*i,
            3*cxAveChar,0.6*cyHeight,
            hWnd,200+20*i+18+j,
            hInst,NULL);
         ShowWindow(hWndEvtAction[i][14+j],SW_HIDE);
      }
   }
}
/***************************************************************
**
**            HandleSeqOrExtOutAction
**
****************************************************************/
void HandleSeqOrExtOutAction(HWND hWnd) {
   if (nEvtColumn==3) {
      lpSelSeqProc=MakeProcInstance((FARPROC)SelSeqProc,
         hInst);
      DialogBox(hInst,"SelLevel",hWnd,lpSelSeqProc);
   }
}
/***************************************************************
**
**            SelSeqProc
**
****************************************************************/
BOOL FAR PASCAL SelSeqProc (HWND hDlg, UINT message,
                UINT wParam, LONG lParam) {
U16 seqLevel;
int i,j;
ACTION_MASK actionMask;
RETCODE err;
char str[MAXLEN];
   switch(message) {
      case WM_INITDIALOG:
         TrigSeqLevelGet(theTrigger,&seqLevel);
         seqLevel=530+seqLevel;
         EnableWindow(GetDlgItem(hDlg,seqLevel),FALSE);
         TrigActionGet(theTrigger,&actionMask);
         seqLevel=seqLevel-530;
         for (i=0;i<4;i++)
            if (ConvActionMask2One(actionMask,ConvLevel2ActionMask(i))) {
               if (i==seqLevel)
                  CheckRadioButton(hDlg,IDD_LEVEL0,IDD_LEVELNO,
                     IDD_LEVELNO);
               else
                  CheckRadioButton(hDlg,IDD_LEVEL0,IDD_LEVELNO,
                     (530+i));
               break;
            }
         return TRUE;
      case WM_COMMAND:
         if (wParam>=530 && wParam<=534) {
            CheckRadioButton(hDlg,IDD_LEVEL0,IDD_LEVELNO,wParam);
            return 0;
         }
         switch(wParam) {
            case IDD_OKAY_SEQ:
               i=530;
               while (1) {
                  if (IsDlgButtonChecked(hDlg,i)) {
                     if (i==IDD_LEVELNO) {
                        err=TrigSeqLevelGet(theTrigger,&seqLevel);
                        err=TrigActionClear(theTrigger,
                           WhichBitsWillClear(ConvLevel2ActionMask
                           (seqLevel)));
                        err=TrigActionSet(theTrigger,
                           ConvLevel2ActionMask(seqLevel));
                     }
                     else {
                        err=TrigActionClear(theTrigger,
                           WhichBitsWillClear(ConvLevel2ActionMask(i-530)));
                        err=TrigActionSet(theTrigger,
                           ConvLevel2ActionMask(i-530));
                     }
                     TrigActionGet(theTrigger,&actionMask);
                     for (j=0;j<4;j++)
                        if (ConvActionMask2One(actionMask,
                           ConvLevel2ActionMask(j))) {
                           TrigSeqLevelGet(theTrigger,&seqLevel);
                           if (j==seqLevel)
                              SetWindowText(hWndEvtSeq[nEvtCond],"no");
                           else {
                              itoa((U16)j,str,10);
                              SetWindowText(hWndEvtSeq[nEvtCond],str);
                           }
                           break;
                        }
                     break;
                  }
                  i++;
               }
               EndDialog(hDlg,TRUE);
               return 0;
            case IDD_CANCEL_SEQ:
               EndDialog(hDlg,FALSE);
               return 0;
            /*
            case IDD_HELP:
               WinHelp(hDlg, "PWRVIEWS.HLP", HELP_CONTEXT, 2001);
               return 0;
            */
         }
         break;
   }
   return FALSE;
}
/***************************************************************
**
**       TmCounter2Server
**
****************************************************************/
RETCODE TmCounter2Server(U8 no,U8 *valueUnit,U32 *numclock) {
char szString00[]="cnt0";
char szString01[]="cnt1";
char str[MAXLEN];
U8 timerUnit;
U32 tempi,tempMod,limit;
U8 *tempbuf;
char value[MAXLEN],temp[MAXLEN];

   sscanf(valueUnit,"%s %s",&value,&temp);
   GetWindowText(hWndTmCounter[no],str,MAXLEN);
   if ((strcmp(str,szString00)==0) || (strcmp(str,szString01)==0))
      if (flagCounterDec_Hex==IDM_COUNTER_HEX)
         tempi=strtoul(value,&tempbuf,16);
      else
         tempi=strtoul(value,&tempbuf,10);
   else
      tempi=strtoul(value,&tempbuf,10);
   if ((tempi==0) || (tempbuf[0]!='\0')){
      strcpy(str,"The value can't be 0 or include alphanet.");
      ErrMessageBoxL(str);
      return 1; /*ERROR*/
   }

   if (strcmp(str,szString00)==0) {
      *numclock=tempi;
      return GOOD;
   }
   else {
      if (strcmp(str,szString01)==0) {
            *numclock=tempi;
         return GOOD;
      }
      else {
         TrigModeUnitGet(theTrigger,no,&timerUnit);
         if (timerUnit==1)
            if (tempi <= 1)
               tempi=tempi*60*60*1000*1000/epClock;
            else {
               strcpy(str,"Hour should be less or equal than 1");
               ErrMessageBoxL(str);
               return 1; /*ERROR*/
            }
         if (timerUnit==2)
            if (tempi <= 71)
               tempi=tempi*60*1000*1000*epClock;
            else {
               strcpy(str,"Minute should be less or equal than 71");
               ErrMessageBoxL(str);
               return 1; /*ERROR*/
            }
         if (timerUnit==3) {
            limit=0xffffffff/1000/1000/epClock;
            if (tempi <= limit)
               tempi=tempi*1000*1000*epClock;
            else {
               wsprintf(str,"Second should be less or equal than %lu",limit);
               ErrMessageBoxL(str);
               return 1; /*ERROR*/
            }
         }
         if (timerUnit==4) {
            limit=0xffffffff/1000/epClock;
            if (tempi <= 214748)
               tempi=tempi*1000*epClock;
            else {
               wsprintf(str,"MilliSecond should be less or equal than %lu",limit);
               ErrMessageBoxL(str);
               return 1; /*ERROR*/
            }
         }
         if (timerUnit==5) {
            limit=0xffffffff/epClock;
            if (tempi <= 214748364)
               tempi=tempi*epClock;
            else {
               wsprintf(str,"MicroSecond should be less or equal than %lu",limit);
               ErrMessageBoxL(str);
               return 1; /*ERROR*/
            }
         }
      }
   }
   *numclock=tempi;
   return GOOD;
}
/***************************************************************
**
**       Server2TmCounter
**
****************************************************************/
RETCODE Server2TmCounter(U8 no,U32 value) {
char szString00[]="cnt0";
char szString01[]="cnt1";
char str[MAXLEN];
U8 timerUnit;
U8 temp[MAXLEN];

   //GetWindowText(hWndTmCounter[no],str,MAXLEN);
   if (flagTMCO_0=='C' && no==0)
      return value;
   else if (flagTMCO_1=='C' && no==1)
      return value;
   else {
      TrigModeUnitGet(theTrigger,no,&timerUnit);
      if (timerUnit==1)
         value=value*50/60/60/1000/1000;
      else if (timerUnit==2)
         value=value*50/60/1000/1000;
      else if (timerUnit==3)
         value=value/epClock/1000/1000;
      else if (timerUnit==4)
         value=value/epClock/1000;
      else if (timerUnit==5)
         value=value/epClock;
   }
   return value;
}
/*****************************************************************
**
**        UpdateTmCounterWindow
**
******************************************************************/
void UpdateTmCounterWindow(HWND hWnd) {
BOOLEAN c1,c2;
int i,j;
ACTION_MASK actionMask;
int value;
char str[MAXLEN];
U16 seqLevel;

   for (nEvtCond=0;nEvtCond<11;nEvtCond++) {
      TrigEventSet(theTrigger,ConvEvtCond(nEvtCond));
      TrigEventEnableGet(theTrigger,&c1);
      for(i=5;i<11;i++) {
         ShowWindow(hWndEvtAction[nEvtCond][i],SW_HIDE);
      }
      for(i=12;i<16;i++) {
         ShowWindow(hWndEvtAction[nEvtCond][i],SW_HIDE);
      }
      if (c1!=0) {
         TrigActionGet(theTrigger,&actionMask);
         for(j=5;j<11;j++) {
            nEvtAction=j;
            if (ConvActionMask2One(actionMask,ConvEvtAction(nEvtAction)))
               SendMessage(hWndEvtAction[nEvtCond][j],BM_SETCHECK,1,0);
            else
               SendMessage(hWndEvtAction[nEvtCond][j],BM_SETCHECK,0,0);
         }
         for(j=12;j<16;j++) {
            nEvtAction=j;
            if (ConvActionMask2One(actionMask,ConvEvtAction(nEvtAction)))
               SendMessage(hWndEvtAction[nEvtCond][j],BM_SETCHECK,1,0);
            else
               SendMessage(hWndEvtAction[nEvtCond][j],BM_SETCHECK,0,0);
         }
         if (flagTMCO_0=='T')
            for (i=5;i<8;i++)
               ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
         else
            for (i=12;i<14;i++)
               ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
         if (flagTMCO_1=='T')
            for (i=8;i<11;i++)
               ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
         else
            for (i=14;i<16;i++)
               ShowWindow(hWndEvtAction[nEvtCond][i],SW_SHOW);
      }
   }
   InvalidateRect(hWnd,NULL,TRUE);
   UpdateWindow(hWnd);
}
/*****************************************************************
**
**     ConvActionMask2One
**
******************************************************************/
BOOLEAN ConvActionMask2One(ACTION_MASK actionMask,
   ACTION_MASK oneActionMask) {

    switch(oneActionMask) {
       case LV0_MASK:
       case LV1_MASK:
       case LV2_MASK:
       case LV3_MASK:
          if ((actionMask & LV3_MASK) == LV3_MASK)
             if (oneActionMask == LV3_MASK)
                return TRUE;
             else
                return FALSE;
          if ((actionMask & LV3_MASK) == 0)
             if (oneActionMask == LV0_MASK)
                return TRUE;
             else
                return FALSE;
          if ((actionMask & oneActionMask) == LV2_MASK)
             return TRUE;
          if ((actionMask & oneActionMask) == LV1_MASK)
             return TRUE;
          return FALSE;
       case TMR0_START_MASK:
       case TMR0_STOP_MASK:
       case CNT0_INC_MASK:
          if ((actionMask & CNT0_INC_MASK) == CNT0_INC_MASK)
             if (oneActionMask == CNT0_INC_MASK)
                return TRUE;
             else if (flagTMCO_0=='T')
                return TRUE;
             else
                return FALSE;
          if ((actionMask & oneActionMask) == oneActionMask)
             return TRUE;
          else
             return FALSE;
       case TMR1_START_MASK:
       case TMR1_STOP_MASK:
       case CNT1_INC_MASK:
          if ((actionMask & CNT1_INC_MASK) == CNT1_INC_MASK)
             if (oneActionMask == CNT1_INC_MASK)
                return TRUE;
             else if (flagTMCO_1=='T')
                return TRUE;
             else
                return FALSE;
          if ((actionMask & oneActionMask) ==oneActionMask)
             return TRUE;
          else
             return FALSE;
       case TRC_START_MASK:
       case TRC_STOP_MASK:
       case TRC_QUAL_MASK:
          if ((actionMask & TRC_QUAL_MASK) == TRC_QUAL_MASK)
             if (oneActionMask == TRC_QUAL_MASK)
                return TRUE;
             else
                return FALSE;
          if ((actionMask & oneActionMask) ==oneActionMask)
             return TRUE;
          else
             return FALSE;
       case BRK_MASK:
       case TC0_RST_MASK:
       case TC1_RST_MASK:
       case TRC_DIS_MASK:
       case TRIG_OUT_MASK:
          if ((actionMask & oneActionMask) != 0)
             return TRUE;
          else
             return FALSE;
    }
}
/*****************************************************************
**
**     WhichBitsWillClear
**
******************************************************************/
ACTION_MASK WhichBitsWillClear(ACTION_MASK actionMask) {

   switch(actionMask) {
      case LV0_MASK:
      case LV1_MASK:
      case LV2_MASK:
      case LV3_MASK:
         return LV3_MASK;
      case TMR0_START_MASK:
      case TMR0_STOP_MASK:
      case CNT0_INC_MASK:
         return CNT0_INC_MASK;
      case TMR1_START_MASK:
      case TMR1_STOP_MASK:
      case CNT1_INC_MASK:
         return CNT1_INC_MASK;
      case TRC_START_MASK:
      case TRC_STOP_MASK:
      case TRC_QUAL_MASK:
         return TRC_QUAL_MASK;
   }
   return actionMask;
}
/************************************************************************
**
**          EditProc
**
*************************************************************************/
long FAR PASCAL EditProc(HWND hWnd, UINT message,
                         UINT wParam, LONG lParam) {
short n;

   n=GetWindowWord(hWnd,GWW_ID);
   if (message == WM_KEYUP) {
      if (wParam==VK_HOME)
         SendMessage(hWnd,WM_KEYDOWN,VK_HOME,lParam);
      if (wParam==VK_END)
         SendMessage(hWnd,WM_KEYDOWN,VK_END,lParam);
      if (wParam==VK_DELETE)
         SendMessage(hWnd,WM_KEYDOWN,VK_DELETE,lParam);
   }
   if (message == WM_KEYDOWN && wParam==VK_RETURN) {
      SetFocus(hWndTrig);
      SetFocus(hWnd);
      /*
      SendMessage(GetParent(hWnd),WM_COMMAND,
         n,MAKELONG(hWnd,EN_KILLFOCUS));
      */
   }
   if (message == WM_SYSKEYDOWN)
      SendMessage(GetParent(hWnd),WM_SYSKEYDOWN,
         wParam,lParam);
   return CallWindowProc(lpfnOldEdit,hWnd,message,wParam,lParam);
}
/************************************************************************
**
**          ErrMessageBoxL
**
*************************************************************************/
RETCODE ErrMessageBoxL(char *displayString) {
static U16 callcount=0;

   if (callcount>0)
      return GOOD;
   callcount++;
   MessageBox(hWndTrig,displayString,"MP/SLD",MB_OK);
   callcount--;
   return GOOD;
}
/************************************************************************
**
**          TrcTraceControl
**
*************************************************************************/
RETCODE TrcTraceControl(HWND hWnd){
  lpTraceControlProc=MakeProcInstance((FARPROC)TraceControlDlgProc,
        hLib);
  DialogBox(hLib,"TRACECONTROL",hWnd,lpTraceControlProc);
  return GOOD;
}
/************************************************************************
**
**          TraceControlDlgProc
**
*************************************************************************/
BOOL FAR PASCAL TraceControlDlgProc (HWND hDlg, UINT message,
                UINT wParam, LONG lParam) {
TRACE_MODE trcMode;
U16 val;
S16 buttonID;
BOOLEAN tracing,enable;
RETCODE err;

   switch(message) {
      case WM_INITDIALOG:
           RegisterHelpEntry(31,hDlg,2029);
           /* HI_DLGD_TRACECON 31
              HE_DLGD_TRACECON 2029 */
           /*
           if ((err=TrigTriggerOpen(&theTrigger,"", "default" ))!=GOOD) {
              ErrDisplayError(err,FORCE_POPUP);
              return 0;
           }
           */
           if ((err=TrigTraceModeGet(theTrigger,&trcMode))!=GOOD) {
              ErrDisplayError(err,FORCE_POPUP);
              return 0;
           }
           if (trcMode == 0)
              val= IDT_PRE;
           else if (trcMode == 1)
              val =  IDT_POST;
           else if (trcMode == 2)
              val = IDT_CENTER;
           CheckRadioButton(hDlg, IDT_PRE, IDT_POST, val);
           if (err=TrigFillActionGet(theTrigger,0,&enable)!=GOOD)
               return err;
           CheckDlgButton(hDlg,IDT_TRCBRK,enable);
           if (err=TrigFillActionGet(theTrigger,1,&enable)!=GOOD)
              return err;
           CheckDlgButton(hDlg,IDT_TRCOFF,enable);
           return 0;
      case WM_COMMAND:
         switch(wParam) {
            case IDT_PRE:
            case IDT_CENTER:
            case IDT_POST:
               CheckRadioButton(hDlg,IDT_PRE,IDT_POST,wParam);
               return 0;
            case IDT_TRCBRK:
            case IDT_TRCOFF:
               return 0;
            case IDT_OK:
               if ((err=TrcTracingGet(&tracing))!=GOOD) {
                  ErrDisplayError(err,FORCE_POPUP);
                  return 0;
               }
               if( tracing != 0 ) {
                  ErrMessageBox("Tracing must be disabled!",
                         "Do you want to turn off tracing?",
                          MB_YESNO | MB_ICONQUESTION,
                          2029,&buttonID);
               /* HE_DLGM_TRACECON_1 2029 */
                  if( buttonID == 6 ) {/* Okay*/
                  if ((err=TrcTracingSet(0))!=GOOD) {
                        ErrDisplayError(err,FORCE_POPUP);
                        return 0;
                     }
                  }
               }
               if (tracing == 0)
                  if ((err=UpdateServer(hDlg))!=GOOD)
                     ErrDisplayError(err,FORCE_POPUP);
               EndDialog(hDlg,TRUE);
               return 0;
            case IDT_CANCEL:
                 EndDialog(hDlg,TRUE);
                 return 0;
            case IDT_HELP:
                 WinHelp(hDlg,"pwrviews.hlp",HELP_CONTEXT,2029);
                 /* HE_DLGD_TRACECON 2029 */
                 return 0;
          }
    }
   return FALSE;
}
/************************************************************************
**
**          UpdateServer
**
*************************************************************************/
RETCODE UpdateServer(HWND hDlg) {
U16 id,err;
char saveStr[10]="0";

    id = 600;
    while (!IsDlgButtonChecked(hDlg, id) > 0 && id <=604 )
        id = id+1;

    if (id == 600) {
     strcpy(saveStr,"pre");
     id = 0;
    }
    else if (id == 601) {
      strcpy(saveStr,"center");
      id = 2;
    }
    else if (id == 602) {
       strcpy(saveStr,"post");
       id = 1;
    }
   if ((err=TrigTraceModeSet(theTrigger,id))==GOOD)
      WritePrivateProfileString("TrigInfo","traceAlignment",saveStr,
                OPENFILE);
   else
      return err;
   if (IsDlgButtonChecked(hDlg,IDT_TRCBRK)) {
      if ((err=TrigFillActionSet(theTrigger,0,1))==GOOD)
         WritePrivateProfileString("TrigInfo","traceBreak","on",
                   OPENFILE);
      else
         return err;
   }
   else {
      if ((err=TrigFillActionSet(theTrigger,0,0))==GOOD)
         WritePrivateProfileString("TrigInfo","traceBreak","off",
                   OPENFILE);
      else
         return err;
   }
   if (IsDlgButtonChecked(hDlg,IDT_TRCOFF)) {
      if ((err=TrigFillActionSet(theTrigger,1,1))==GOOD)
         WritePrivateProfileString("TrigInfo","breakOnFull","on",
                   OPENFILE);
      else
         return err;
   }
   else {
      if ((err=TrigFillActionSet(theTrigger,1,0))==GOOD)
         WritePrivateProfileString("TrigInfo","breakOnFull","off",
                   OPENFILE);
      else
         return err;
   }
   return GOOD;
}
/************************** E O F ****************************************/
