/* This class builds menu-item objects that can be
  used in dynamic menu creation. These objects can be
  created as simple menu items or popup menus which
  actually contain a collection  of additional objects
  of this class. */!!

inherit(Object, #MenuItem,
#(text      /* a string defining the menu text */
id        /* the numeric value for this item */
actionSym /* the message symbol */
popupColl /* collection of MenuItem objs */), 2, nil)!!

now(class(MenuItem))!!

/* Create a new simple (non-popup) menu object. */
Def new(self, name, id, sym | obj)
{ obj := new(self:Behavior);
  ^init(obj, name, id, sym);
}!!

/* Create a new popup menu object. */
Def newPopup(self, name | obj)
{ obj := new(self:Behavior);
  ^initPopup(obj, name);
}!!

now(MenuItem)!!

/* Return this menu item's action symbol, which
  can be used for sending messages. */
Def actionSym(self)
{ ^actionSym;
}!!

/* Add the menu item to self, checking first
 that this is a popup menu item. */
Def addItem(self, item)
{ if popupColl
  then add(popupColl, item);
  else alert(System, self, #popupMenuError);
  endif;
}!!

/* Add self to the menu whose handle is the argument. */
Def addToMenu(self,  hM)
{ Call AppendMenu(hM, MF_STRING, id, asciiz(text));
}!!

/* Return this menu item's command id. */
Def id(self)
{ ^id;
}!!

/* Initialize the data for a regular (non-popup)
  menu item. */
Def init(self, txt, iD, sym)
{ text := txt;
  id := iD;
  actionSym:= sym;
}!!

/* Initialize the data for a popup menu item. */
Def initPopup(self, name)
{ text := name;
  popupColl := new(OrderedCollection, 2);
}!!

/* Return the optional collection of MenuItem objs. */
Def popupColl(self)
{ ^popupColl;
}!!

/* Return the text string for this menu item. */
Def text(self)
{ ^text;
}!!
