/* Class: SRCPATHD.CLS
   Required PATHTOSRC.CLS
*/!!

inherit(Dialog, #SrcPathDialog, #(currentIndex /* Current select Index */
srcPathColl /* a temporary  FixedSizeQueue object to hold source paths */
prjInfoObj   /* the current PrjInfo object */
isDirty /* Flag to indicate there are changes */), 2, nil)!!

now(class(SrcPathDialog))!!

/* 6/4/1993 16:30 - PUBLIC
  Create an instance of the SrcPathDialog. Initialize and run.
  EX: dlg := new(SrcPathDialog, TheProjectInfoObj);
*/
Def new(self, prjObj | theDlg)
{ 
  theDlg := new(self:Behavior);
  ^init(theDlg, prjObj);
}
!!

now(SrcPathDialog)!!

/* 6/9/1993 15:40 - PRIVATE
  Set the current selection and focus to the LB_PATHS
*/
Def setLBSelFocus(self)
{ 
  /* Make sure that the list has a selection */  
  if currentIndex cand (sendDlgItemMessage(self, LB_PATHS,
       LB_SETCURSEL, currentIndex, 0L) <> LBN_ERR) then
    /* Set Focus to List */
    setItemFocus(self, LB_PATHS); 
    enableItem(self, BTN_EDIT);
    enableItem(self, BTN_DELETE);
  else
    currentIndex := nil;
    disableItem(self, BTN_EDIT);
    disableItem(self, BTN_DELETE);         
  endif;    
}
!!

/* 6/4/1993 17:17 - PRIVATE
  Delete the current selected Path.
*/
Def deleteSrcPath(self | sel, num)
{
  sel := getLBSel(self, LB_PATHS);
  if currentIndex cand (currentIndex = sel) 
        cand (size(srcPathColl) > 0) then 
    remove(srcPathColl, currentIndex);
    sendDlgItemMessage(self, LB_PATHS, LB_DELETESTRING, currentIndex, 0L);
    isDirty := #true;
    if size(srcPathColl) = 0 then
      currentIndex := nil;
      disableItem(self, BTN_EDIT);
      disableItem(self, BTN_DELETE);
    else
      /* Adjust the current selection if delete the last item */
      num := sendDlgItemMessage(self, LB_PATHS, LB_GETCOUNT, 0, 0L);
      /* currentIndex start from 0 -- The last item = num -1 */
      if (currentIndex > (num-1)) cand (currentIndex > 0) then
        currentIndex := currentIndex - 1;
      endif;
      /* Reset the current selection */
      setLBSelFocus(self);
    endif;
  else
    /* Let reset the currentIndex */
    beep();
    currentIndex := sel;  
  endif;  
  ^GOOD;  
}
!!

/* 6/4/1993 17:17 - PRIVATE
  Open the Edit Path dialog box to let user edit the current path.
*/
Def editSrcPath(self | sel, tmpDlg, tmpStr)
{ 
  sel := getLBSel(self, LB_PATHS);  
  if currentIndex cand (currentIndex = sel) then
    tmpStr := srcPathColl[currentIndex]; 
    tmpDlg := open(InputDlgWithHelp);
    setUp(tmpDlg, "Edit Path", "&Path:", tmpStr, HE_DLGD_SRCPATHD);
    if (runModal(tmpDlg, DLG_INPUT_WITH_HELP, self) = IDOK) then 
      /* Edit string is null - remove it */
      if size(tmpStr := getText(tmpDlg)) = 0 then
        /* delete the selected string if its size is zero */
        ^deleteSrcPath(self);
      else
        /* Update the collection and list box display */
        tmpStr:=asUpperCase(tmpStr); /* <Judy 7/18/97> */
        srcPathColl[currentIndex] := tmpStr;
        sendDlgItemMessage(self, LB_PATHS, LB_DELETESTRING, currentIndex, 0L);
        insertLBText(self, LB_PATHS, tmpStr, currentIndex); 
        setLBSelFocus(self);
      endif;
      isDirty := #true;  
    endif;    
  endif;
  ^GOOD;   
}
!!

/* 6/4/1993 17:17 - PRIVATE
  Open the Path To Source dialog box to let user defines a new path.
*/
Def addSrcPath(self | sel, tmpDlg, tmpStr, newStr, duplicated, idx)
{ 
  /* Default file filter */
  sel := getLBSel(self, LB_PATHS);
  tmpStr := "*.c";  
  if currentIndex cand (currentIndex = sel) then
    tmpStr := makePathString(srcPathColl[currentIndex], tmpStr);
  endif;
  tmpDlg := new(PathToSrcDialog, tmpStr);
  setHelpEntry(tmpDlg, HE_DLGF_ADD_SRC_PATH);
  if runModal(tmpDlg, FILE_BOX, self) = IDOK then
    /* <Judy 7/18/97> */
    /* Append string will be changed to Upper case. */
    /* Append string will be inserted to the first line */     
    if (newStr := asUpperCase(pathToSource(tmpDlg))) <> nil cand
                              (size(newStr) > 0) then
       if (find(newStr, "\", size(newStr)-1)=nil)
          newStr:=newStr+"\";                       
       endif;
       duplicated:=nil;
       do(srcPathColl,
         {using(element)
          if(asString(element)=asString(newStr))
            duplicated:=#true;
          endif;
       });
       if not(duplicated) cand (insert(srcPathColl,newStr,0)) then
          idx:=0;
          clearLBText(self,LB_PATHS);
          if size(srcPathColl)>0 then
             do(srcPathColl,
               {using(element)
                addLBText(self,LB_PATHS,element);
             });
          endif;              
                              
      /* Add the newStr to Collection and it list *
      addToEnd(srcPathColl, newStr); */
      /* Save the index of the newly added item *
      sel := addLBText(self, LB_PATHS, newStr); */
          isDirty := #true;
      endif;    
    endif;
    /* eof <Judy 7/18/97> */
  endif;
  /* Need to select the item if it's the first item added */
  if not(currentIndex) cand (sel <> LBN_ERR) then
    currentIndex := sel;    
    setLBSelFocus(self);
  else    
    /* List already has selection, reset focus to List */
    setItemFocus(self, LB_PATHS); 
  endif;  
  ^GOOD;   
}
!!

/* By returning a 1 from the INITDIALOG message, we
  are telling MS-Windows to set the input focus to
  first tabstop item. (See MS-Windows Reference). */
Def initDialog(self, wP, lP)
{ 
  /* Let fill the LB_PATHS */
  registerF1Help(CLIULibraryClass$Inst, HI_DLGD_SRCPATHD,
     getHWnd(self), HE_DLGD_SRCPATHD);
  clearLBText(self, LB_PATHS);
  if size(srcPathColl) > 0 then
    do (srcPathColl,
      {using(element)
        addLBText(self, LB_PATHS, element);
      }); 
    /* Set current selection and focus */  
    currentIndex := sendDlgItemMessage(self, LB_PATHS, LB_SETCURSEL, 0, 0L);
    setItemFocus(self, LB_PATHS); 
    ^0;   
  endif;
  /* List empty - disable buttons */
  disableItem(self, BTN_EDIT);
  disableItem(self, BTN_DELETE);      
  ^1;
}!!

/* 6/4/1993 16:39 - PRIVATE
  Initialize SrcPathDialog information.
*/
Def init(self, thePrjInfo)
{ 
  prjInfoObj := thePrjInfo;
  isDirty := nil;
  /* create another copy of the sourcePathsCollection */
  srcPathColl := deepCopy(sourcePathsCollection(thePrjInfo));    
}
!!

/* 6/4/1993 16:02 - PRIVATE
  Commands processor for SrcPathDialog
*/
Def command(self, wp, lp | action)
{ 
  action := high(lp);
  select
    case wp == IDCANCEL and action = 0
      /* Verify that user did not accidently select CANCEL */
      if isDirty then
        beep();
        if (errMessageBox(ErrorTextLibClass$Inst, "Warning", 
          "There are new changes.  Do you want to save them before exit?",
          MB_YESNO bitOr MB_ICONASTERISK, HE_DLGM_SRCPATH_CHANGED) = IDYES)
          /* Save the new changes */
          setSourcePathsCollection(prjInfoObj, srcPathColl);
        endif; 
      endif;
      end(self, IDCANCEL);
    endCase
    case wp == IDOK and action = 0 /* This is Button Close */
      is 
        nameFg:=0; /* added by cjchen 1996.11.26*/
        /* Save the new changes and exit */
        setSourcePathsCollection(prjInfoObj, srcPathColl); 
        end(self, IDOK);
    endCase
    case wp == IDHELP 
      /* Open WinHelp for dialog  */
      is contextNumber(TheHelpObject, hWnd, HE_DLGD_SRCPATHD);
    endCase
    case wp == BTN_ADD
      /* Open Path to Source dialog */
      addSrcPath(self); 
    endCase
    case wp == BTN_EDIT
      /* Open Path Edit dialog */
      editSrcPath(self);
    endCase
    case wp == BTN_DELETE
      /* Delete the current source path selection */
      deleteSrcPath(self);
    endCase
    /* User select path - set current index */
    case ((wp == LB_PATHS) and 
      (action = LBN_SELCHANGE) cor (action = LBN_DBLCLK))
      if (currentIndex := getLBSel(self, wp)) then
        enableItem(self, BTN_EDIT);
        enableItem(self, BTN_DELETE);
      else
        disableItem(self, BTN_EDIT);
        disableItem(self, BTN_DELETE);         
      endif;
      /* Double click on the LB_PATHS to edit */
      if (currentIndex cand (action = LBN_DBLCLK)) then
        editSrcPath(self);
      endif;
    endCase    
  endSelect;
  ^GOOD;
}
!!
