/* Class: BkptIntelDialog
   This class handles setting breakpoint for the Intel processors family.
*/!!

inherit(BkptDialog, #BkptIntelDialog, #(addrSpace /* Address Space */), 2, nil)!!

now(class(BkptIntelDialog))!!

/* 3/15/1994 17:13 - PUBLIC */
Def new(self, tmpDict, space | theDlg)
{ 
  theDlg := new(self:Behavior);
  setAddrSpace(theDlg, space);
  ^init(theDlg, tmpDict);
}
!!

now(BkptIntelDialog)!!

/* 3/16/1994 10:06 - PRIVATE
  Set a breakpoint according to user input. 
  Return nil if successful or error message.
  NOTES: Override ancestor's method to handle address space.
*/
Def setBkptWithInput(self, bkptInput | addrDesc, spaceTxt)
{ 
  /* Check breakpoint input - convert to an <addrDesc> */
  if not(addrDesc := convertTextToAddressNoError(AddressLibClass$Inst, bkptInput)) then 
    ^getErrorText(ErrorTextLibClass$Inst, lastError(AddressLibClass$Inst));
  endif;
  /* retrieve the specified address space to set breakpoint */
  if not(spaceTxt := getCBText(self, DLG_COMBO_ADDR_SPACE)) cor
     not(addrSpace := translateAddrSpace(AddressLibClass$Inst, spaceTxt)) then
     ^nil;
  endif;
  if not(setAddrSpace(AddressLibClass$Inst, addrDesc, addrSpace)) then
    ^nil;
  endif;  
  /* Set breakpoint using address descriptor - Server consumes descriptor */
  if not(prime_setAsmBkpt(HLBreakLibClass$Inst, bkptState, bkptLife, addrDesc)) then
    ^getErrorText(ErrorTextLibClass$Inst, lastError(HLBreakLibClass$Inst));       
  endif;  
  ^nil; /* Successful */
}


!!

/* 3/15/1994 17:19 - PRIVATE
  Initialize self before display.
*/
Def initDialog(self, wp, lp | spaceColl, addrTxt hasSpace)
{ 
  initDialog(self:ancestor, wp, lp);
  hasSpace := false;
  clearCBText(self, DLG_COMBO_ADDR_SPACE);
  if (TheProcFamily = PROC_FAMILY_X86) then
     /* Retrieve the address Spaces list from the Address Server */
     if (spaceColl := getAddressSpaces(AddressLibClass$Inst)) cand
        (size(spaceColl) > 0) then
       do (spaceColl,
         {using(txtElement)
           addCBText(self, DLG_COMBO_ADDR_SPACE, txtElement);
         }); 
       hasSpace := true;
     endif;
  else 
     addCBText(self, DLG_COMBO_ADDR_SPACE, "SP");     
     addCBText(self, DLG_COMBO_ADDR_SPACE, "UP");
     hasSpace := true; 
  endif;
  
  /* Set current selection for space */
  if hasSpace then
     if (addrTxt := getAddrSpaceText(AddressLibClass$Inst, addrSpace)) then
        sendDlgItemMessage(self, DLG_COMBO_ADDR_SPACE, CB_SELECTSTRING, 0,
                        asciiz(addrTxt));
     else
        sendDlgItemMessage(self, DLG_COMBO_ADDR_SPACE, CB_SETCURSEL, 0, 0L);
     endif;
  else
     /* No spaces - disable the control */
     disableItem(self, DLG_COMBO_ADDR_SPACE);
  endif;
}
!!

/* 3/15/1994 17:17 - PRIVATE 
  Set the current address space use in setting breakpoint.
  NOTES:
    <space> is the actual address space enumuration of the address
    server.
*/
Def setAddrSpace(self, space)
{ if not(space) cor (space = ADDR_SPACE_DEFAULT) then
     space := getAddrSpace(self:ancestor);
  endif;      
  addrSpace := space;
}
!!