/* dump information about a fatal Actor error condition */!!

inherit(Object, #ErrorDump, nil, 2, nil)!!

now(class(ErrorDump))!!

/* Display the error information. */
Def errorDumpWindow(self | errString fileName dumpFile)
{
  errString := loadString(exceptionSelector(ErrorHandler));
  dumpFile := new(TextFile);
  fileName := "pv.dmp";
  setName(dumpFile, fileName);
  create(dumpFile);
  writeLine(dumpFile, "A fatal error has occurred in MP/SLD: " + errString + ".");
  writeLine(dumpFile, "Please supply this information to Microtek Technical Support");
  writeLine(dumpFile, "so that this problem can be diagnosed and fixed.");
  writeLine(dumpFile, "----------------------------------------------------------");
  writeLine(dumpFile, "Note:  MP/SLD is now unstable, and should be restarted");
  writeLine(dumpFile, "==========================================================");
  writeLine(dumpFile, "MP/SLD Fatal Error: " + errString);
  writeLine(dumpFile, dateStr() + " " + timeStr());
  writeLine(dumpFile, "stack traceback:");
  do(frames(fill(Bug, stackTop())),
    {using(str)
       writeLine(dumpFile, str);
    });
  close(dumpFile);
  errorBox("MP/SLD Fatal Error",
    "A fatal error has occurred in MP/SLD.  Error information has " +
    "been written to file '" +
    fileName +
    "'.  Please forward this " +
    "information to Microtek Technical Support.  Note that " +
    "after this dialog is closed, MP/SLD will terminate.");

  0;
 }
!!

now(ErrorDump)!!