/* CLASS: Load Option Dialog
   Provides a dialog box to let user selects loadfile options.
   NOTES: Must be loaded before the LoaderLib.
   REQUIRE: None
*/!!

inherit(Dialog, #LoadOptionDialog, #(loadCode 
loadSymbol
isOnDemand
loadReport
loadWarning
loadAsm
isSpaceUser), 2, nil)!!

now(class(LoadOptionDialog))!!

/* 7/6/1992 12:58 - PUBLIC
 Create an instance of the dialog box. Initialize and setup for runModal() call.
*/
Def new(self, loadOptions, onDemand | theDlg)
{ 
  theDlg := new(self:Behavior);
  setOptions(theDlg, loadOptions, onDemand);
  ^theDlg;
}
!!

now(LoadOptionDialog)!!

/* PRIVATE - Clear a check button and return the boolean state. */
Def clearCheck(self, id)
{ 
  if ((Call IsDlgButtonChecked(getHWnd(self), id)) > 0)
    Call CheckDlgButton(hWnd, id, 0);
  endif;  
  ^0;
}!!

/* 7/6/1992 13:01 - PRIVATE
  Initialize the dialog box.
*/
Def setOptions(self, loadFlags, onDemand)
{ 
  isOnDemand  := onDemand;
  loadSymbol  := loadFlags bitAnd 0x01;
  loadCode    := loadFlags bitAnd 0x02;
  loadReport  := loadFlags bitAnd 0x04;
  loadWarning := loadFlags bitAnd 0x08;
  loadAsm     := loadFlags bitAnd 0x10;
  isSpaceUser := loadFlags bitAnd 0x20;
}
!!

/* 7/6/1992 13:33 - PRIVATE
  LoadOptionDialog commands processor.
*/
Def command(self, wp, lp | val)
{ 
  select
    case (wp = IDOK) cor (wp = IDCANCEL) 
      end(self, wp);
    endCase
    case wp == IDHELP 
      is contextNumber(TheHelpObject, hWnd, HE_DLGR_LOAD_OPTIONS);
    endCase
    case wp = CHECKBX_SYMBOL
      if (val := toggle(self, wp)) then
        loadSymbol := 1;
        enableItem(self, CHECKBX_ONDEMAND);
        enableItem(self, CHECKBX_ASMMODULE);
      else
        loadSymbol := 0;
        clearCheck(self, CHECKBX_ONDEMAND);
        disableItem(self, CHECKBX_ONDEMAND);
        clearCheck(self, CHECKBX_ASMMODULE);
        disableItem(self, CHECKBX_ASMMODULE);        
      endif;
    endCase
    
    case wp = CHECKBX_CODE
      if (val := toggle(self, wp)) then
        loadCode := 2;
      else
        loadCode := 0;
      endif;
    endCase

    /* Winky 3/5/98 add isBoth flag */
    case (wp = 110) cor (wp = 111) cor (wp = 112)
      Call CheckRadioButton(getHWnd(self), 110, 112, wp);
      if (wp = 112) then
         isSpaceUser := 0x40
      else
         isSpaceUser := (if wp = 111 then 0x20 
                                     else 0  endif);
      endif;

      isBoth := 0;
      if wp = 112
        isBoth := 1;
      endif;
    endCase    
    case wp = CHECKBX_STATUS /* REPORT */
      if (val := toggle(self, wp)) then
        loadReport := 4;
      else
        loadReport := 0;
      endif;
    endCase

    case wp = CHECKBX_WARNING /* REPORT */
      if (val := toggle(self, wp)) then
        loadWarning := 8;
      else
        loadWarning := 0;
      endif;
    endCase
    
    case wp = CHECKBX_ASMMODULE /* LOAD ASM MODULE */
      if (val := toggle(self, wp)) then
        loadAsm := 0x10;
      else
        loadAsm := 0;
      endif;
    endCase
    
    case wp = CHECKBX_ONDEMAND
      if loadSymbol = 1 then
        if (val := toggle(self, wp)) then
          isOnDemand := 1;
        else
          isOnDemand := 0;
        endif;
      endif;  
    endCase
  endSelect;
  ^0;      
}
!!

/* 7/6/1992 13:31 - PUBLIC
  Return a tuple of LoadFlags and onDemand setting.
*/
Def loadOptions(self)
{ 
  /* #(loadFlags, onDemand) */
  ^tuple((loadSymbol bitOr loadCode bitOr loadReport 
        bitOr loadWarning bitOr loadAsm bitOr isSpaceUser), isOnDemand);
}
!!

/* 7/6/1992 13:25 - Actor
  By return a 1 from the initDialog message, we tell Windows to set focus to the first
  TABSTOP item.
*/
Def initDialog(self, wp, lp | tmp)
{ 
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_LOAD_OPTIONS,
     getHWnd(self), HE_DLGR_LOAD_OPTIONS);
  if loadSymbol = 1 then 
    toggle(self, CHECKBX_SYMBOL); 
    enableItem(self, CHECKBX_ONDEMAND);
    enableItem(self, CHECKBX_ASMMODULE);
    if isOnDemand = 1 then 
      toggle(self, CHECKBX_ONDEMAND); 
    endif;
    if (loadAsm = 0x10) then
      toggle(self, CHECKBX_ASMMODULE);
    endif;
  else
    disableItem(self, CHECKBX_ONDEMAND);
    disableItem(self, CHECKBX_ASMMODULE);   
  endif;

  if loadCode   = 2 then 
    toggle(self, CHECKBX_CODE); 
  endif;

  if loadReport = 4 then 
    toggle(self, CHECKBX_STATUS); 
  endif;

  if loadWarning = 8 then 
    toggle(self, CHECKBX_WARNING); 
  endif;
    
  /* Winky 3/5/98 add isBoth flag */
  tmp := (if isSpaceUser = 0x20 then 111 else 110 endif);
  if isBoth = 1
     tmp := 112;
  endif;
  Call CheckRadioButton(getHWnd(self), 110, 112, tmp);

  ^1; 
}
!!
