/* trace server library */!!

inherit(ProvidedLibs, #TraceLib, #(initialized), 2, nil)!!

setClassVars(TraceLib, #())!!

now(class(TraceLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self, path)
{ 
  ^initialize(new(self:ancestor),path);
}
!!

now(TraceLib)!!

 
/* 8/18/1997 17:51 */
 
Def setPreFrameTS(self | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCPREFRAMETSSET]);  
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* 2/8/1996 15:04 */
/* PUBLIC -- gingerbread for pcall */
Def trcGetQTraceActive(self | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCGETQTRACEACTIVE]);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    rc := 0;
  endif ;

  ^rc;
}
!!

/* 1/17/1996 11:14 */
Def trcDlgQTrace(self, hWnd)
{
  /* call dialog box that lives in MEM.DLL */
  if pcallLock(self)
    lastError :=
      pcall(procs[#TRCDLGQTRACE],  hWnd );
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError = 0 cor lastError = 1)
    ^lastError;
  endif;
  displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
  ^nil;  /* error */
}

!!

/* 12/21/1995 14:42 */
Def trcGetCounters(self, cnt0Ref, cnt1Ref)
{
  if pcallLock(self)
    lastError := pcall(procs[#TRCGETCOUNTERS], cnt0Ref, cnt1Ref);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD)
    displayFormattedError(ErrorTextLibClass$Inst, 
       lastError, CHECK_MODE, nil, nil, nil);
    ^nil;
  endif;
  
  ^GOOD;
}
!!

/* 7/25/1994 13:34 */
Def trcInit(self)
{
  if pcallLock(self)
    lastError := pcall(procs[#TRCINIT], hLib);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD)
    displayFormattedError(ErrorTextLibClass$Inst, 
       lastError, CHECK_MODE, nil, nil, nil);
    ^nil;
  endif;
  
  ^GOOD;
}
!!

/* PUBLIC -- gingerbread for pcall ; returns tuple(rc,value)*/
Def prim_trcMaxValidTraceBuffer(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCMAXVALIDTRACEBUFFERS], value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  if (rc <> 0)
    ^tuple(rc, 0)
  else
    ^tuple(0, wordAt(value, 0));
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def prim_trcCollectingBufferGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCCOLLECTINGBUFFERGET], value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  if (rc <> 0)
    ^tuple(rc, 0)
  else
    ^tuple(rc, wordAt(value,0))
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall ; returns tuple(rc,value)*/
Def prim_trcTracingGet(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACINGGET], value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  if (rc <> 0)
    ^tuple(rc, 0)
  else
    ^tuple(0, wordAt(value, 0));
  endif ;  
}
!!

/* PRIVATE */
Def addImportProcs(self)
{
  add(self,#INITCSERVER, 1, #(0, 0));
  add(self,#TRCTRACEOPEN,1,#(1,1,0,0));
  add(self,#TRCTRACEBUFFERINFOGET,1,#(1,1,1,1));
  add(self,#TRCTRACECLOSE,1,#(1));
  add(self,#TRCBACKWARDREAD,1,#(1,1,1,1,1,1)); 
  add(self,#TRCFORWARDREAD,1,#(1,1,1,1,1,1));  
  add(self,#TRCMAXVALIDTRACEBUFFERS,1,#(1));
  add(self,#TRCTRACETEMPLATESET,1,#(1,0));
  add(self,#TRCFRAMENUMBERAREASIZEGET,1,#(1));
  add(self,#TRCSUBBUFFERSIZEGET,1,#(1));
  add(self,#TRCREADFRAMEGET,1,#(1,1));
  add(self,#TRCREADFRAMESET,1,#(1,1));
  add(self,#TRCNUMFRAMESGET,1,#(1,1));
  add(self,#TRCREADBUFFERGET,1,#(1,1));
  add(self,#TRCREADBUFFERSET,1,#(1,0));
  add(self,#TRCTRACECYCLESET,1,#(1,0));
  add(self,#TRCTRACECYCLEGET,1,#(1,1));
  add(self,#TRCGETHEADER, 1, #(1, 1, 0) ) ;
  add(self,#TRCTRACEBUFFERCLEAR,1,nil); 
  add(self,#TRCSEARCHBUFFERSET,1,#(1,0));
  add(self,#TRCSEARCHFRAMEGET,1,#(1,1));
  add(self,#TRCSEARCHFRAMESET,1,#(1,1));
  add(self,#TRCSEARCHEVENTSET,1,#(1,1));
  add(self,#TRCTRACESEARCH,1,#(1,1));
  add(self,#TRCTRACINGSET,1,#(0));
  add(self,#TRCTRACINGGET,1,#(1));
  add(self,#TRCUPDATETRACE,1,#(1));
  add(self,#TRCCOLLECTINGBUFFERGET,1,#(1));
  add(self,#TRCGETFRAMEINSTADDRESS,1,#(1,1,1,1));
  add(self,#TRCTIMESTAMPGET,1,#(1,1));
  add(self,#TRCTIMESTAMPSET,1,#(1,0));
  add(self,#TRCTIMESTAMPMODEGET,1,#(1,1));
  add(self,#TRCTIMESTAMPMODESET,1,#(1,0));
  add(self,#TRCTIMESTAMPZEROFRAMEGET,1,#(1,1));
  add(self,#TRCTIMESTAMPZEROFRAMESET,1,#(1,1));
  add(self,#TRCSYSTEMCRYSTALGET,1,#(1));
  add(self,#TRCSYSTEMCRYSTALSET,1,#(1));
  add(self,#TRCINIT,1,#(1));
  add(self,#TRCGETCOUNTERS,1,#(1,1));
  add(self,#TRCDLGQTRACE,1,#(0));
  add(self,#TRCGETQTRACEACTIVE,1,nil); 
  add(self,#TRCOPTIONFLAGGET,1,#(1,0,1));
  add(self,#TRCOPTIONFLAGSET,1,#(1,0));
  add(self,#TRCPREFRAMETSSET,1,nil);

}
!!

/* PRIVATE 
   Open and initialize trace server library & load trace dll
*/
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* PUBLIC -- create a trace instance */
Def traceOpen(self, fileName, cycleMode, frameMode | aTrace, rc, descriptorPtr) { 
  aTrace := new( Trace ) ;
  descriptorPtr := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACEOPEN], descriptorPtr, asciiz(fileName),
              cycleMode, frameMode) ;
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0) ^nil; endif;
  setDescriptor(aTrace, longAt(descriptorPtr, 0));
  setFileName(aTrace, fileName) ;
  setProcs(aTrace, procs(self)) ;
  ^aTrace
}!!

/* PUBLIC -- gingerbread for pcall */
Def trcCollectingBufferGet(self | result)
{ 
  /* result is #(rc, value) */
  result := prim_trcCollectingBufferGet( self ) ;

  displayError( ErrorTextLibClass$Inst, result[0], FORCE_POPUP ) ;
  ^result[1]  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcFrameNumberAreaSizeGet(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCFRAMENUMBERAREASIZEGET], value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcSubBufferSizeGet(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCSUBBUFFERSIZEGET], value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTraceBufferClear(self | rc)
{
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCTRACEBUFFERCLEAR]);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTracingGet(self | result)
{
  /* result is #(rc, value) */
  result := prim_trcTracingGet( self ) ;

  displayError(ErrorTextLibClass$Inst, result[0], FORCE_POPUP);
  ^result[1] 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcTracingSet(self, units | rc)
{
  if pcallLock(self)
  then
    /*
    printNewLine("TRCTRACINGSET tracing = "+asString(units));
    */
    rc := pcall(procs[#TRCTRACINGSET],units);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcSystemCrystalGet(self | freqStr rc)
{
  freqStr := new(String, 40);
  if pcallLock(self)
  then
    rc := pcall(procs[#TRCSYSTEMCRYSTALGET],freqStr);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if( rc <> 0 )
  then
    ^"" ;
  else
    ^ removeNulls(freqStr);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trcSystemCrystalSet(self, text | rc)
{
  if( not(text) )
    ^0;    /* don't set NIL to server */
  endif;
  if pcallLock(self)
    rc := pcall(procs[#TRCSYSTEMCRYSTALSET], asciiz(text));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* TraceLib Class Initialization Code */
