/* Variable Presenter */!!

inherit(Window, #VarPresenter, #(varBrowser /* a Variable Browser */
fieldEnabled /* set of enabled fields */), 2, nil)!!

now(class(VarPresenter))!!

/* PUBLIC -- the typical creation */
Def open(self, symbolDescriptor, symbolNameStr | instance)
{                   /*  par, menu, name,       rect, id, style */
  if (instance := newStyle(self, nil, nil, "Variable", nil, nil, WS_OVERLAPPEDWINDOW)) cand 
      (instance := open(instance, symbolDescriptor, symbolNameStr))
     show(instance, SW_NORMAL);
  endif;   
  ^instance;             
}
!!

Def openWithPosAndState(self, rect, showVal , symbolDescriptor, symbolNameStr | instance)
{                   /*  par, menu, name,       rect, id, style */
  if (instance := newStyle(self, nil, nil, "Variable", rect, nil, 
         WS_OVERLAPPEDWINDOW)) cand 
     (instance := open(instance, symbolDescriptor, symbolNameStr)) then
   show(instance, showVal);
  endif;
  ^instance;
}
!!

/* PUBLIC -- the typical creation */
Def openWithComposite(self, symbolDescriptor, varStr, startOffset | instance)
{                   /*  par, menu, name,       rect, id, style */
  if (instance := newStyle(self, nil, nil, "Variable", nil, nil, WS_OVERLAPPEDWINDOW)) cand 
      (instance := openWithComposite(instance, symbolDescriptor, varStr, startOffset))
    show(instance, SW_NORMAL);
  endif;
  ^instance;              
}
!!

Def wndClass(self)
{ ^"VariablePresenter"
}!!

Def wndIcon(self)
{ ^"VARSERV"
}!!

now(VarPresenter)!!

/* MENU */
Def menuHelpVariables(self, ignored)
{
  contextNumber( TheHelpObject, hWnd(self), HELP_ENTRY_VARIABLE ) ;
}
!!

/* PUBLIC
   Add a symbol descriptor (from the Symbol Manager) to self as a symbol.
*/
Def addVarComposite(self, symbolDesc, varStr, startOffset | rc)
{
  rc := addVarComposite( varBrowser, symbolDesc, varStr, startOffset ) ;
  bringToTop(self);
  ^rc
}
!!

/* PUBLIC
   Add a symbol descriptor (from the Symbol Manager) to self as a symbol.
*/
Def addVarSymbol(self, varSymbol, varNameStr | aVar rc)
{
  rc := addVarSymbol( varBrowser, varSymbol, varNameStr ) ;
  bringToTop( self ) ;
  ^rc
}
!!

/* For VarBrowser */
Def ancestorCommand(self, wP, lP)
{
  ^command( self:ancestor, wP, lP ) ;
}!!

/* PUBLIC */
Def close(self)
{
  close( varBrowser ) ;
  TheVariablePresenter := nil ;
  removeWindowMenu( self ) ;
  close( self:ancestor ) ;  /* Window goes bye bye! */
}
!!

/* Dispatch menu choices, accelerators. 
  NOTES: Nghia - 10/12/93
  Clear ESC key before processing command.
*/
Def command(self, item, lP | msg)
{ 
  select
    case (msg := action(menu, item) )
    is
      /* Clear ESC key */
      if (TaskLibClass$Inst)
         checkAbort(TaskLibClass$Inst);
      endif;
      ^perform( self, item, msg )
    endCase

    case ( doAction(PreLauncher, item) )
    is
      ^self ;
    endCase

    default
      command( varBrowser, item, lP ) ;
  endSelect;
  ^0
}!!

/* PRIVATE 
   If fieldID is nil, grey menu items; else enable fieldID & remember it.
*/
Def enableField(self, fieldID)
{
  if fieldID
  then
    enableMenuItem( menu, fieldID ) ;
    add( fieldEnabled, fieldID ) ;
  else
    do(fieldEnabled,
    {using(fieldID)
      grayMenuItem( menu, fieldID ) ; /* gray each item */
    });
    fieldEnabled := new( Set, 2 ) ;   /* forget grayed items */
  endif ;
  
/*@@ drawMenu( self ) ; @@*/
}
!!

/* MENU
   User wants us to look for a variable by name
*/
Def findVar(self, again?)
{
  ^findVar( varBrowser, again? )
}
!!

/* PRIVATE */
Def init(self)
{
  fieldEnabled := new( Set, 2 ) ;
  initMenus( self ) ;
  registerF1Help(CLIULibraryClass$Inst, HI_ENTRY_VARIABLE,
     getHWnd(self), HELP_ENTRY_VARIABLE);
}!!

/* PRIVATE */
Def initMenuEdit(self | aSubMenu)
{
 /* EDIT menu */  
 aSubMenu  := newPopup(MenuItem, "&Edit");
 addItem( aSubMenu, 
        new(MenuItem, "&Search...", VP_MENU_SEARCH, #menuSearch) );
 addItem( aSubMenu, 
        new(MenuItem, "Search &Next", VP_MENU_SEARCH_NEXT, #menuSearchNext) );
 addItem( aSubMenu, nil);       
 addItem( aSubMenu, 
        new(MenuItem, "&Edit", VP_MENU_EDIT, #menuEdit) );

 ^aSubMenu
}
!!

/* PRIVATE */
Def initMenuFile(self | aSubMenu)
{
 /* FILE menu */  
 aSubMenu  := newPopup(MenuItem, "&File");
 addItem( aSubMenu, 
          new(MenuItem, "E&xit", VP_MENU_EXIT, #menuExit) );

 ^aSubMenu
}
!!

/* PRIVATE */
Def initMenuHelp(self | aMenu)
{
 /* HELP menu */  
 aMenu := newPopup(MenuItem, "&Help");
 addItem(aMenu, new(MenuItem, 
                    "Help &Index",       
                     601, 
                     #menuHelpContents));
 addItem(aMenu, new(MenuItem, 
                    "&Help With Help",        
                     602, 
                     #menuHelpHelp));
 addItem(aMenu, nil);
 addItem(aMenu, new(MenuItem, 
                    "Help With &Variable",        
                     603, 
                     #menuHelpVariables));
 ^aMenu
}
!!

/* PRIVATE */
Def initMenus(self | aSubMenu aSubSub)
{
 menu := create( new(Menu), self ) ;

 addItem( menu, initMenuFile(self) ) ;

 addItem( menu, initMenuEdit(self) ) ;

 addItem( menu, initMenuView(self) ) ;

 addItem(menu, initMenuVariable(self));

 Call AppendMenu( (hMenu := handle(menu)), 
                  MF_POPUP, 
                  windowsMenu(PreLauncher), 
                  asciiz("&Windows") 
                ) ;

 addItem( menu, initMenuHelp(self) ) ;

 checkMenuItem( menu, VP_MENU_HISTORY_SORT ) ;
 grayMenuItem(  menu, VP_MENU_EDIT ) ;
 grayMenuItem(  menu, VP_MENU_SHOW ) ;
 grayMenuItem(  menu, VP_MENU_DELETE ) ;
 grayMenuItem(  menu, VP_MENU_UNDELETE ) ;

 drawMenu( self ) ;
}
!!

/* PRIVATE */
Def initMenuView(self | aSubMenu aSubSub)
{
 /* VIEW menu */  
 aSubMenu  := newPopup(MenuItem, "&View");

 addItem( aSubMenu, 
        new(MenuItem, "&Show", VP_MENU_SHOW, #menuShow) );

 addItem( aSubMenu, 
        new(MenuItem, "&Compress", VP_MENU_COMPRESS, #menuCompress) );
 addItem(aSubMenu, nil); 
 aSubSub  := newPopup(MenuItem, "S&ort");
 addItem( aSubSub, 
        new(MenuItem, "By &History", VP_MENU_HISTORY_SORT, #menuHistorySort) );
 addItem( aSubSub, 
        new(MenuItem, "By &Name", VP_MENU_VNAME_SORT, #menuNameSort) );
 addItem(aSubMenu, aSubSub) ;

 ^aSubMenu
}
!!

/* PRIVATE        [Ron, 5/6/93, Added for Variable Window Enhancements]
 *
 * Display the new Variable pulldown
 */
Def initMenuVariable(self | aSubMenu)
{
 /* VARIABLE menu */  
 aSubMenu  := newPopup(MenuItem, "V&ariable");
 addItem( aSubMenu, 
        new(MenuItem, "&Add...", VP_MENU_ADD_VAR, #menuAddVar) );

 /* the following two were moved here from the EDIT menu */

 addItem( aSubMenu, 
        new(MenuItem, "&Delete", VP_MENU_DELETE, #menuDelete) );
 addItem( aSubMenu, 
        new(MenuItem, "&Undelete", VP_MENU_UNDELETE, #menuUndelete) );

 ^aSubMenu
}
!!
/* PRIVATE (public to VarBrowser) */
Def menu(self)
{ ^menu }
!!

/* MENU */
Def menuAbout(self, ignored)
{
  if not(CLIULibraryClass$Inst) then
     ^nil;
  else
     showAboutBox(CLIULibraryClass$Inst);
  endif;
}
!!

/* MENU */
Def menuAddr(self, ignored)
{
  ^menuAddr(varBrowser, ignored)
}
!!

/* MENU */
Def menuAddVar(self, ignored)
{
  ^menuAddVar(varBrowser)
}
!!

/* MENU */
Def menuCompress(self, ignored)
{
  ^menuCompress(varBrowser, ignored)
}
!!

/* MENU
   INVARIANT: This is only enabled when a variable name has been
   selected.
*/
Def menuDelete(self, ignored)
{
  ^menuDelete(varBrowser, ignored)
}
!!


/* MENU
   INVARIANT: This is only enabled when an editable value field has been
   selected.
*/
Def menuEdit(self, ignored)
{
  ^menuEdit(varBrowser, ignored)
}!!

/* MENU */
Def menuExit(self, ignored)
{
  ^close( self )
}
!!

/* MENU */
Def menuHelpContents(self, ignored)
{
  contents( TheHelpObject, hWnd(self) ) ;
}
!!

/* MENU */
Def menuHelpHelp(self, ignored)
{
  help( TheHelpObject, hWnd(self) ) ;
}
!!

/* MENU */
Def menuHistorySort(self, ignored)
{
  setSortType( self, #history ) ;
  if menu then
    unCheckMenuItem( menu, VP_MENU_VNAME_SORT   ) ;
    checkMenuItem(   menu, VP_MENU_HISTORY_SORT ) ;
  endif ;

  ^0
}
!!

/* MENU */
Def menuNameSort(self, ignored)
{
  setSortType( self, #name ) ;
  if menu then
    unCheckMenuItem( menu, VP_MENU_HISTORY_SORT ) ;
    checkMenuItem(   menu, VP_MENU_VNAME_SORT   ) ;
  endif ;

  ^0
}
!!

/* MENU
   User wants us to look for a variable by name
*/
Def menuSearch(self, ignored)
{
  ^findVar( varBrowser, nil )
}
!!

/* MENU
   User wants us to look for a variable by name
*/
Def menuSearchNext(self, ignored)
{
  ^findVar( varBrowser, #true )
}
!!

/* MENU
   INVARIANT: This is only enabled when an expandable reference field
   has been selected.
*/
Def menuShow(self, ignored)
{
  ^menuShow(varBrowser, ignored)
}
!!

/* MENU */
Def menuUncompress(self, ignored)
{
  ^menuUncompress(varBrowser, ignored)
}
!!

/* MENU
   INVARIANT: This is only enabled after a variable view has been deleted.
*/
Def menuUndelete(self, ignored)
{
  ^menuUndelete( varBrowser, ignored )
}
!!

/* PRIVATE -- can only by VarPresenterClass:open */
Def open(self, symbolDesc, symbolNameStr)
{
  if (varBrowser := open( VarBrowser, clientRect(self), self, nil, WS_HSCROLL ))
    /* Either open blank or add a variable to window */
    if (not(symbolDesc) cor
      addVarSymbol(varBrowser, symbolDesc, symbolNameStr)) then
      ^self
    endif;
  endif;   
  ^nil  /* fatal error */
}
!!

/* PRIVATE -- can only by VarPresenterClass:open */
Def openWithComposite(self, symbolDesc, varStr, startOffset)
{
   if (varBrowser := open( VarBrowser, clientRect(self), self, nil, 0 ))
      cand addVarComposite(varBrowser, symbolDesc, varStr, startOffset)  then
     show( self, SW_SHOWNORMAL);
     ^self
   endif;
   ^nil  /* fatal error */
}
!!


/* WINDOWS */
Def reSize(self, wP, lP | linesWanted)
{
  sizeKids( self ) ;
}
!!

/* Request a search string, and find the variable with this name.
  If nextFlag is true and there is something in searchStr,
  find the next occurence. */
Def searchText(self, nextFlag)
{ 
  ^findVar( varBrowser, nextFlag ) 
}!!

/* WINDOWS */
Def selected(self, fieldType)
{
   ^enableField(self, fieldType) ;
}
!!


/* PRIVATE -- called by sortByVarName or sortByHistory */
Def setSortType(self, newSortType)
{
  ^setSortType(varBrowser, newSortType) 
}!!

/* PUBLIC */
Def show(self, arg)
{
  show(self:ancestor, arg);
  if varBrowser
    show(varBrowser, SW_NORMAL);
  endif;
}  !!

/* WINDOWS */
Def sizeKids(self)
{
  if varBrowser then
    setCRect( varBrowser, clientRect(self) ) ;
    moveWindow( varBrowser ) ;
  endif ;
}
!!

/* WINDOWS */
Def WM_INITMENU(self, wp, lp)
{
  ^WM_INITMENU( PreLauncher, wp, lp ) ;
}
!!

/* Allow "arrow" keys and the tab key to work 
 without using accelerators. */
Def WM_KEYDOWN(self, wp, lp)
{ if /* between(wp, 37, 40) cor */
     (wp == VK_DELETE) cor (wp == 301) /* enable DELete key */
  then 
    command(self, wp, 0x10000);
  else
    WM_KEYDOWN( self:ancestor, wp, lp ) ;
  endif;
}!!

/* WINDOWS
  MS-Window's message to paint self -- sends a
  paint(self) message.  This overrides Window:WM_PAINT
  so that TextWindow and its descendants use the
  System Fixed Font instead of the System Font. */
Def WM_PAINT(self, wP, lP | hdc)
{ hdc := Call BeginPaint(getHWnd(self), paintStruct);
  Call SelectObject(hdc, Call GetStockObject(SYSTEM_FIXED_FONT));
  initTextColors( self, hdc ) ;
  paint(self, hdc);
  Call SelectObject(hdc, Call GetStockObject(SYSTEM_FONT));
  Call EndPaint(getHWnd(self), paintStruct);
  ^0;
}!!

