/* General purpose Button class.  Most buttons are defined along
  with a dialog box, but the Button class enables you to create and
  use buttons in Actor windows even when they weren't defined as part
  of a dialog.

  BUTTON.H (in the RES directory) must be loaded before this class file
  is loaded. */!!

inherit(Control, #Button, #(state /* True or false flag */), nil, nil)!!

now(class(Button))!!

/* Create and return a new button object in Actor and
  Windows. Parent passes the control id, self, the name of
  the new button.  The style argument is a constant which
  defines what type of button will be created (see the
  Actor manual, in the Guide to the Actor Classes). */
Def new(self, id, par, name, style | theBut)
{ theBut := new(self:Behavior);
  setContID(theBut, id);
  setParent(theBut, par);
  create(theBut, name, "BUTTON", style bitOr WS_CHILD);
  ^theBut;
}!!

/* Create and return a new check box. */
Def newCheck(self, id, par, name)
{ ^new(self, id, par, name, BS_CHECKBOX);
}!!

/* Create and return a new default push button. */
Def newDefPush(self, id, par, name)
{ ^new(self, id, par, name, BS_DEFPUSHBUTTON);
}!!

/* Create and return a new push button. */
Def newPush(self, id, par, name)
{ ^new(self, id, par, name, BS_PUSHBUTTON);
}!!

/* Create and return a new radio button. */
Def newRadio(self, id, par, name)
{ ^new(self, id, par, name, BS_RADIOBUTTON);
}!!

now(Button)!!

/* Flip the check box or radio button state, return new state. */
Def flipCheck(self)
{ setCheck(self, not(state));
  ^state;
}!!

/* Flip the button state, return new state. */
Def flipState(self)
{ setState(self, not(state));
  ^state;
}!!

/* Return the check box or radio button state. */
Def getCheck(self)
{ ^state := (sendMessage(self, BM_GETCHECK, 0, 0) ~= 0);
}!!

/* Return the button state.  True if the user is
  pushing the button. */
Def getState(self)
{ ^state := (sendMessage(self, BM_GETSTATE, 0, 0) ~= 0);
}!!

/* Set the check box or radio button state. */
Def setCheck(self, flag)
{ ^sendMessage(self, BM_SETCHECK, ((state := flag) cand 1) cor 0, 0);
}!!

/* Set the button state. */
Def setState(self, flag)
{ ^sendMessage(self, BM_SETSTATE, ((state := flag) cand 1) cor 0, 0);
}!!
