/* Class: GotoIntelAddrDialog
   SubClass of the GotoLineDialog.  -  This class handles goto address 
   input for the Intel family.
   
 */!!

inherit(GotoAddrDialog, #GotoIntelAddrDialog, #(addrSpace
operandAddrSize), 2, nil)!!

now(class(GotoIntelAddrDialog))!!

/* 3/15/1994 11:27  - PUBLIC 
  Create a GotoIntelAddrDialog object and initialize.
  NOTES:
    <addrDesc>  is the input/output address descriptor.
    <addrSize>  is the global state of operand/address Size of the parent
    window.    
*/
Def open(self, addrDesc, addrSize | theDlg)
{ 
  theDlg := new(self:Behavior);
  ^init(theDlg, addrDesc, addrSize); 
}
!!

now(GotoIntelAddrDialog)!!

/* 3/15/1994 11:40  - PRIVATE
  Process command of self, any left over let the ancestor handles. 
*/
Def command(self, wp, lp | spaceTxt)
{ 
  if ((wp == IDOK) and (high(lp) = 0)) then
    if not(spaceTxt := getLBSel(self, DLG_COMBO_ADDR_SPACE)) cor
       not(addrSpace := translateAddrSpace(AddressLibClass$Inst, spaceTxt)) then
       ^nil;
    endif;  
    /* Set the user specified address space */
    setAddrSpace(AddressLibClass$Inst, addrDesc, addrSpace);
    operandAddrSize  := getLBSel(self, DLG_COMBO_ADDR_SIZE);
  endif;
  /* ancestor does the rest of the work */
  ^command(self:ancestor, wp, lp);  
}
!!

/* 3/15/1994 11:34 - PRIVATE
  init instance variables.
*/
Def init(self, newAddr, newSize)
{ 
  addrDesc := newAddr;
  if not(addrSpace := getAddressSpace(AddressLibClass$Inst, addrDesc)) then
     addrSpace := ADDR_SPACE_DEFAULT; 
  endif;
  operandAddrSize := newSize;
}
!!

/* 3/15/1994 11:17 - PRIVATE
  Load the specified combo box with the items in the <txtColl>.
  Set the current selection as the specified input <selIdx> and return
  the selection index.
  Return nil if failed. 
*/
Def initComboBox(self, comboId, txtColl, selIdx)
{ 
  clearCBText(self, comboId);
  if txtColl cand (size(txtColl) > 0) then
    do (txtColl,
      {using(txtElement)
        addCBText(self, comboId, txtElement);
      }); 
    /* Set current selection and focus */  
    ^sendDlgItemMessage(self, comboId, LB_SETCURSEL, selIdx, 0L); 
  endif;
  ^nil;
}
!!

/* 3/15/1994 10:24 - PRIVATE
  Initialize the GotoIntelAddrDialog object.
*/
Def initDialog(self, wp, lp | spaceColl, txtColl, addrTxt) 
{ 
 /* Retrieve the address Spaces list from the Address Server */
 if not(spaceColl := getAddressSpaces(AddressLibClass$Inst)) cor
    not(initComboBox(self, DLG_COMBO_ADDR_SPACE, spaceColl, 0)) then
   /* disable the control */
   disableItem(self, DLG_COMBO_ADDR_SPACE);  
 else
   if (addrTxt := getAddrSpaceText(AddressLibClass$Inst, addrSpace)) then
     sendDlgItemMessage(self, DLG_COMBO_ADDR_SPACE, LB_SELECTSTRING, addrTxt, 0L); 
   endif;         
 endif;
 
 /* Set the operand/AddressSize */
 txtColl := new(TextCollection, 3);
 add(txtColl, "Auto");
 add(txtColl, "Use16");
 add(txtColl, "Use32");
 if not(initComboBox(self, DLG_COMBO_ADDR_SIZE, txtColl, operandAddrSize)) then
   disableItem(self, DLG_COMBO_ADDR_SIZE);   
 endif;  
 /* Call ancestor to do the rest of the work */ 
 ^initDialog(self:ancestor, wp, lp); 
}
!!