/* CLI Assignment node:
   CLI:  a = b;
   Actor:  a := b; */!!

inherit(Object, #CLIAssignmentNode, #(target /* left side of assignment */
value  /* right side of assignment */
source /* statement reconstruction */), 2, nil)!!

now(class(CLIAssignmentNode))!!

now(CLIAssignmentNode)!!

/* Compile the node into Actor source. */
Def CLICodeCompile(self)
{
  /* delaying the assignment, and using value in SHELL_STATUS allows
     more complex assignment forms such as "$var = run..." */
  expressionEchoOff(getExecutionEngine(CLIExecEngine));
  CLICodeCompile(value);
  CLICodeCompile("; assignValue(self, "+doubleQuoteString(CLIUtilities));
  CLICodeCompile(target);
  CLICodeCompile(doubleQuoteString(CLIUtilities)+
    ", getRValue(self, "+doubleQuoteString(CLIUtilities)+
    "SHELL_STATUS"+doubleQuoteString(CLIUtilities)+"))");
  expressionEchoOn(getExecutionEngine(CLIExecEngine));
}
!!

Def init(self, tar, val, src)
{
  target := tar;
  value := val;
  source := src;
}!!
