/* Event server library */!!

inherit(ProvidedLibs, #EventLib, #(initialized), 2, nil)!!

setClassVars(EventLib, #())!!

now(class(EventLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self, path)
{ 
  ^initialize( new(self:ancestor), path )
}
!!

now(EventLib)!!

/* PRIVATE */
Def addImportProcs(self)
{
  add( self, #INITCSERVER, 1, #(0, 0) ) ;
  add( self, #EVTOPENEVENT, 1, #(1, 1) ) ;
  add( self, #EVTCLOSEEVENT, 1, #(1) ) ;
  add( self, #EVTRESTOREEVENTS, 1, #(1) ) ;
  add( self, #EVTSAVEASEVENTS, 1, #(1) ) ;
  add( self, #EVTSETACTIVEEVENT, 1, #(1, 1) ) ;
  add( self, #EVTGETACTIVEEVENT, 1, #(1, 1, 0) ) ;
  add( self, #EVTCLEAREVENT, 1, #(1) ) ;
  add( self, #EVTDELETEEVENT, 1, #(1) ) ;
  add( self, #EVTDELETEALLEVENTS, 1, nil ) ;
  add( self, #EVTSETACTIVEFIELD, 1, #(1, 1) ) ;
  add( self, #EVTGETACTIVEFIELD, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETNOTCONDITION, 1, #(1, 0) ) ;
  add( self, #EVTGETNOTCONDITION, 1, #(1, 1) ) ;
  add( self, #EVTSETENDFUNCTION, 1, #(1, 0) ) ;
  add( self, #EVTGETENDFUNCTION, 1, #(1, 1) ) ;
  add( self, #EVTSETEND, 1, #(1, 1) ) ;
  add( self, #EVTGETEND, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETMASK, 1, #(1, 1) ) ;
  add( self, #EVTGETMASK, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETSTART, 1, #(1, 1) ) ;
  add( self, #EVTGETSTART, 1, #(1, 1, 0) ) ;
  add( self, #EVTSETSTARTANDMASK, 1, #(1, 1) ) ;
  add( self, #EVTGETSTARTANDMASK, 1, #(1, 1, 0) ) ;
  add( self, #EVTNUMDEFINEDEVENTS, 1, #(1, 1) ) ;
  add( self, #EVTGETNEXTEVENT, 1, #(1, 1, 0) ) ;
}!!

/* PUBLIC -- create a event instance */
Def eventOpen(self, templateName | aEvent, rc, descriptorPtr) 
{ 
  aEvent := new( Event ) ;
  descriptorPtr := new( Struct, 4 ) ;
  
  if pcallLock(self)
  then
    rc := pcall(procs[#EVTOPENEVENT], descriptorPtr, templateName) ;
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  
  if (rc <> 0)
  then
    ^nil ;
  endif ;
  
  setDescriptor( aEvent, longAt(descriptorPtr, 0) );
  setProcs( aEvent, procs(self) ) ;
  
  ^aEvent
}!!

/* PRIVATE 
   Open and initialize trigger server library & load trigger dll
*/
Def initialize(self, path)
{ 
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* EventLib Class Initialization Code */
