/* Window that contains the trigger specification data. One of these windows exist for each level in the trigger hardware the user setups. */!!

inherit(Window, #TrigSpecWindow, #(eventMap /* 0 => ev0, etc. */
id /* counter to get track of the next available id number */
specColl /* ordered collection of ordered collections that hold edit fields (FieldNameWindow) and check boxes */
activeWindow
counterCheckSpacing /* array of spacing information when in counter mode */
timerCheckSpacing /* array of spacing information when in timer mode */
counterTimerMode  /* tells which mode display is currently in */
lineIncr  /* yPos increment between rows of check boxes */), 2, nil)!!

setClassVars(TrigSpecWindow, #(extButton ButtonTitle ExtInBit ExtInLH
))!!

now(class(TrigSpecWindow))!!

now(TrigSpecWindow)!!

/* 11/15/1995 15:28 */
Def trigExtInSelect(self | dlg rc){   
  dlg := new(ExtInSelectDialog);
  rc := runModal(dlg, 426, ThePort);
  ^rc;
  /*  426 is the dialogbox id for ExtInSelectDialog */
}
!!

/* 11/15/1995 15:27 */
Def setButtonTitle(self)
{
  setText(extButton,ButtonTitle);
}
!!

/* 11/15/1995 15:24 */
Def GetExtButtonTitle(self | ExtVal)
{ ExtVal := trigExtEventGet(trigger(parent));   /*  parameter 0 means don't care by server  */
  ExtInBit := ExtVal bitAnd 0x3f ;
  if ((ExtVal bitAnd 0x80) <> 0) then
    ExtInLH := "Lo";
  else
    ExtInLH := "Hi";
  endif;
  ButtonTitle := "Bit "+asString(ExtInBit)+" "+asString(ExtInLH); 
}
!!

/* 11/1/1995 15:11 */
Def clearAction( self menuId startId endId | tmpBox i rc )
{
  i := startId;
  loop while i <= endId
    if i <> menuId then
      tmpBox := findCheckBox(self,i);
      Call SendMessage(getHWnd(tmpBox), BM_SETCHECK, 0, 0);
      rc:=trigActionClear(trigger(parent),action(tmpBox));
    endif;
    i := i + 1;
  endLoop;
}
!!

/* 10/30/1995 9:50 */
Def clearActionGroup(self menuId | tmpId dest)
{
  tmpId := (menuId-222) mod 15;
  dest := menuId-222-tmpId ;
  select
    case (tmpId = 1 cor tmpId = 2) is
      clearAction(self,menuId,223+dest,224+dest);
    endCase
    case (tmpId = 4 cor tmpId = 5) is
      clearAction(self,menuId,226+dest,227+dest);
    endCase
    case (tmpId = 6 cor tmpId = 7) is
      clearAction(self,menuId,228+dest,229+dest);
    endCase
    case (tmpId = 8 cor tmpId = 9) is
      clearAction(self,menuId,230+dest,231+dest);
    endCase
  endSelect;
  ^GOOD;
}
!!

Def WM_LBUTTONDOWN(self, wp, lp)
{ if activeWindow
   ^sendMessage(findEditWindow(self,activeWindow), CB_SHOWDROPDOWN, 0, 0L);
  endif;
}!!

/* 10/14/1992 16:41 */
Def updateSelf(self){
  handleActiveWindow(self);
}
!!

/* PUBLIC
   Return calculated font info.
 */
Def getFont(self)
{ ^getFont(parent);
}
!!

/* PRIVATE */
Def addActionChecks(self, coll, eventCond){
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_SEQ_ACTION, eventCond, nil));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_RESET_ACTION, eventCond, nil));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_EM_BREAK_ACTION, eventCond, nil));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_TRG_HALT_ACTION, eventCond, nil));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_TRG_CONT_ACTION, eventCond, nil));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_INC_0_ACTION, eventCond, COUNTER_BOX));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_RESET_0_ACTION, eventCond, COUNTER_BOX));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_INC_1_ACTION, eventCond, COUNTER_BOX));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_RESET_1_ACTION, eventCond, COUNTER_BOX));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_TIMER_START_ACTION, eventCond, TIMER_BOX));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_TIMER_STOP_ACTION, eventCond, TIMER_BOX));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_TIMER_RESET_ACTION, eventCond, TIMER_BOX));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_EXT_TIMER_ON, eventCond, nil));
  add(coll,newActionCheck(TriggerCheck, getNextId(self),
                          self, TRIG_EXT_TIMER_OFF, eventCond, nil));
}!!

/* PRIVATE */
Def addEventCheck(self, coll, eventCond){
  add(coll,newEventCheck(TriggerCheck,
                         getNextId(self),
                         self, eventCond));
}
!!

/* PRIVATE */
Def addExtCheck(self, coll, eventCond){
  add(coll,newExtCheck(TriggerCheck,
                         getNextId(self),
                         self, eventCond));
}
!!

/* 6/2/1992 9:46 */
Def allocateAndShowBoxes(self, value, coll | eventCond line) {
  if( (value <> 0) cand (size(coll) < 3) )
    eventCond := eventCondition(coll[1]);
    addExtCheck(self, coll, eventCond);
    addActionChecks(self, coll, eventCond);
  endif;
  if( value <> 0 )
    line := findCheckBoxLine(self,coll[1]);
    moveAndShowBoxes(self,coll,counterTimerMode,line);
  else  /* if boxes exists but no event selected then make sure boxes are hidden */
    do(over(2,size(coll)),
    {using(boxIdx)
      show(coll[boxIdx],SW_HIDE);
    });
  endif;
}
!!

/* PUBLIC
   Determines if the incoming text string is already defined.  In the
   trigger spec window we don't care if the same event name is used
   more than once.
 */
Def alreadyDefined(self,child,text) {
  ^nil;
}!!

/* comment */
Def aREAD_ME(self)
{
/*

*/
}

!!

/* PUBLIC */
Def closeSelf(self | cond)
{
  if activeWindow
    handleActiveWindow(self);
  endif;
}
!!

/* PRIVATE
   Respond to the menu events and when the user clicks the left
   button in one of the child windows.  If responding to a menu selection
   pass control to our ancestor.  Otherwise we need to memorize the new
   active window.  When a window loses focus we need to verify the input
   that was captured while that window was active.
 */
Def command(self, menuId, lp | box value cond line yPos rc) {
/*printNewLine("TrigSpec: wp: "+asString(menuId));
printNewLine("  low(lp): "+asString(low(lp))+"; high(lp): "+asString(high(lp)));
*/  if activeWindow cand (menuId <> activeWindow)
    handleActiveWindow(self);
  endif;

  if low(lp) = 0
    ^command(self:ancestor,menuId,lp);
  endif;

  select
    case high(lp) = 4  /* CBN_KILLFOCUS */
      handleActiveWindow(self);
    endCase
    case high(lp) = 3  /* CBN_SETFOCUS */
      activeWindow := menuId;
      if (setupList(findEditWindow(self,menuId)) = 0)
        trigEvent(parent);
      endif;
    endCase
    case high(lp) = 512  /* EN_KILLFOCUS */
      handleActiveWindow(self);
    endCase
    case high(lp) = 256  /* EN_SETFOCUS */
      activeWindow := menuId;   /* need to process counter values when lose focus */
    endCase
    case (high(lp) = 0 /* button clicked */)
     if (menuId = 220) then
          rc := trigExtInSelect(self);
        if (rc = 1) then
          GetExtButtonTitle(self);
          setButtonTitle(self);
        endif;   
     else

      box := findCheckBox(self,menuId);
      line := findLine(self,menuId);
      value := Call SendMessage(getHWnd(box), BM_GETCHECK, 0, 0);
      trigEventSet(trigger(parent),eventCondition(box));
      if isEvent(box)
        if (value <> 0)      /* uses want to use an event */
            cand (line < 8)  /* event to use references an event0-7 */
            cand (size(getSelString(specColl[line][0]))=0) /* no event name found */          value := 0;
          Call SendMessage(getHWnd(box), BM_SETCHECK, value, 0);
          ^displayError(ErrorTextLibClass$Inst, ER_NO_ACTIVE_EVENT, FORCE_POPUP);
        endif;
        if (menuId = 221) then
          rc := trigExtSet(trigger(parent),value);
        else
          rc := trigEventEnableSet(trigger(parent),value);
        endif;  
        if( rc <> 0 )
          if( value = 1 ) value := 0;
          else value := 1;
          endif;
          Call SendMessage(getHWnd(box), BM_SETCHECK, value, 0);
        endif;
        allocateAndShowBoxes(self, value, specColl[line]);
        if value = 0
          do(over(2,size(specColl[line])), /* if user disables event hide row */
          {using(elem)
            show(specColl[line][elem],SW_HIDE);
          });
        endif;
      endif;
      if isExt(box)
        rc := trigExtSet(trigger(parent),value);
        if( rc <> 0 )
          if( value = 1 ) value := 0;
          else value := 1;
          endif;
          Call SendMessage(getHWnd(box), BM_SETCHECK, value, 0);
        endif;
      endif;
      if action(box)
       if value <> 0
          clearActionGroup(self,menuId);
          rc:=trigActionSet(trigger(parent),action(box));
          value := 0;
        else
          rc:=trigActionClear(trigger(parent),action(box));
          value := 1;
        endif;
        if( rc <> 0 )
          Call SendMessage(getHWnd(box), BM_SETCHECK, value, 0);
        endif;
      endif;
     endif; 
    endCase
  endSelect;
}

!!

/* PRIVATE */
Def findCheckBox(self, id)
{
  do(size(specColl),    /* last line radically different */
  {using(i)
    do(over(1,size(specColl[i])), /* need to skip first field (not a check box) */
    {using(j)
      if id(specColl[i][j]) = id
        ^specColl[i][j];
      endif;
    });
  });
  ^nil;
}
!!

/* PRIVATE */
Def findCheckBoxLine(self, checkBox)
{
  do(size(specColl),    /* last line radically different */
  {using(i)
    do(over(1,size(specColl[i])), /* need to skip first field (not a check box) */
    {using(j)
      if id(specColl[i][j]) = id(checkBox)
        ^i;
      endif;
    });
  });
  ^nil;
}
!!

/* PRIVATE
   Searches the fieldName and Spaces objects in specColl to see if the
   incoming id is found.
 */
Def findEditWindow(self,id)
{
  do(size(specColl),                /* Last line of collection doesn't
                                         contain an edit window. */
  {using(i)
    if id(specColl[i][0]) = id
      ^specColl[i][0];
    endif;
  });
  ^nil;
}
!!

/* PRIVATE */
Def findLine(self, id)
{
  do(size(specColl),    /* last line radically different */
  {using(i)
    do(over(1,size(specColl[i])), /* need to skip first field (not a check box) */
    {using(j)
      if id(specColl[i][j]) = id
        ^i;
      endif;
    });
  });
  ^nil;
}
!!

/* PRIVATE
   Returns the next numerical id number.
 */
Def getNextId(self | tmp){
  tmp := id;
  id := id + 1;
  ^tmp;
}
!!

/* 6/2/1992 11:46 */
Def handleActiveWindow(self | cond win str counter){
  if not(activeWindow)
     ^self;
  endif;
  win := findEditWindow(self,activeWindow);
  activeWindow := nil;
  if( win )
    cond := eventCondition(win);
    trigEventSet(trigger(parent), cond);
    if verifyInput(win)
      select
        case (cond = TRIG_TC_0_COND)
          trigCounterValueSet( trigger(parent), 0, getValue(win));
        endCase
        case (cond = TRIG_TC_1_COND)
          trigCounterValueSet( trigger(parent), 1, getValue(win));
        endCase
        case (cond <> TRIG_EXT_COND )
          if( str := getSelString(win) )
            trigEventNameSet( trigger(parent), str);
          endif;
        endCase
      endSelect;
    endif;
    if( (cond = TRIG_TC_0_COND) cor (cond = TRIG_TC_1_COND) )
       counter := 0;
       if (cond = TRIG_TC_1_COND)
         counter := 1;
       endif;
       setValue(win, trigCounterValueGet(trigger(parent), counter));
    endif;
  endif;
}
!!

/* PRIVATE */
Def init(self | extWin){
  GetExtButtonTitle(self);
  eventMap :=
      tuple(TRIG_EV_0_COND, TRIG_EV_1_COND, TRIG_EV_2_COND, TRIG_EV_3_COND,
            TRIG_EV_4_COND, TRIG_EV_5_COND, TRIG_EV_6_COND, TRIG_EV_7_COND,
            TRIG_TC_0_COND, TRIG_TC_1_COND, TRIG_EXT_COND);
  lineIncr := charHeight(parent) + 5;
  initCheckSpacing(self);
  specColl := new(OrderedCollection, 11);
  id := 200;

  /* first eight lines contain the possible event conditions */
  do(over(0,8),
  {using(i)
    add(specColl,new(OrderedCollection,17));
    /* The event name is the same as the FieldName of the event
       template.  It uses an edit box and verifies for valid
       symbol type names.
     */
    add(specColl[i],newEventWindow(TriggerEventWindow,getNextId(self),
                                       self,eventMap[i]));
    addEventCheck(self, specColl[i], eventMap[i]);
    moveEvent(self,i);
  });

  /* next two lines contain the counter/timer event conditions. This
     is different then the event conditions because the edit field
     needs to only except numbers not names much like the windows
     for the event name.
   */
  do(over(8,10),
  {using(i)
    add(specColl,new(OrderedCollection,17));
    add(specColl[i],newEventEditWindow(SpacesWindow,getNextId(self),
                                       self, eventMap[i]));
    addEventCheck(self, specColl[i], eventMap[i]);
    moveEvent(self,i);
  });

    add(specColl,new(OrderedCollection,16));
    add(specColl[10],extButton := newPush(Button,getNextId(self),self,ButtonTitle));
    sendMessage(extButton,0x0030/*WM_SETFONT*/,getFont(self),0L);
    addEventCheck(self, specColl[10], eventMap[10]);
    moveEvent(self,10);
  counterTimerMode := trigCounterFunctionGet(trigger(parent));
}
!!

Def initCheckSpacing(self | width halfWit )
{
  /* x pos of fields as #pixels */
  width := charWidth(parent);
  halfWit := width / 2;

  /* the following tables tell how many pixels to skip before
     each field.
   */
  counterCheckSpacing :=
     tuple(  ( 2 ),   /* eventfield,spaceswindow or static */
             (14*width-2 ),   /* event enable check box */
             ( 5*width ),   /* ext enable check box */
             ( 5*width ),   /* seq */
             ( 4*width+halfWit ),   /* brk */
             ( 4*width+halfWit-1 ),   /* reset */
             ( 4*width ),   /* toff */
             ( 4*width+halfWit+1 ),   /* next */
             ( 5*width-1 ),   /* inc0 */
             ( 4*width+2 ),   /* rst0 */
             ( 4*width+halfWit ),   /* inc1 */
             ( 4*width+2 ),   /* rst1 */
             (       0 ),   /* start timer */
             (       0 ),   /* stop timer */
             (       0 ),   /* rest timer */
             ( 6*width ),   /* ext trig on */
             ( 6*width+halfWit )    /* ext trig off */
           ) ;

  timerCheckSpacing :=
     tuple(  ( 2 ),   /* eventfield,spaceswindow or static */
             (14*width-2 ),   /* event enable check box */
             ( 5*width ),   /* ext enable check box */
             ( 5*width ),   /* seq */
             ( 4*width+halfWit ),   /* brk */
             ( 4*width+halfWit-1 ),   /* reset */
             ( 4*width ),   /* toff */
             ( 5*width-2 ),   /* next */
             ( 0 ),   /* inc0 */
             ( 0 ),   /* rst0 */
             ( 0 ),   /* inc1 */
             ( 0 ),   /* rst1 */
             ( 5*width ),   /* start timer */
             ( 5*width ),   /* stop timer */
             ( 6*width-2 ),   /* reset timer */
             ( 7*width-2 ),   /* ext trig on */
             ( 7*width )    /* ext trig off */
           ) ;
}!!

/* 6/2/92 */
Def moveAndShowBoxes(self, coll, newMode, line | xPos yPos spacing width
                                                 special)
{
  if newMode = TRIG_AS_COUNTER
    spacing := counterCheckSpacing;
  else
    spacing := timerCheckSpacing;
  endif;
  /* ignore micepack TRIG_EXT_COND events */
  if (eventCondition(coll[1]) = TRIG_EXT_COND) 
    special := 1;
  else
    special := nil;
  endif;
  xPos := 0;
  yPos := charHeight(parent);
  if( line <> 0 )
    yPos := yPos + (lineIncr*line);
  endif;
  if( line = 8 cor line = 9 )
    yPos := yPos + 5;
  endif;
  if( line = 10 )
    yPos := yPos + 4;
  endif;
  width := charWidth(parent);
  xPos := xPos + spacing[0] + spacing[1] + spacing[2];
  if not(special)
    sizeMoveAndShowCheckBox(self,coll[2],xPos,yPos);    /* ext */
  endif;
  do(over(3,size(coll) - 1),   /* Modified by Jimmy 11/11/94 to hide last check box */
  {using(idx)
    xPos := xPos + spacing[idx];
    if not(boxType(coll[idx]))
      sizeMoveAndShowCheckBox(self,coll[idx],xPos,yPos);
    else
      if ((newMode = TRIG_AS_COUNTER)
           cand (boxType(coll[idx])= COUNTER_BOX))
         or
         ((newMode = TRIG_AS_TIMER)
           cand (boxType(coll[idx])= TIMER_BOX))
        sizeMoveAndShowCheckBox(self,coll[idx],xPos,yPos);
      endif;
    endif;
  });
}
!!

/* PRIVATE */
Def moveEvent(self, line | xPos yPos width rect){
  xPos := 0;
  width := charWidth(parent);
  yPos := charHeight(parent);
  if( line <> 0 )
    yPos := yPos + (lineIncr*line);
  endif;
  /* spacing for first two fields is the same for both timer and counter modes */
  /* event name or counter value field */
  xPos := xPos + counterCheckSpacing[0];
  if( line < 8 cand line >= 0 )
    rect := rect(xPos, yPos, xPos+(width*13)-1, (yPos+lineIncr));
  endif;
  if( line = 8 cor line = 9 )
    rect := rect(xPos+(width*4), yPos+4, xPos+(width*13)-1, (yPos+lineIncr+4));
    yPos := yPos + 4;
  endif;
  if( line = 10 )
    rect := rect(xPos+(width*4), yPos+4, xPos+(width*13)-1, (yPos+lineIncr+2));
    yPos := yPos + 3;
  endif;
  setCRect(specColl[line][0], rect);
  moveWindow(specColl[line][0]);
  /* position use event box */
  yPos := yPos + 1;
  xPos := xPos + counterCheckSpacing[1];
  setCRect(specColl[line][1], rect(xPos, yPos, xPos+(width*3), (yPos+charHeight(parent))));
  moveWindow(specColl[line][1]);
}
!!

/* 6/2/1992 6:57 */
Def musicalBoxes(self, newMode)
{
  if( newMode <> counterTimerMode )
    counterTimerMode := newMode;
    /* hide all boxes to avoid gliches in display */
    do( over(0,size(specColl)),
    {using(specIdx | coll)
      coll := specColl[specIdx];
      do(over(3,size(coll)),
      {using(idx)
        if boxType(coll[idx])
          show(coll[idx],SW_HIDE);   /* only make mode specific boxes invisible */
        endif;
      });
    });
    do( over(0,size(specColl)),
    {using(specIdx | coll value)
      coll := specColl[specIdx];
      value := Call SendMessage(getHWnd(coll[1]), BM_GETCHECK, 0, 0);
      if( (value<>0) cand (size(coll) > 2) )
        moveAndShowBoxes(self,coll,counterTimerMode,specIdx);
      endif;
    });
  endif;
}
!!

/* PUBLIC
 */
Def paint(self, hdc | width oldFont aStr startPt endPt value height
                      charHeight charWidth showVal lineSpacing){
  width := width(cRect);
  charHeight := charHeight(parent);
  if oldFont := Call SelectObject(hdc,getFont(parent))
    initTextColors(self,hdc);
    if counterTimerMode = TRIG_AS_COUNTER
      aStr := "    event      enable ext in   seq    rst   brk  toff  next  inc0  rst0  inc1  rst1   ext out         ";
    else
      aStr := "    event      enable ext in   seq    rst   brk  toff  next  start   stop   reset    ext out          ";
    endif;
    Call TextOut(hdc, 0, 0, aStr, size(aStr));
    height:= (lineIncr*8) + charHeight + 6;
    if counterTimerMode = TRIG_AS_COUNTER
      Call TextOut(hdc, 0, height, "cnt0", 4);
      height:= height + lineIncr;
      Call TextOut(hdc, 0, height, "cnt1", 4);
    else
      Call TextOut(hdc, 0, height, "tmr ", 4);
    endif;
    height:= height + lineIncr;
    Call TextOut(hdc, 0, height, "Ext ", 4);
    Call SelectObject(hdc,oldFont);
  endif;
  showVal := SW_HIDE;           /* hide cnt1 row */
  if counterTimerMode = TRIG_AS_COUNTER
    showVal := SW_SHOW;
  endif;
  show(specColl[9][0],showVal);
  show(specColl[9][1],showVal);
  value := Call SendMessage(getHWnd(specColl[9][1]), BM_GETCHECK, 0, 0);
  if( value = 0 ) showVal := SW_HIDE; endif;
  do(over(2,size(specColl[9])), /* hide or show the ext and action boxes */
  {using(elem)
    show(specColl[9][elem],showVal);
  });
  charWidth := charWidth(parent);
  startPt := point(0, charHeight-2);
  endPt := point(width,charHeight-2);
  line(startPt,endPt,hdc);
  width := (charWidth*22)+(charWidth/2)-1;
  fill(rect(width,0,width+3,height(cRect)),stock(BLACK_BRUSH),hdc);
  lineSpacing :=
     tuple(  ((charWidth*31)+3),           /* between rst and brk */
             (charWidth*36),               /* between brk and toff */
             ((charWidth(parent)*44)+6),   /* between next and inc0 */
             ((charWidth(parent)*54)-2),   /* between inc1 and rst0 */
             ((charWidth*64)-5)            /* between rst1 and ext lo */
           ) ;
  if counterTimerMode <> TRIG_AS_COUNTER
    lineSpacing[4] := (charWidth*62)-2;
  endif;
  do(5,
  {using(idx)
    width := lineSpacing[idx];
    startPt := point(width, 0);
    endPt := point(width,height(cRect));
    line(startPt,endPt,hdc);
  });
}
!!

/* PRIVATE */
Def setupCheckBoxes(self, coll | eventActive value rc){
  Call SendMessage(getHWnd(coll[1]), BM_SETCHECK,
                   eventActive :=trigEventEnableGet(trigger(parent)), 0);
  allocateAndShowBoxes(self, eventActive, coll);
  if( eventActive )
    do(over(2,size(coll)),
    {using(boxIdx | box action)
      box := coll[boxIdx];
      action := trigActionGet(trigger(parent));
      if isExt(box)
/*  below modified by Jimmy 11/11/94  */
        rc := trigExtGet(trigger(parent));
        if( rc <> 0 ) value := 1;
        else value := 0;
        endif;
        Call SendMessage(getHWnd(box), BM_SETCHECK, value, 0);
/*  above modified by Jimmy 11/11/94  */
      else
        if action(box)
          if (action bitAnd action(box)) = 0
            Call SendMessage(getHWnd(box),BM_SETCHECK,0,0);
          else
            Call SendMessage(getHWnd(box),BM_SETCHECK,1,0);
          endif;
        endif;
      endif;
    });
  endif;
}!!

/* PUBLIC */
Def setupLevel(self){
  /* setup the event lines */
  do(over(0,8),
  {using(lineIdx)
    setupList(specColl[lineIdx][0]);
    trigEventSet(trigger(parent),eventCondition(specColl[lineIdx][0]));
    selectString(specColl[lineIdx][0], trigEventNameGet(trigger(parent)));
    setupCheckBoxes(self, specColl[lineIdx]);
  });

  /* setup the counter lines */
  do(over(8,10),
  {using(lineIdx | counter)
    if (counterTimerMode = TRIG_AS_COUNTER) cor
       (eventCondition(specColl[lineIdx][0]) <> TRIG_TC_1_COND)
      trigEventSet(trigger(parent),eventCondition(specColl[lineIdx][0]));
      counter := 0;
      if eventCondition(specColl[lineIdx][0]) = TRIG_TC_1_COND
        counter := 1;
      endif;
      setValue(specColl[lineIdx][0],
        trigCounterValueGet(trigger(parent), counter));
      setupCheckBoxes(self, specColl[lineIdx]);
    endif;
  });

  /* setup the ext line if not micepack */
    trigEventSet(trigger(parent),eventCondition(specColl[10][1]));
    setupCheckBoxes(self, specColl[10]);
}
!!

/* PUBLIC
   Show self and all of the child windows.
 */
Def show(self, arg)
{ show(self:WindowsObject, SW_NORMAL);
  do( over(0,size(specColl)),
  {using(specIdx | coll)
    coll := specColl[specIdx];
    if((counterTimerMode = TRIG_AS_COUNTER)
       cor ((counterTimerMode = TRIG_AS_TIMER) cand (specIdx <> 9)) )
      show(coll[0],SW_NORMAL);
      show(coll[1],SW_NORMAL);
    endif;
  });
}!!

/* PRIVATE
 */
Def sizeMoveAndShowCheckBox(self,win,xPos,yPos|width) {
  width:=charWidth(parent);
  setCRect(win, rect(xPos, yPos, xPos+(width*3), (yPos+charHeight(parent))));
  moveWindow(win);
  show(win,SW_SHOW);
}!!
