/* A  Cursor Link Server contians registrants which accept a NewPC
    message.  Any Actor entity may send a propagatePC message to
    this server.  The newPC message will be sent to all registrants
    except the sender.  The sender of propagatePC need not be registered.

   propagatePC, register, and unRegister are the only public methods here.
   All inherited methods are private.
*/!!

inherit(Set, #CLServer, #(currentLCAddress), 2, 0)!!

now(class(CLServer))!!

now(CLServer)!!

/* 7/21/1993 17:32 - PUBLIC */
Def getCurrentLCAddress(self)
{ 
  if currentLCAddress then
    ^duplicateAddress(AddressLibClass$Inst, currentLCAddress);
  endif;
  ^nil;  
}
!!

/* 7/21/1993 16:57 - PUBLIC 
  close the CLServer.
*/
Def close(self)
{ 
  if currentLCAddress then
    destroyAddress(AddressLibClass$Inst, currentLCAddress);
  endif;  
}
!!

/* PUBLIC -- pc is an Address Descriptor
 Example call: PropagatePC( TheCursorLinkServer, self, addrDesc ) ;
*/
Def propagatePC(self, sender, pc)
{
  do(self,
  {using(registrant)
     if (registrant <> sender) then
       if pc then
          newPC(registrant, duplicateAddress( AddressLibClass$Inst, pc));
       else
          newPC(registrant, pc); /* sending nil the clean the old LC */
       endif;        
     endif;
  });
  /* consume the original address */
  if currentLCAddress then
    destroyAddress(AddressLibClass$Inst, currentLCAddress);
  endif;
  /* Save the currentLC for cold link */
  currentLCAddress := pc;
}
!!

/* PUBLIC -- register a new client, i.e. one who wants NewPC messages */
Def unRegister(self, registrant)
{
  if (registrant in self) then
    remove(self:ancestor, registrant);
  endif ;
}
!!

/* PUBLIC -- register a new client, i.e. one who wants NewPC messages */
Def register(self, registrant)
{
  ^add( self:ancestor, registrant )
}
!!