/* class comment */!!

inherit(Dialog, #GotoDialog, #(value /* value for display */), 2, nil)!!

setClassVars(GotoDialog, #())!!

now(class(GotoDialog))!!

Def open(self | dlg)
{
  dlg := new(self);
  ^dlg;
}!!

now(GotoDialog)!!

/* 4/16/1993 11:58 */
Def initDialog(self, wp, lp)
{
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_GOTO_ADDRESS,
     getHWnd(self), HE_DLGR_GOTO_ADDRESS);
  /* place initial value */
  if value
    setItemText(self, DLG_GOTO_ADDRESS, value);
  endif;
  
  /* set item focus */  
  ^1;  /* informs Windows to set focus to tab stop 1 */
}
!!

/* 4/16/1993 11:58 */
Def getValue(self)
{
  ^value;
}
!!

/* 4/16/1993 11:58 */
Def setValue(self, newValue)
{
  value := newValue;
  
  ^0;
}
!!

Def command(self, wp, lp | s1 index)
{
  select
    case wp == IDCANCEL and high(lp) = 0 is
      end(self, IDCANCEL);
    endCase
    case wp == IDHELP 
      is contextNumber(TheHelpObject, hWnd, HE_DLGR_GOTO_ADDRESS);
    endCase
    case wp == IDOK and high(lp)= 0 is
      s1 := peelBlanks(getItemText(self, DLG_GOTO_ADDRESS));
      if (s1  = "")
        displayFormattedError(ErrorTextLibClass$Inst, 
           ER_ADDRESS_MISSING, FORCE_POPUP, "Go To", nil, nil);
        setItemFocus(self, DLG_GOTO_ADDRESS);
        ^0;
      endif;
      
      if not(getSymbolicOffset(AddressLibClass$Inst, s1))
        setItemFocus(self, DLG_GOTO_ADDRESS);
        ^0;
      endif;
      
      /* input is acceptable; save previously obtained value, end */
      value := s1;
      end(self, IDOK);
    endCase
  endSelect;
  ^0;
}!!

