/* Class of windows which hold numeric values */!!

inherit(Edit, #SpacesWindow, #(intValue /* holds value for each instant */
eventCondition  /* holds trigger event mask for TrigSpecWindow */
), 2, nil)!!

now(class(SpacesWindow))!!

/* PUBLIC
   Create a new trailing spaces window which is an Actor edit control object 
   and a Windows "Edit" control window.
 */
Def new (self, id, par | aSpacesWindow)
{ 
  aSpacesWindow := new(self:Behavior);
  setVars(aSpacesWindow, id, par);
  create(aSpacesWindow, nil, "Edit", WS_BORDER bitOr ES_AUTOHSCROLL bitOr WS_CHILD);
  if handle(aSpacesWindow) = 0
  then alert(System, self, #wCreateError)
  endif;
  ^init(aSpacesWindow);
}
!!

/* PUBLIC
 */
Def newEventEditWindow (self, id, par, eventMask | aSpacesWindow)
{ 
  aSpacesWindow := new(self, id, par);
  setEventCondition(aSpacesWindow,eventMask);
  ^aSpacesWindow;
}!!

now(SpacesWindow)!!

/* PUBLIC
   Return the trigger event condition mask.
 */
Def eventCondition(self)
{ 
  ^eventCondition
}
!!

/* PUBLIC */
Def getValue(self)
{ 
  if intValue
    ^intValue;
  else
    ^0;
  endif;
}
!!

/* PRIVATE

   init
   Initialize SpacesWindow by clearing intValue and changing the 
   font size used within the window.
 */
Def init(self)
{ 
  intValue := 0;
  eventCondition := 0;
  sendMessage(self,0x0030/*WM_SETFONT*/,getFont(parent),0L);
}
!!

/* PUBLIC
   Insert the incoming text string into the field name edit
   control window.
 */
Def setEventCondition(self, mask)
{ 
  eventCondition := mask;
}
!!

/* PUBLIC
   Insert the incoming integer into the spaces edit control window.]
   @@@ Used to be called setSpaces
 */
Def setValue(self, num)
{
  intValue := num;
  setText(self,asString(num));
}
!!

/* PUBLIC
   When this window loses focus than we need to check the text entered
   in our edit window. */
Def verifyInput(self | text)
{ 
  /* This routine verifies that the text is a valid number. */
  text := getText(self);
  if( (size(text) > 1) cand 
      (text[0] = '0' cand (text[1] = 'x' cor text[1] = 'X')) )
    intValue := asInt(subString(text,2,size(text)),16);
  else
   intValue := asInt(text,10);
  endif;
  if( not(intValue) )
    displayFormattedError(ErrorTextLibClass$Inst, 
       ER_NUM_BASE_MISMATCH, FORCE_POPUP, nil, nil, nil);
    intValue := 1;
    ^nil;
  endif;
  ^#true;
}
!!

Def WM_KEYDOWN(self, wp, lp)
{ if( wp = 13 cor between(wp, 0x70, 0x79) )
    updateSelf(parent);
  endif;
  ^WM_KEYDOWN(parent,wp,lp);
}!!

