/* Dialog to control the trace hardware control for:
a) pre, post and center trigger
b) number of trace buffers
c) break when trace store full
*/!!

inherit(Dialog, #TraceControlDialog, #(theTrigger /* instance to reference trigger info */
), 2, nil)!!

now(class(TraceControlDialog))!!

Def new(self | dlg ) {
  dlg := new(self:ancestor);
  ^dlg;
}
!!

now(TraceControlDialog)!!

Def command(self, wp, lp | tracing response){ 
  select
    case wp = 200
      toggle(self,wp);
    endCase
    case wp = DLG_TRACECON_PRE cor wp = DLG_TRACECON_CENTER cor wp = DLG_TRACECON_POST
      Call CheckDlgButton(getHWnd(self), DLG_TRACECON_PRE, 0);
      Call CheckDlgButton(getHWnd(self), DLG_TRACECON_CENTER, 0);
      Call CheckDlgButton(getHWnd(self), DLG_TRACECON_POST, 0);
      Call CheckDlgButton(getHWnd(self),  wp, 1);
    endCase
    case wp >= 401 cand wp <= 409
    is
      do(over(401,410),
      {using(id)
        Call CheckDlgButton(getHWnd(self), id, 0);
      });
      Call CheckDlgButton(getHWnd(self),  wp, 1);
    endCase
    case wp == IDCANCEL
      end(self, 0);
    endCase
    case wp = IDHELP
       is contextNumber(TheHelpObject, hWnd, HE_DLGD_TRACECON);
    endCase        
    case wp == IDOK
      tracing:=trcTracingGet(TraceLibClass$Inst);
      if( tracing <> 0 )
        response := errMessageBox(ErrorTextLibClass$Inst, 
                    "Tracing must be disabled!", 
                    "Do you want to turn off tracing?", 
                    MB_YESNO bitOr MB_ICONQUESTION, HE_DLGM_TRACECON_1);
        if( response = IDYES )
          trcTracingSet(TraceLibClass$Inst,0);
          tracing := 0;
        endif;
      endif;
      response := 0;
      if tracing = 0
        if( updateServer(self) = 0 )
          response := IDOK;
        endif;
      endif;
      end(self, response);
    endCase
  endSelect;
  ^0;
}!!

Def initDialog(self, wp, lp | valRef rc findVal id valStr displayRc val size)
{ displayRc := #true;
  registerF1Help(CLIULibraryClass$Inst, HI_DLGD_TRACECON,
     getHWnd(self), HE_DLGD_TRACECON);
  size := trcSubBufferSizeGet(TraceLibClass$Inst);
  if (size) then
    setItemText(self, DLG_TRACECON_SIZE + 1, "1 (x"+asString(size)+"K)");
    setItemText(self, DLG_TRACECON_SIZE + 2, "2 (x"+asString(size/2)+"K)");
    setItemText(self, DLG_TRACECON_SIZE + 3, "4 (x"+asString(size/4)+"K)");
    setItemText(self, DLG_TRACECON_SIZE + 4, "8 (x"+asString(size/8)+"K)");
    setItemText(self, DLG_TRACECON_SIZE + 5, "16 (x"+asString(size/16)+"K)");
    setItemText(self, DLG_TRACECON_SIZE + 6, "32 (x"+asString(size/32)+"K)");
    setItemText(self, DLG_TRACECON_SIZE + 7, "64 (x"+asString(size/64)+"K)");
    setItemText(self, DLG_TRACECON_SIZE + 8, "128 (x"+asString(size/128)+"K)");
    if( size = 128 )
      setItemText(self, DLG_TRACECON_SIZE + 9, "256 (x512)");
    else
      setItemText(self, DLG_TRACECON_SIZE + 9, "256 (x1K)");
    endif;
  endif;
  theTrigger := triggerOpen( require( TriggerLib ), "", "default" ) ;
  valRef := new( Struct, 4 ) ;
  rc := prim_trigFillActionGet(theTrigger, valRef);
  if rc <> 0
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    displayRc := #false;
    valStr:=getProfileEntry(TheProfileInfoObj,"TrigInfo","breakOnFull","");
    val := 0;
    if( valStr = "on" )
      val := 1;
    endif;
  else
    val := wordAt(valRef,0);
  endif ;  
  Call CheckDlgButton(getHWnd(self), 200, val);

  do(#(301 302 303 401 402 403 404 405 406 407 408 409),
  {using(id)
    Call CheckDlgButton(getHWnd(self),id,0);
  });
  if( rc = 0 ) 
    rc := prim_trigTraceModeGet(theTrigger,valRef);
  endif;
  if( rc <> 0 ) 
    if( displayRc = #true )
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
      displayRc := #false;
    endif;
    valStr:=getProfileEntry(TheProfileInfoObj,"TrigInfo","traceAlignment","");
    val := DLG_TRACECON_PRE;
    if( valStr = "post" )
      val := DLG_TRACECON_POST;
    endif;
    if( valStr = "center" )
      val := DLG_TRACECON_CENTER;
    endif;
  else
    val := wordAt(valRef,0);
    select
      case val = 1
      is val := DLG_TRACECON_POST;
      endCase
      case val = 2
      is val := DLG_TRACECON_CENTER;
      endCase
      default
      val := DLG_TRACECON_PRE;
    endSelect;
    
  endif;
  Call CheckDlgButton(getHWnd(self),val,1);

  if( rc = 0 ) 
    rc := prim_trigTraceConfigureGet(theTrigger,valRef);
  endif;
  if( rc <> 0 ) 
    if( displayRc = #true )
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
      displayRc := #false;
    endif;
    valStr :=
      getProfileEntry(TheProfileInfoObj,"TrigInfo","numTraceBuffers","");
    if( valStr cand (size(valStr) > 0) )
      val := asInt(valStr);
    endif;
  else
    val := wordAt(valRef,0);
  endif;
  findVal := 1;
  id := 401;
  loop
  while (findVal <> val) cand (findVal < 256)
  begin 
    findVal := findVal * 2;
    id := id + 1;
  endLoop;
  Call CheckDlgButton(getHWnd(self),id,1);
  ^1; /* set focus at first tabstop */
}
!!

Def updateServer(self | findVal id saveStr rc)
{ 
  findVal := 0;
  if ((Call IsDlgButtonChecked(getHWnd(self), 200)) > 0)
    findVal := 1;
  endif;
  if findVal = 0
    saveStr := "off";
  else
    saveStr := "on";
  endif;
  if( (rc:=trigFillActionSet(theTrigger,findVal)) <> 0 )
    ^rc;
  endif;
  saveProfileEntry(TheProfileInfoObj, "TrigInfo", "breakOnFull", saveStr);  
  id := DLG_TRACECON_PRE;
  loop
  while not((Call IsDlgButtonChecked(getHWnd(self), id)) > 0)
     cand (id <= DLG_TRACECON_POST)
  begin id := id+1;
  endLoop;

  /* the radio buttons are not in the same order as the enum */
  /* in the server/flash.  Therefore we need to remap the buttons */
  /* to match the enum.  */
  select
    case id = DLG_TRACECON_PRE
    is id := 0;
       saveStr := "pre";
    endCase
    case id = DLG_TRACECON_POST
    is id := 1;
       saveStr := "post";
    endCase
    case id = DLG_TRACECON_CENTER
    is id := 2;
       saveStr := "center";
    endCase  
  endSelect;
  
  if( (rc:=trigTraceModeSet(theTrigger,id)) <> 0 )
    ^rc;
  endif;

  saveProfileEntry(TheProfileInfoObj,"TrigInfo","traceAlignment",saveStr);  
 
  id := 401;
  findVal := 1;

  loop
  while not((Call IsDlgButtonChecked(getHWnd(self), id)) > 0)
        cand (id < 410)
  begin
    id := id+1;
    findVal := findVal * 2;
  endLoop;
  if( (rc:=trigTraceConfigureSet(theTrigger,findVal)) <> 0 )
    ^rc;
  endif;
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","numTraceBuffers",
                   asString(findVal));  
  ^0;  /* good exit */
}!!

