/* Dq interface */!!

inherit(TRviewInfo, #DQviewInfo, nil, 2, nil)!!

now(class(DQviewInfo))!!

now(DQviewInfo)!!

/* PRIVATE -- return  */
Def initFrameGroup(self, trace, dq, startFrame, numFrames, nextOrPrevious
    | bufStr realStartRef realEndRef textAddrRef textLenRef textColl retCode)
{
  showWaitCurs(); 
  /* set startFrame position in trace */
  retCode := prim_trcReadFrameSet( trace, startFrame);
  if (retCode <> 0) then ^retCode endif ;

  if( numFrames < 25 ) 
    numFrames := 25;    /* force min. amount requested to 25 instructions */
  endif;
  /* do the frame search */
  realStartRef  := new( Struct, 4 ) ;
  realEndRef    := new( Struct, 4 ) ;
  textAddrRef   := new( Struct, 4 ) ;
  textLenRef    := new( Struct, 2 ) ;
  if (nextOrPrevious = #Next)
  then
    retCode := dadForwardDqInst( dq, numFrames, realStartRef, realEndRef, 
                            textAddrRef, textLenRef ) ;
  else
    retCode := dadBackwardDqInst( dq, numFrames, realStartRef, realEndRef, 
                            textAddrRef, textLenRef ) ;
  endif ;
  
  if (retCode <> 0) 
    if (retCode <> ER_DQ_NO_FRAMES_AVAILABLE) then
      displayError(ErrorTextLibClass$Inst,retCode,FORCE_POPUP);
      showOldCurs();
    endif;
    ^retCode;
  endif;    
/* we didn't get any frames (i.e.: no text) */
  if( wordAt(textLenRef,0) = 0 )
    cFree( MallocLibClass$Inst, longAt(textAddrRef, 0) ) ;
    showOldCurs();
    ^retCode 
  endif; 

  /* get the text into a textCollection */
  add( textColl := new( TextCollection, 1), "" ) ;
  bufStr := physicalString(
               copyFromLong( new(Struct, wordAt(textLenRef,0)),
                             longAt(textAddrRef, 0) ) 
                           ) ;
  insertText( textColl, bufStr, 0, 0 ) ; 
  cFree( MallocLibClass$Inst, longAt(textAddrRef, 0) ) ;
  removeLast( textColl ) ; 
  showOldCurs();
  ^initialize( self, 
               longAt(realStartRef, 0), longAt(realEndRef, 0), textColl )
}
!!