/* Node for CLI If statement:
  CLI:  if (expression) { body }
  Actor:  if (expression) then body endif; */!!

inherit(Object, #CLIIfNode, #(expression /* if expression */
body  /* if body */), 2, nil)!!

now(class(CLIIfNode))!!

now(CLIIfNode)!!

/* Compile the node into Actor source. */
Def CLICodeCompile(self)
{
  CLICodeCompile("if (cTrue(self, ");
  expressionEchoOff(getExecutionEngine(CLIExecEngine));
  CLICodeCompile(expression);
  expressionEchoOn(getExecutionEngine(CLIExecEngine));
  CLICodeCompile(")) then ");
  CLICodeCompile(body);
  CLICodeCompile(" endif ");
}
!!

Def init(self, exp, bod)
{
  expression := exp;
  body := bod;
}!!
