/* Class: LoadFDialog
   Dialog to load loadfile
   Require: LOADOPTI.CLS
*/!!

inherit(FileDialog, #LoadFDialog, #(loadOptions /* #(loadOptions, Ondemand) */), 2, nil)!!

now(class(LoadFDialog))!!

/* Create and a new file loader dialog object. The dialog's fileSpec
  instance variable is specified by the file argument. For example,
  new(LoadFDialog, "\*.*", #(8, 0)) would create a
  load dialog object that would list all the files and subdirectories 
  in the root directory, setting pathSpec to "C:\" in the process. */
Def new(self, file, currentOptions | theDlg)
{ 
  theDlg := new(self:Behavior);
  setFileSpec(theDlg, (size(file) > 0 cand file) cor "*.*");
  setLoadOptions(theDlg, currentOptions);
  ^theDlg;
}!!

now(LoadFDialog)!!

/* 5/17/1993 15:36 - PUBLIC
  return the Load Option settings.
*/
Def loadOptions(self)
{ 
  ^loadOptions
}
!!

/* 5/17/1993 15:34 - PRIVATE
  Set the current load options
*/
Def setLoadOptions(self, currentOptions)
{ 
  loadOptions := currentOptions;
}
!!

/* Handle file dialog events (OK, Cancel, etc.). Selecting Open
  will always do something, if only to reload the lists according
  to the current filter. */
Def command(self, wP, lP | action, tmpDialog)
{ 
  action := high(lP);
  select
    case wP == IDCANCEL
    is resetDir(self);
      end(self, 0);
    endCase
    case wP == IDHELP 
      is contextNumber(TheHelpObject, hWnd, HE_DLGR_LOAD_FILE);
    endCase
    case wP == FILE_LB and action = LBN_SELCHANGE
    is sendDlgItemMessage(self, FILE_DIRLB, LB_SETCURSEL, -1, 0);
    endCase
    case wP == FILE_DIRLB and action = LBN_SELCHANGE
    is sendDlgItemMessage(self, FILE_LB, CB_SETCURSEL, -1, 0);
      setItemText(self, FILE_LB, getLoadDir(self) + fileSpec);
    endCase
    case (wP == FILE_DIRLB and action = LBN_DBLCLK)
      cor (wP == IDOK and getLBSel(self, FILE_DIRLB))
    is newDir(self);
    endCase
    case wP == FILE_LB and action = LBN_DBLCLK
    is
      if getLoadFile(self)
      then resetDir(self);
        end(self, IDOK);
      endif;
    endCase
    case wP == IDOK
    is open(self)
    endCase
    case wP == BTN_OPTION
    is  tmpDialog := new(LoadOptionDialog, loadOptions[0], loadOptions[1]); 
      /* Lets run the Options dialog box - DLG_LOAD_OPTIONS is the resource ID */
      if runModal(tmpDialog, DLG_LOAD_OPTIONS, self) = IDOK then
         loadOptions := loadOptions(tmpDialog);
         /* Save the new option to ProjectInfo */
         if (TheProjectInfoObj cand loadOptions) then
           setLoadFlags(TheProjectInfoObj, loadOptions[0]);
           setOnDemand(TheProjectInfoObj, loadOptions[1]);
         endif;
      endif; 
    endCase
  endSelect;
  ^1;
}!!

/* set the help entry to use */
Def setHelpEntry(self, hEntry)
{
  setHelpEntry(self:ancestor, hEntry);
}!!
