/* Register Value (32 bits) */!!

inherit(Object, #Register, #(name
regID
location   /* pixel pt for value display) */
labelLoc  /* pixel point for label */
prevVal
currVal
hilighted?
sortIndex /* for ordered dictionary */
displayType  /* Display as flags or numeric */
digits
), 2, nil)!!

now(class(Register))!!

/* PUBLIC */
Def new(self, name, regID, sortIndex, type, aDigits | instance)
{
   instance := new( self:ancestor ) ;

   ^initialize( instance, name, regID, sortIndex, type, aDigits )
}
!!

/* PUBLIC */
Def newWithLocation(self, name, regID, sortIndex, type, aDigits, labelLocPt, valueLocPt 
                   | instance)
{
 instance := new( self:ancestor ) ;

 ^initWithLocation(instance, name, regID, sortIndex, type, aDigits, labelLocPt, valueLocPt)
}
!!

now(Register)!!

/* PUBLIC */
Def digits(self)
{ ^digits }
!!

/* PUBLIC */
Def currVal(self)
{ ^currVal }
!!

/* PUBLIC 
   Print text on window, given drawing context.
   Nota Bene: point xPos & yPos in pixels.
*/
Def display(self, hDC
    | origTextColor, origBkColor, origBkMode, txt, blanks)
{
  txt := textValue( self ) ;
  if hilighted?
  then
    origTextColor := Call GetTextColor( hDC ) ;
    origBkColor   := Call GetBkColor(   hDC ) ;
  
    /* hilight: color background region by drawing "colored blanks" */
    origBkMode := Call SetBkMode( hDC, OPAQUE ) ;
    /* make string of blanks to print */
    blanks := fillWith( " ", size(txt) ) ;
    Call SetBkColor( hDC, Call GetSysColor(COLOR_HIGHLIGHT));
    Call TextOut( hDC, 
                  x(location), 
                  y(location), 
                  blanks, 
                  size(txt)
                 ) ;

    /* now paint the text */
    Call SetBkMode( hDC, TRANSPARENT ) ;
    Call SetTextColor( hDC, Call GetSysColor(COLOR_HIGHLIGHTTEXT));
    Call TextOut( hDC, 
                  x(location), 
                  y(location), 
                  txt, 
                  size(txt)
                ) ;
 
    Call SetTextColor( hDC, origTextColor ) ;
    Call SetBkColor(   hDC, origBkColor   ) ;
    Call SetBkMode(    hDC, origBkMode    ) ;

  else /* not hilighted */
    Call TextOut( hDC, 
                  x(location), 
                  y(location), 
                  txt, 
                  size(txt)
                 ) ;
  endif ;

}
!!

/* PUBLIC */
Def displayLabel(self, hDC | label)
{
  if (labelLoc cand (displayType = 0))
  then
    label := name( self ) ;
    Call TextOut( hDC, 
                  x(labelLoc), 
                  y(labelLoc), 
                  label, 
                  size(label)
                 ) ;
  endif ;
}
!!

/* PUBLIC */
Def drawLabel(self, hDC, x, y | label) /* x,y in pixels */
{
  label := name( self ) ;
  if label
  then
    Call TextOut( hDC, 
                  x, 
                  y, 
                  label, 
                  size(label)
                 ) ;
  endif ;
}

!!

/* PUBLIC */
Def hilighted?(self)
{ ^hilighted? }
!!

/* PUBLIC */
Def id(self)
{ ^regID }
!!

/* PRIVATE */
Def initialize(self, aName, aRegID, index, type, aDigits)
{
  name      := aName ;
  regID     := aRegID ;
  sortIndex := index ;
  displayType := type ;
  digits    := aDigits ;
  prevVal   := currVal  := 0L ;
  regID     := findRegisterID( CpuLibClass$Inst, aName ) ;
/* hilighted? := nil ; */
}
!!

/* PRIVATE */
Def initWithLocation(self, aName, aRegID, index, type, aDigits, labelPt, valuePt)
{
  initialize( self, aName, aRegID, index, type, aDigits ) ;
  location := valuePt ;
  labelLoc := labelPt ;
}
!!

/* PUBLIC */
Def labelLoc(self)
{ ^labelLoc }
!!

/* PUBLIC */
Def name(self)
{ ^name }
!!
/* PUBLIC */
Def prevVal(self)
{ ^prevVal }
!!

/* PUBLIC */
Def setLabelLoc(self, newLocationPt)
{ ^(labelLoc := newLocationPt) }
!!

/* PUBLIC */
Def setValue(self, newValue)
{
  prevVal := currVal ;
  currVal := newValue ; 
  hilighted? := not( prevVal = currVal ) ;
}
!!

/* PUBLIC */
Def setValueLoc(self, aPoint)
{
  ^location := aPoint ; /* point in pixel coordinates */
}
!!

/* PUBLIC */
Def sortIndex(self)
{ ^sortIndex }
!!

/* PUBLIC */
Def textValue(self)
{
  if currVal
  then
    ^getRegisterValueText(CpuLibClass$Inst, regID, displayType);
  else
    ^"????????"
  endif;
}
!!

/* PUBLIC -- go to server & setValue(self,newVal) */
Def updateValue(self)
{
  setValue( self, getRegValue(CpuLibClass$Inst, regID) ) ;
}
!!

/* PUBLIC */
Def valueLoc(self)
{ ^location }
!!
