/* Dialog box used by trace get buffer and trace get frame.  This contains
   a static field and title that is given when created; a static field that is
   filled in with the range of possible values; and an edit field with a scroll
   bar.
 */!!

inherit(Dialog, #TraceNumberDialog, #(getStartRoutine
dlgTitle /* saved from new call */
ebTitle /* title of edit box control */
dlgHelpEntry /* saved from setHelpEntry */
getEndRoutine /* Use these routines to get the start and end value of range */
selected /* value in edit field */
), 2, nil)!!

now(class(TraceNumberDialog))!!

Def new(self, dialogTitle, editBoxTitle, startFunc, endFunc | dlg) {
  dlg := new(self:ancestor);
  setStartFunc(dlg, startFunc);
  setEndFunc(dlg, endFunc);
  setDialogTitle(dlg, dialogTitle);
  setEBTitle(dlg, editBoxTitle);
  setHelpEntry(dlg, HE_DLGD_TRACENUM);
  ^dlg;
}
!!

now(TraceNumberDialog)!!

Def setEBTitle(self, title) {
  ebTitle := title;
}
!!

Def setDialogTitle(self, title) {
  dlgTitle := title;
}
!!

Def setHelpEntry(self, hlp) {
  dlgHelpEntry := hlp;
}
!!

Def command(self, wp, lp | val start end tmp)
{ select
    case wp == IDCANCEL and high(lp) = 0
    is end(self, 0);
    endCase
    case wp = IDHELP
       is contextNumber(TheHelpObject, hWnd, dlgHelpEntry);
    endCase        
    case wp == IDOK and high(lp)= 0
    is 
       tmp:=getItemText(self, DLG_TRACENUM_VAL);
       if( size(tmp) = 0 )  /* user clear'd out the goto field */
         end(self,0);
       else
         val := asInt(tmp:=getItemText(self, DLG_TRACENUM_VAL),10);
         end := perform(trace(parent),getEndRoutine);
         start := perform(trace(parent),getStartRoutine);
         if( not(val) cor (val < start))   /* error - default back to start */
           beep();
           setItemText(self,DLG_TRACENUM_VAL,asString(start));
         else
           if( not(val) cor (val > end) )   /* error - default to end */
             beep();
             setItemText(self,DLG_TRACENUM_VAL,asString(end));
           else
             end(self, IDOK);
           endif;
         endif;
       endif;
    endCase
  endSelect;
  ^0;
}!!

/* Set the selected value before the dialog is destroyed. */
Def end(self, val | rc){
 rc := end(self:ancestor, val);
 selected := getItemText(self, DLG_TRACENUM_VAL);
 ^rc;
}!!

/* 6/17/1992 14:03 */
Def getSelected(self){
  if( not(selected) )
    ^asString(perform(trace(parent),getStartRoutine));
  endif;
  ^selected;
}
!!

Def initDialog(self, wp, lp | start end) {
  registerF1Help(CLIULibraryClass$Inst, HI_DLGD_TRACENUM,
     getHWnd(self), dlgHelpEntry);
  start := perform(trace(parent),getStartRoutine);
  end := perform(trace(parent),getEndRoutine);
  setText(self, dlgTitle);
  setItemText(self, DLG_TRACENUM_TITLE, ebTitle + ":");
  setItemText(self, DLG_TRACENUM_TEXT, "("+asString(start)+" to "+asString(end)+")");
  setItemText(self,DLG_TRACENUM_VAL,getSelected(self));
}!!

/* 6/17/1992 14:03 */
Def setEndFunc(self, func){
  getEndRoutine := func;
}
!!

/* 6/17/1992 14:03 */
Def setStartFunc(self, func){
  getStartRoutine := func;
}
!!
Def WM_VSCROLL(self, wp, lp | val changed?) {  
  val := asInt(getItemText(self, DLG_TRACENUM_VAL),10);
  if( not(val) )
    val := 0;
  endif;
  select
    case (wp == SB_LINEDOWN)
      if( val < perform(trace(parent),getEndRoutine) )
        val := val + 1;
        changed? := #true;
      endif;    
    endCase

    case (wp == SB_LINEUP)
      if( val > perform(trace(parent),getStartRoutine) )
        val := val - 1;
        changed? := #true;
      endif;    
    endCase
  endSelect;
  if( changed? )
    setItemText(self,DLG_TRACENUM_VAL,asString(val));
  endif;
  ^0 
}!!
