/* Register Bit 
   0=off => lower-case name; 1=on => upper-case name
*/!!

inherit(Object, #RegBit, #(name
maskVal
location /* pixel point offset from base pt) */
prevVal
currVal
hilighted?
sortIndex /* for ordered dictionary */
parentReg), 2, nil)!!

now(class(RegBit))!!

/* PUBLIC */
Def new(self, name, mask, parent, sortIndex | instance)
{
   instance := new( self:ancestor ) ;

   ^initialize( instance, name, mask, parent, sortIndex )
}
!!

/* PUBLIC */
Def newWithLocation(self, name, mask, parent, sortIndex, location | instance)
{
   instance := new( self:ancestor ) ;

   ^initWithLocation( instance, name, mask, parent, sortIndex, location )
}
!!

now(RegBit)!!

/* PUBLIC */
Def currVal(self)
{
  ^currVal
}
!!

/* PUBLIC 
   Print text on window, given drawing context.
   Nota Bene: point xPos & yPos in pixels.
*/
Def display(self, hDC
    | origTextColor, origBkColor, origBkMode, txt, blanks)
{
  txt := name( self ) ;
  if hilighted?
  then
    origTextColor := Call GetTextColor( hDC ) ;
    origBkColor   := Call GetBkColor(   hDC ) ;
  
    /* hilight: color background region by drawing "colored blanks" */
    origBkMode := Call SetBkMode( hDC, OPAQUE ) ;
    /* make string of blanks to print */
    blanks := fillWith( " ", size(txt) ) ;
    Call SetBkColor( hDC, $fieldColorDict(ATParser)[AT_PC_HERE_FIELD] ) ;
    Call TextOut( hDC, 
                  (x(location) + x(valueLoc(parentReg))), 
                  (y(location) + y(valueLoc(parentReg))), 
                  blanks, 
                  size(txt)
                 ) ;

    /* now paint the text */
    Call SetBkMode( hDC, TRANSPARENT ) ;
    Call SetTextColor( hDC, $fieldColorDict(ATParser)[#plainText] ) ;
    Call TextOut( hDC, 
                  (x(location) + x(valueLoc(parentReg))), 
                  (y(location) + y(valueLoc(parentReg))), 
                  txt, 
                  size(txt)
                ) ;
 
    Call SetTextColor( hDC, origTextColor ) ;
    Call SetBkColor(   hDC, origBkColor   ) ;
    Call SetBkMode(    hDC, origBkMode    ) ;
  else
    Call TextOut( hDC, 
                  (x(location) + x(valueLoc(parentReg))), 
                  (y(location) + y(valueLoc(parentReg))), 
                  txt, 
                  size(txt)
                 ) ;
  endif ;

}
!!

/* PRIVATE */
Def initialize(self, aName, aMask, parent, index)
{
  name    := aName ;
  maskVal := aMask ;
  parentReg := parent ;
  sortIndex := index ;
/*  prevVal := currVal := hilighted? := nil ; */
}
!!
/* PRIVATE */
Def initWithLocation(self, aName, aMask, parent, index, locationPt)
{
  location := locationPt ;

  ^initialize( self, aName, aMask, parent, index ) ;
}
!!

/* PUBLIC */
Def location(self)
{
  ^location
}
!!

/* PUBLIC */
Def maskVal(self)
{
  ^maskVal
}
!!

/* PUBLIC -- return as text for display */
Def name(self)
{
  if currVal
  then ^asUpperCase( name ) /* true => 1 */
  else ^asLowerCase( name ) /* nil  => 0 */
  endif ;
}
!!

/* PUBLIC */
Def prevVal(self)
{
  ^prevVal
}
!!

/* PUBLIC */
Def setLocation(self, aPoint)
{
  ^location := aPoint ; /* point in pixel coordinates */
}
!!

/* PUBLIC */
Def setValue(self, newValue)
{
  prevVal := currVal ;
  /* find own bit in register value; convert to boolean */
  if newValue
  then
    currVal := ((newValue bitAnd maskVal) <> 0) ;
  else
    currVal := nil ;
  endif ;
  hilighted? := not( prevVal = currVal ) ;
}
!!

/* PUBLIC */
Def sortIndex(self)
{
  ^sortIndex
}
!!
