/* CLASS: StkAreaDialog
   Provide StackArea dialog box for the stack presenter
 */!!

inherit(Dialog, #StkAreaDialog, #(stackBase
stackSize), 2, nil)!!

now(class(StkAreaDialog))!!

/* 7/14/1993 12:58 - PUBLIC
 Create an instance of the dialog box. Initialize and setup 
 for runModal() call.
*/
Def new(self, oldBase, oldSize | theDlg)
{ 
  theDlg := new(self:Behavior);
  setValues(theDlg, oldBase, oldSize);
  ^theDlg;
}
!!

now(StkAreaDialog)!!

/* 7/14/1993 13:35 - PRIVATE
  Get the instant variables stack base and size
*/
Def getValues(self)
{ 
  if stackBase cand stackSize
    ^tuple(stackBase, stackSize);
  endif;  
  ^nil;
}
!!

/* 7/14/1993 13:35 - PRIVATE
  Set the instant variables for dialog
*/
Def setValues(self, oldBase, oldSize)
{ 
  stackBase := oldBase;
  stackSize := oldSize;
}
!!

/* 7/14/1993 13:57 - PRIVATE
  validate the input is a valid value.
*/
Def validateInput(self, inStr, errCode | value )
{ 
  if (inStr  = "")
     displayFormattedError(ErrorTextLibClass$Inst, 
        errCode, FORCE_POPUP, nil, nil, nil);
        ^nil;
  endif;
  if not(value := getSymbolicOffset(AddressLibClass$Inst, inStr))
    ^nil;
  endif;
  ^value;
}
!!

/* 7/14/1993 13:44 - PRIVATE
  Commands processing
*/
Def command(self, wp, lp | s1, tmpVal)
{
  select
    case wp == IDCANCEL and high(lp) = 0 is
      end(self, IDCANCEL);
    endCase
    case wp == IDHELP 
      is contextNumber(TheHelpObject, hWnd, HE_DLGR_STACK_AREA);
    endCase
    case wp == IDOK and high(lp)= 0 is
      /* Valiadate stack base and size input */
      s1 := peelBlanks(getItemText(self, DLG_STACK_BASE_ADDR));
      if not(stackBase := validateInput(self, s1, ER_STACK_SIZE_MISSING)) 
        setItemFocus(self, DLG_STACK_BASE_ADDR);
        ^GOOD; 
      endif;  
      /* validate stack size */
      s1 := getItemText(self, DLG_STACK_SIZE);
      if not(validateInput(self, s1, ER_STACK_INVALID_SIZE)) cor
        (not(tmpVal := string2int(s1)) cand
         not(tmpVal := getSymbolicOffset(AddressLibClass$Inst, s1)))
        setItemFocus(self, DLG_STACK_SIZE);
        ^GOOD; 
      endif;   
      stackSize := tmpVal;
      /* Everything is GOOD, lets exit */     
      end(self, IDOK);
    endCase
  endSelect;
  ^GOOD;
}!!

/* 7/14/1993 11:58 - PRIVATE
  Set old values into edit boxes.
*/
Def initDialog(self, wp, lp)
{
  /* place initial value */
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_STACK_AREA,
     getHWnd(self), HE_DLGR_STACK_AREA);
  if stackBase then    
    setItemText(self, DLG_STACK_BASE_ADDR, stackBase);
  endif;
  if stackSize then  
    setItemText(self, DLG_STACK_SIZE, stackSize);
  endif;
  
  /* set item focus */  
  ^1;  /* informs Windows to set focus to tab stop 1 */
}
!!
