/****************************************************************************
**
**  Name:  dlgobj.h
**
**  Description:
**     Declaration of the classes that provide interface to Windows
**     COMMDLG.DLL - Common dialog boxes.
**
**  $Log:   S:/tbird/arcm332/cliulib/dlgobj.h_v  $
** 
**    Rev 1.0   14 Jul 1994 10:31:34   nghia
** Initial revision.
**
**  $Header:   S:/tbird/arcm332/cliulib/dlgobj.h_v   1.0   14 Jul 1994 10:31:34   nghia  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _DLGOBJ_
#define _DLGOBJ_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <commdlg.h>  // Windows COMMDLG.H

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _WCOMMDLG_
#include "wcommdlg.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
//----------------------------------------------------------------------------
// Classes declaration
class FileDlgItem;
class _export CommFileDlg;

// classes pointer types
typedef class FileDlgItem *FileDlgItemPtr;
typedef class CommFileDlg *CommFileDlgPtr;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
//-----------------------------------------------------------------------------
//
// Class: FileDlgItem
//
// Description:
//    This classe is used by the CommFileDlg to build a list of FILEOPEN/
//    FILESAVE dialog that are running.  Each object holds the parent 
//    HWND as the key and the CommFileDlg object itself.  
//
//       +----------------+
//       |  CommFileDlg:: |
//       |   ListOfDlgs---|-->+------+---+---+
//       +----------------+   | hwnd | + | --|-->[CommFileDlg object]
//                            +------+-|-+---+
//                                     |
//                            +------+-v-+---+
//                            | hwnd | + | --|-->[CommFileDlg object]
//                            +------+-|-+---+
//                                     :
//
//    Each time a CommFileDlg object is created or destroyed (whether the
//    object is a stack or heap based object), it automatically registers
//    and removes itself accordingly.
//    
//-----------------------------------------------------------------------------
class FileDlgItem {
public:

                    //--------------------------//
                    // CONSTRUCTOR & DESTRUCTOR //
                    //--------------------------//
    FileDlgItem(HWND owner, CommFileDlgPtr dlgItem);
    ~FileDlgItem();
                    //--------------------------//
                    //   INITIALIZED METHODS    //
                    //--------------------------//

                    //--------------------------//
                    //    ACCESSING METHODS     //
                    //--------------------------//
    CommFileDlgPtr DlgObject() { return dlgObject; }
    
                    //--------------------------//
                    //    OPERATOR METHODS      //
                    //--------------------------//

                    //--------------------------//
                    //    OPERATION METHODS     //
                    //--------------------------//

                    //--------------------------//
                    //       CLASS METHODS      //
                    //--------------------------//
public:    
    // class methods to add and remove CommFileDlg object from
    // the <ListOfDlgs>
    static RETCODE AddItem(CommFileDlgPtr  dlgItem);
    static RETCODE RemoveItem(CommFileDlgPtr dlgItem);

private:
                    //--------------------------//
                    //       DATA MEMBERS       //
                    //--------------------------//
   //------------------------------------------------------------------------
   // Class Members
   static U16            NumObjects;  // number of items in <ListOfDlgs>
   static FileDlgItemPtr ListOfDlgs;  // pointer to list of FileDlgItem.

   // members to hold the registration information
   HWND           dlgOwner;    // Window owner of the <dlgObject>
   CommFileDlgPtr dlgObject;   // the object registered
   FileDlgItemPtr nextItem;    // next items
   
//---------------------------------------------------------------------------
// FRIEND 
friend class CommFileDlg;
};
//// End of FileDlgItem

                    
//-----------------------------------------------------------------------------
//
// Class: CommFileDlg
//
// Description:
//    Declaration of the CommFileDlg class.  This class provides interfaces
//    to access Windows's COMMDLG.DLL.  To support multiple instance objects
//    with the HookProc function, the CommFileDlg uses the FileDlgItem class
//    to handle object registration at the object's birth and death time.
//    Only the external interface CommDlgGetFileName() have access to objects
//    of this class.   
//
//-----------------------------------------------------------------------------
class CommFileDlg {
public:

                    //--------------------------//
                    // CONSTRUCTOR & DESTRUCTOR //
                    //--------------------------//
   CommFileDlg(HWND parent, U16 helpId, U16 filterId,
               LPSTR initDir = NULL, BOOLEAN usedForOpen = TRUE);
   ~CommFileDlg();
   
                    //--------------------------//
                    //   INITIALIZED METHODS    //
                    //--------------------------//
   RETCODE Init(HWND parent, LPSTR initDir, U16 filterId); 
                    //--------------------------//
                    //    ACCESSING METHODS     //
                    //--------------------------//

                    //--------------------------//
                    //    OPERATOR METHODS      //
                    //--------------------------//

                    //--------------------------//
                    //    OPERATION METHODS     //
                    //--------------------------//
   // return the result file name - lpFileName is allocated by caller
   RETCODE GetFileName(LPSTR lpFileName);
                    //--------------------------//
                    //       CLASS METHODS      //
                    //--------------------------//
   static RETCODE GetHelpId(HWND hDlg, WORD FAR *hlpId);
   static CommFileDlgPtr GetObject(HWND hDlg);
   
private:
                    //--------------------------//
                    //       LOCAL METHODS      //
                    //--------------------------//
   RETCODE ErrorHandler(VOID);

public:
                    //--------------------------//
                    //       DATA MEMBERS       //
                    //--------------------------//
   RETCODE      status;        // status of self
   U16          helpCntxtId;   // help context Id - see /inc/hlpentry.h
   BOOLEAN      openDlg;       // 1 = FILEOPEN, 0 = FILESAVE
   OPENFILENAME ofn;
   
private:
   // private data members
   U32   defaultFlags;  
   LPSTR lpDirName;     // pointer to MAX_STRING_SIZE buffer.
   LPSTR lpFile;
   LPSTR lpFileTitle;
   LPSTR lpFilter;

//---------------------------------------------------------------------------
// FRIEND
friend class FileDlgItem;
friend UINT CALLBACK CommDlgFileHookProc(HWND, UINT, WPARAM, LPARAM);
friend RETCODE EXPORT CommDlgGetFileName(HWND, U16, U16,
                                         LPSTR, BOOLEAN, LPSTR);
};
//// End of <CommFileDlg>
   

#endif /* _DLGOBJ_ */
/******************************** E O F **************************************/
