/****************************************************************************
**
**  Name:  anotext.h 
**
**  Description:
**     This file contains the definitions required for using annotated
**     text buffers.  This method is utilized by the Variable Server
**     and any presenters wishing to display the annotated text.
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/arccore/inc/anotext.h_v  $
** 
**    Rev 1.3   31 Jan 1992 14:51:14   marilyn
** Added markers for function name and module name.
** 
**    Rev 1.2   13 Jan 1992 11:44:02   marilyn
** Added AT_WARNING_FIELD and AT_INFO_FIELD.
** 
**    Rev 1.1   10 Oct 1991 17:02:32   marilyn
** Added some mask defines.
** 
**    Rev 1.0   10 Oct 1991 12:27:38   marilyn
** Initial revision.
**
**  $Header:   S:/tbird/arccore/inc/anotext.h_v   1.3   31 Jan 1992 14:51:14   marilyn  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
** Text is annotated by special byte-encodings:
**
**  ____________
**  |1|XX|YYYYY| <-- bit layout of special byte
**  ------------
**   1, 2,   5   <-- bit width
**
** High Bit: 
**   0 => ASCII
**   1 => Special
**
** 2 Tag Bits:
**   0 => reserved
**   1 => other 5 bits are # of indents (tabs)
**   2 => Begin a typed region (5 bits of type/class)
**   3 => End a typed region   (5 bits of type/class)
**
** 5 Other Bits: if tag is 2 or 3
**   0 => reserved
**   1 => type name
**   2 => variable name
**   3 => editable value
**   4 => expandable reference
**   5 => breakpoint set -- active
**   6 => breakpoint set -- inactive
**   7 => breakpoint hit
**   8 => cursor (link active)
**   9 => cursor (link inactive)
**  10 => current execution point (PC is here)
**  11 => warning message
**  12 => informational message
**  13 => function name
**  14 => module name
**  15..31 => reserved
**
**  NOTES:
**     Begin..End regions may be nested, but may *not* overlap
**     (this allows "recursive descent" type parsing).
*****************************************************************************/

#define _ANOTEXT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


#define AT_SPECIAL_MARK 0x80
#define AT_SPECIAL_MASK 0x80

#define AT_TAG_MASK    0x60
#define AT_INDENT_TAG  0x20
#define AT_BEGIN_TAG   0x40
#define AT_END_TAG     0x60

#define AT_FIELD_MASK         0x1F
#define AT_TYPE_NAME_FIELD    0x01
#define AT_VAR_NAME_FIELD     0x02
#define AT_EDIT_FIELD         0x03
#define AT_REFERENCE_FIELD    0x04
#define AT_BREAK_ACT_FIELD    0x05
#define AT_BREAK_INACT_FIELD  0x06
#define AT_BREAK_HIT_FIELD    0x07
#define AT_CURSOR_ACT_FIELD   0x08
#define AT_CURSOR_INACT_FIELD 0x09
#define AT_PC_HERE_FIELD      0x0A
#define AT_WARNING_FIELD      0x0B
#define AT_INFO_FIELD         0x0C
#define AT_FUNC_NAME_FIELD    0x0D
#define AT_MOD_NAME_FIELD     0x0E


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************** E O F ***********************************/
