/*
 * Name:     ca.h
 * Title:    Coverage Analysis Server
 * Purpose:  Routines to set up and obtain results from coverage hardware
 *
 * $Log:   S:/tbird/arccore/inc/ca.h_v  $
**  
**     Rev 1.1   21 Aug 1991 11:21:44   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:34:34   jim
 * Initial revision.
 *
 * $Header:   S:/tbird/arccore/inc/ca.h_v   1.1   21 Aug 1991 11:21:44   tom  $
 */
#define _CA_

#ifndef _BASEWIND_
#include "basewind.h"
#endif

RETCODE EXPORT setCoverageGranularity(U32 Granularity);
/*
Parameters:
   Granularity (input):   size of minimum coverage granularity block:
                          0=1 byte, 1=2 bytes, 2=4 bytes, ... 9=512 bytes.
Default:
   Granularity:   0 (1 byte)
Description:
   Set Granularity for measurements.  Any execution within the block of
   addresses represented by a particular coverage bit results in that bit
   being set TRUE (covered).
*/

RETCODE EXPORT getCoverageGranularity(U32 *Granularity);
/*
See setCoverageGranularity for desription
*/

RETCODE EXPORT setCoverageBase(ADDRESS BaseAddress);
/*
Parameters:
   BaseAddress (input):   Location of beginning of coverage range.
                          n lower bits are ignored (n=Granularity+23).
Default:
   BaseAddress:   0
Description:
   Set Base address for measurements.
*/

RETCODE EXPORT getCoverageBase(ADDRESS *BaseAddress);
/*
See setCoverageBase for description
*/


RETCODE EXPORT getNextCoverageChangeAddr(
   ADDRESS CoverageAddr, ADDRESS *CoverageChangeAddr, BOOLEAN *Covered);
/*
Parameters:
   CoverageAddr (input):  Location of beginning of search for next change
   CoverageChangeAddr (output):  Location of next value change
   Covered (output):      State of coverage at CoverageChangeAddr.
Default:
   none
Description:
   Coverage results are stored as an 8 megabit array.  Each bit in the
   array is associated with an area of memory space ranging from 1 byte to
   512 bytes.  This function starts searching at the bit corresponding to
   CoverageAddr looking for the first change of coverage ram contents.  The
   address corresponding to that bit is returned, along with the content of
   the coverage RAM at that location.  FALSE indicates not covered; TRUE
   indicates covered.

   By starting the search at 0 (or the base of the coverage measurement
   region), the caller can deduce the state of the RAM at 0 by negating the
   value returned from the first call.
*/
RETCODE EXPORT resetCoverage(VOID);
/*
Parameters:
   none
Default:
   none
Description:
   Set entire coverage RAM to FALSE (not covered).  Should be called before
   starting a coverage measurement.
*/
