/****************************************************************************
**
**  Name:  enlib.h
**
**  Description:
**      This file contains the external interface for the Event Notification
**      Library routines.  This is the standard interface for registering for
**      event notification and for propagating events.
**
**  Design Notes:  Individual servers will access the library routines
**  outlined below to register events for notification and to
**  propagate events. 
**
**  IMPORTANT:  An event perpetrator must make sure that their state is
**  clean before propagating events because the perpetrator will not
**  get control back until all servers registered on the event have been
**  called.  Other servers may call the perpetrator's module for additional
**  information and this is why the state must by "clean".  (Windows receive
**  PostMessages, so they will be updated after the perpetrator is done.)
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/arccore/inc/enlib.h_v  $
** 
**    Rev 1.7   07 Feb 1992 11:11:24   doug
** cleaned up comments and removed events (and added comment of where to find
** events)
** 
**    Rev 1.6   22 Jan 1992 13:51:34   marilyn
** Removed confusing events.
** 
**    Rev 1.5   10 Jan 1992 18:33:10   brucea
** Added #ifdef __cplusplus
** 
**    Rev 1.4   20 Nov 1991 14:14:48   marilyn
** Changed MODULE_SYMBOL_SERVER to MODULE_SYMBOLS to match hosterrs.h.
** 
**    Rev 1.3   11 Nov 1991 13:07:26   doug
** added explanation of how messages and callbacks are invoked
** 
**    Rev 1.2   08 Nov 1991 13:23:14   doug
** a) added EVENT_MSG which is the number of the message windows will receive
**    when a message is sent (see wintest.c for example)
** b) renamed descriptor parameter to more generic name
** 
**    Rev 1.1   06 Nov 1991 11:18:52   doug
** Changes to conform to standard format of prototypes.
** 
**    Rev 1.0   30 Oct 1991 15:23:50   marilyn
** Initial revision.
**
**  $Header:   S:/tbird/arccore/inc/enlib.h_v   1.7   07 Feb 1992 11:11:24   doug  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _ENLIB_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

#define EVENT_MSG 0x480  /* Window message number for notification */

typedef VOID EXPORT (*EVCALLBACK)(U32 eventNumber);

                    /*********************************
                     *                               *
                     *   EVENT NOTIFICATION DEFINES  *
                     *                               *
                     *********************************/
/*
**
** All event notification definitions reside in the server header files
** where the event originates.  Check each header file for events.  They
** begin with the text "EVENT_".
**
*/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  EnlRegisterWin
**
**  Description:
**      This routine registers a window for event notification.  When an
**      event occurs (someone calls EnlEventNotify) that matches the event
**      number being registered, a message is passed to the window handle
**      given.  The message needs to be fielded in the main window processing
**      routine (use #define EVENT_MSG for message number; see
**      enlib/wintest.c test example).  The event number is passed as a 32-bit
**      number in the long parameter (lParam).  If a window can receive more
**      than one event, the single EVENT_MSG entry point needs to fan out to
**      the various events (using lParam in a switch or if/else statement).
**
**  Parameters:
**     input:
**        event : a predefined unique system event number
**        winHandle : handle of the window for returning the notification
**
**     output:
**        desc : an id identifying the event registered
**
*****************************************************************************/
RETCODE EXPORT EnlRegisterWin(U32 event, HWND winHandle,DESCRIPTOR FAR *desc);

/****************************************************************************
**
**  EnlRegister
**
**  Description:
**      This routine registers a server for event notification.  When an
**      event occurs (someone calls EnlEventNotify) that matches the event
**      number being registered, the callback function specified is called
**      with the event number (U32) as the parameter (see enlib/wintest.c
**      DLL test example).  A separate routine for each event can be used or
**      a single event handler can use the event number parameter to handle
**      multiple events.
**
**  Parameters:
**     input:
**        event : a predefined unique system event number
**        callback : the address of the function for return notification
**
**     output:
**        desc : an id identifying the event registered
**
*****************************************************************************/
RETCODE EXPORT EnlRegister(U32 event, EVCALLBACK callback,
                           DESCRIPTOR FAR *desc);

/****************************************************************************
**
**  EnlEventNotify
**
**  Description:
**      This routine searches the event notification table
**      and notifies all registrants of the event.
**
**  Parameters:
**     input:
**        event : the event to search for and notify registrants of 
**
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT EnlEventNotify(U32 event);

/****************************************************************************
**
**  EnlUnRegister
**
**  Description:
**      This routine unregisters the specific event for notification.
**
**  Parameters:
**     input:
**        event : unique event to unregister
**
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT EnlUnRegister(DESCRIPTOR desc);

#ifdef __cplusplus
}
#endif
/******************************** E O F ***********************************/
