/*************************************************************************
**
** Name: list.h
**
** Description: Linked list definitions
**
** Status: coded.
**
** $Log:   S:/tbird/arccore/inc/list.h_v  $
** 
**    Rev 1.1   26 Jul 1991 07:58:42   doug
** remove list has return code and other changes are format differences 
** from hyperICE (where this file came from)
** 
** $Header:   S:/tbird/arccore/inc/list.h_v   1.1   26 Jul 1991 07:58:42   doug  $
**
** COPYRIGHT (C) 1991 MICROTEK INTERNATIONAL, INC.
**/
#define _LIST_

#ifndef _BASETYPE_
#include "basetype.h"
#endif

typedef struct LENTRY {
   struct LENTRY *lNext;
   VOID const *lData;
} LENTRY;
typedef struct LIST {
   LENTRY *head;
   LENTRY *current;
} LIST;

#define InitList(list)	((list)->head = NULL)
#define EmptyList(list)	((list)->head == NULL)
#define IsTailList(list)	((list)->current == NULL)
#define HeadList(list)	((list)->current = (list)->head)
#define GetList(list)	((list)->current ? (list)->current->lData: NULL)
#define NextList(list)	((list)->current = (list)->current ? (list)->current->lNext : NULL)

RETCODE EXPORT AppendList(LIST *list, VOID const *data);
RETCODE EXPORT RemoveList(LIST *list, VOID const *data);
VOID DoList(LIST *list, VOID (*Function)(VOID const *));
VOID DoListDel(LIST *list, VOID (*Func)(VOID const*));

/********************************* E O F ***********************************/
