/****************************************************************************
**
** Name: WSCOM.H
**
** Description: Header file for WSCOM interface routines (WSCOM.DLL or
**      WSNET.DLL).
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arccore/inc/wscom.h_v  $
** 
**    Rev 1.17   16 Mar 1994 12:29:20   tom
** Added upload packet size.
** 
**    Rev 1.16   21 Dec 1993 11:41:38   tom
** Network changes.
** 
**    Rev 1.15   21 Jul 1993 14:37:18   ron
** redefined HE_SELECT_COMM_DIALOG help entry point
** 
**    Rev 1.14   21 Jun 1993 16:49:36   ron
** added 3 defines for Help buttons in SDS dialogs
** 
**    Rev 1.13   22 Apr 1993 09:37:36   doug
** added flush function needed by shared data 
** 
**    Rev 1.12.1.1   23 Feb 1993 12:05:42   ernie
** Added WSComAckRequired prototype
** 
**    Rev 1.12.1.0   22 Feb 1993 13:37:30   ernie
** No change.
** 
**    Rev 1.12   03 Dec 1992 08:16:52   ernie
** Added parameter to WSComConfig to select DTR handshaking (for PwrScope)
** 
**    Rev 1.11   23 Oct 1992 13:01:20   ernie
** Changed interface and added comment header for WSComWrite and WSComRead
** 
**    Rev 1.10   31 Aug 1992 12:33:58   courtney
** Added changes that were supposed to be there.
** 
**    Rev 1.9   30 Aug 1992 16:37:30   courtney
** Increased queue size for i/o queues to 4K (were 1K).
** Removed unused definitions.
** 
**    Rev 1.8   27 Aug 1992 14:52:00   courtney
** Revised input queue threshold to reduce liklihood of overrun.
** 
**    Rev 1.7   25 Aug 1992 10:46:28   courtney
** Added define for Com Read timeout, SD_TIMEOUT.
** 
**    Rev 1.6   25 Aug 1992 10:28:20   mindy
** timer no longer linked to a window
** 
**    Rev 1.5   07 Aug 1992 17:28:20   courtney
** Added XonLim and XoffLim queue limits for DTR flow control.
** 
**    Rev 1.4   11 May 1992 12:06:48   nghia
** Renamed WSComDisconnect() to WSComClose() to match the network version.
** 
**    Rev 1.3   25 Mar 1992 15:57:32   courtney
** Revised prototypes for WSComRead and WSComWrite for return type
** RETCODE, which actually returns the number of bytes processed.
**
**  $Header:   S:/tbird/arccore/inc/wscom.h_v   1.17   16 Mar 1994 12:29:20   tom  $
**
** Copyright (C) 1991-2 Microtek International, Inc.
**
*****************************************************************************/
#define _WSCOM_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h" 
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define COM1 0
#define COM2 1
#define UNINIT 999      /* uninitialize COM port ID */
#define MAX_COM 4
#define MAX_TIMEOUT 10  /* try 10 times and quit */

/*
 * Help-related defines for Help buttons in SDS dialog boxes
 * (Todo: redefine as "real" help entry points -- 1 is table of contents)
 */
#define HE_PACK_OR_SCOPE_DIALOG  1
#define HE_SELECT_COMM_DIALOG    2048
#define IDHELP                   8

#if 1
#define MAX_QSIZE    4096  /* input/output queue sizes */
#define OUTQ_LIMIT   3276  /* queue limit Output queue for DTR signal (80%) */
#define INQ_LIMIT    2048  /* queue limit Input queue for DTR signal (50%) */
#else
#define MAX_QSIZE 1024  /* maximum number of bytes of the I/O queues */
#define OUTQ_LIMIT    819  /* queue limit Output queue for DTR signal */
#define INQ_LIMIT     500  /* queue limit Input queue for DTR signal */
#endif
#define SD_TIMEOUT      5  /* shared data timeout value */

/* COM ports structure */
typedef struct {
   WORD cId;         /* COM port id */
   char *cName;      /* COM port name */
} COM_PORT_TYPE;

/* ComInit Dialog Box definitions */
#define IDD_COM1      80
#define IDD_COM2      81
#define IDD_COM3      82
#define IDD_COM4      83

/* Dialog Control button */
#define IDD_CONNECT   10
#define IDD_CANCEL    11
#define IDD_OK        12

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

BOOL FAR PASCAL WSComInit(HWND hWnd, LPWORD cIndx);
BOOL FAR PASCAL WSComConfig(HWND hWnd, WORD cIndx, BOOLEAN useDTRHandshake);

/****************************************************************************
**
** WSComRead
**
** description:
**   Reads characters from the comm port or network.
**
** parameters:
**   input:
**      rxBuff:   Character array for received characters
**      numBytes: Maximum number of bytes to read
**   output:
**      numBytes: Number of characters actually read
**
*****************************************************************************/
RETCODE FAR PASCAL WSComRead(U8 FAR *rxBuff, U16 *numBytes);

/****************************************************************************
**
** WSComWrite
**
** description:
**   Sends characters to the comm port or network.
**
** parameters:
**   input:
**      txBuff:   Character array containing characters to transmit
**      numBytes: Number of bytes to transmit
**   output:
**      numBytes: Number of characters actually transmitted
**
*****************************************************************************/
RETCODE FAR PASCAL WSComWrite(U8 FAR *txBuff, U16 *numBytes);

/****************************************************************************
**
** WSComFlush
**
** description:
**   Flush the current comm port queue.
**
** parameters:
**   input:
**      none
**   output:
**      none
**
*****************************************************************************/
RETCODE FAR PASCAL WSComFlush(VOID);

BOOL FAR PASCAL WSComRecvTimer(WORD timeEllapse, FARPROC lpfnAppRecv);
BOOL FAR PASCAL WSComClose(VOID);

/****************************************************************************
**
** WSComAckRequired
**
** description:
**   Returns whether comm ACK/NAK is required after each packet
**
** parameters:
**   output:
**      TRUE if ACK/NAK is required.
**
*****************************************************************************/
BOOL FAR PASCAL WSComAckRequired(VOID);

/****************************************************************************
**
** WSComUploadPacketSize
**
** Description:
**   Return the number of bytes in an upload packet; 0 indicates unlimited
**   (limited only by the underlying transport mechanism).
**
** Parameters:
**   packetSize (out): upload packet size.
**
*****************************************************************************/
RETCODE FAR PASCAL WSComUploadPacketSize(U32 *packetSize);

/******************************** E O F ***********************************/
