/* Dequeuer Library */!!

inherit(ProvidedLibs, #DqLib, #(initialized), 2, nil)!!

setClassVars(DqLib, #())!!

now(class(DqLib))!!

/* semiPRIVATE - only called via require(). */
Def provide(self,path)
{ 
  ^initialize(new(self:ancestor),getDasmDLLName(PreLauncher));
}
!!

now(DqLib)!!

/* PRIVATE */
Def addImportProcs(self)
{
  add(self,#DADDQOPEN,1,#(1,1));
  add(self,#DADFORWARDDQINST,1,#(1,1,1,1,1,1));
  add(self,#DADBACKWARDDQINST,1,#(1,1,1,1,1,1));
  add(self,#DADSETDASMSYMBOL,1,#(0));
  add(self,#DADDQFLUSH,1,#(1));
}!!

/* PUBLIC -- create a dq instance */
Def dqOpen(self, traceId | aDq, rc, descriptorPtr) 
{ 
  aDq := new( Dq ) ;
  descriptorPtr := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#DADDQOPEN], descriptorPtr, traceId);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0) ^nil; endif;
  setDescriptor( aDq, longAt(descriptorPtr, 0) );
  setProcs( aDq, procs(self) ) ;
  
  ^aDq
}!!

/* PRIVATE 
   Open and initialize dq server library & load dasm dll
*/
Def initialize(self,path)
{
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;
   ^self ;
}
!!

/* DqLib Class Initialization Code */
