/* Methods for timing execution of other methods.
  See also, the time method in BlockContext.

  Example, to time the creation of a new Dictionary with
  100 elements you could type:
        time({new(Dictionary, 100);});
*/!!

inherit(Object, #StopWatch,
#(startTime /* Time at start of block execution */
stopTime  /* Time at end of block execution */), nil, nil)!!

now(class(StopWatch))!!

now(StopWatch)!!

/* Return the time between the start time and now. */
Def lap(self)
{ ^Call GetCurrentTime() - startTime;
}!!

/* Start the StopWatch.  Record the start time. */
Def start(self)
{ startTime := Call GetCurrentTime();
}!!

/* Stop the StopWatch.  Return the total time elapsed. */
Def stop(self)
{ stopTime := Call GetCurrentTime();
  ^stopTime - startTime;
}!!
