/****************************************************************************
**
**  Name:  emuport.h
**
**  Description:
**     Michelle setup-group routines.
**     include:
**        "emuInput" and "emuOutput" to use the I/O ports.
**
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/hfw328/arcm/emuport.h_v  $
** 
**    Rev 1.0   11 Jan 1996 10:48:38   gene
** Initial revision.
** 
**    Rev 1.0   03 Jan 1996 13:51:04   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:28   gene
** Initial revision.
** 
** Initial revision.
** 
**  $Header:   S:/tbird/hfw328/arcm/emuport.h_v   1.0   11 Jan 1996 10:48:38   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_PORT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

#include <string.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/


/****************************************************************************
**
**  EmuInput()
**
**  Description: Michelle input routine,
**
**  Parameters:
**     input:
**        port -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        return data -- "length" + "data"
**
*****************************************************************************/
VOID  EmuInput(U16 port, U16 len, U16 size);


/****************************************************************************
**
**  EmuOutput
**
**  Description: Michelle output routine,
**
**  Parameters:
**     input:
**        port  -- unsigned int,
**        value -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error
**
*****************************************************************************/
VOID EmuOutput(U16 port, U8 *value, U16 len, U16 size);



/******************************** E O F ***********************************/

