/* Window that holds the field name text. */!!

inherit(Edit, #FieldNameWindow, #(name /* copy of last valid name entered */
eventCondition /* for use in trigger presenter - trig spec window */), 2, nil)!!

now(class(FieldNameWindow))!!

/* PUBLIC
   Create a new fieldName window which is an Actor edit control object 
   and a Windows "Edit" control window.
 */
Def new (self, id, par | aFieldNameWindow)
{ 
  aFieldNameWindow := new(self:ancestor, id, par, WS_BORDER bitOr ES_AUTOHSCROLL bitOr WS_CHILD);
  if handle(aFieldNameWindow) = 0
  then alert(System, self, #wCreateError)
  endif;
  ^init(aFieldNameWindow);
}!!

/* PUBLIC
 */
Def newEventEditWindow (self, id, par, eventMask | aFieldNameWindow)
{ 
  aFieldNameWindow := new(self, id, par);
  setEventCondition(aFieldNameWindow,eventMask);
  ^aFieldNameWindow;
}!!

now(FieldNameWindow)!!

/* PUBLIC
   Return the trigger event condition mask.
 */
Def eventCondition(self)
{ 
  ^eventCondition
}
!!

/* PUBLIC
   Insert the incoming text string into the field name edit
   control window.
 */
Def getFieldName(self)
{ 
  ^name
}
!!

/* PUBLIC
   Initialized font size to use in Edit Control window.
 */
Def init(self)
{
  name := "" ;
  sendMessage(self,0x0030/*WM_SETFOCUS*/,getFont(parent),0L);
}
!!

/* PUBLIC
   Insert the incoming text string into the field name edit
   control window.
 */
Def setEventCondition(self, mask)
{ 
  eventCondition := mask;
}
!!

/* PUBLIC
   Insert the incoming text string into the field name edit
   control window.
 */
Def setFieldName(self, str)
{ 
  setText(self,str);
  name := str;
}
!!

/* PUBLIC
   When this window loses focus than we need to check the text entered
   in our edit control window.
 */
Def verifyInput(self | text)
{ 
  /* This routine will verify that the text is a valid string
     and would also verifies that the string entered is unique.
     There can't be two template field names with the same name.
   */ 
  text := getText(self);
  
  do(text,
  {using(c)
    if not(isPrintable(c))    /* @@@ this needs beefing up */
      displayFormattedError(ErrorTextLibClass$Inst, 
         ER_FIELD_NAME, FORCE_POPUP, nil, nil, nil);
      if name
        setText(self,name); 
      else
        setText(self,"");
      endif;
      ^nil;
    endif;
  });
  if alreadyDefined(parent,self,text)
      displayFormattedError(ErrorTextLibClass$Inst, 
         ER_FIELD_NAME_DUP, FORCE_POPUP, nil, nil, nil);
    if name
      setText(self,name); 
    else
      setText(self,"");
    endif;
    ^nil;
  endif;
  name := text;
  ^#true;
}
!!
