/* class comment */!!

inherit(Dialog, #GotoLineDialog, #(value /* value for display */
hlpEntry
), 2, nil)!!

setClassVars(GotoLineDialog, #())!!

now(class(GotoLineDialog))!!

Def open(self | dlg)
{
  dlg := new(self);
  ^dlg;
}!!

now(GotoLineDialog)!!

Def setHelpEntry(self, hlp) {
  hlpEntry := hlp;
}
!!

/* 4/16/1993 11:58 */
Def initDialog(self, wp, lp)
{
  /* place initial value */
  registerF1Help(CLIULibraryClass$Inst, HI_DLGR_GOTO_LINE,
     getHWnd(self), hlpEntry);
  if value
    setItemText(self, DLG_GOTO_LINE_NUMBER, value);
  endif;
  
  /* set item focus */  
  ^1;  /* informs Windows to set focus to tab stop 1 */
}
!!

/* 4/16/1993 11:58 */
Def getValue(self)
{
  ^value;
}
!!

/* 4/16/1993 11:58 */
Def setValue(self, newValue)
{
  value := newValue;
  
  ^0;
}
!!

Def command(self, wp, lp | s1 index)
{
  select
    case wp == IDCANCEL and high(lp) = 0 is
      end(self, IDCANCEL);
    endCase
    case wp == IDHELP 
      is contextNumber(TheHelpObject, hWnd, hlpEntry);
    endCase
    case wp == IDOK and high(lp)= 0 is
      s1 := peelBlanks(getItemText(self, DLG_GOTO_LINE_NUMBER));
      if (s1  = "")
        displayFormattedError(ErrorTextLibClass$Inst, 
           ER_LINE_MISSING, FORCE_POPUP, nil, nil, nil);
        setItemFocus(self, DLG_GOTO_LINE_NUMBER);
        ^0;
      endif;
      if not(getSymbolicOffset(AddressLibClass$Inst, s1))
        setItemFocus(self, DLG_GOTO_LINE_NUMBER);
        ^0;
      endif;
      
      /* input is acceptable; save previously obtained value, end */
      value := s1;
      end(self, IDOK);
    endCase
  endSelect;
  ^0;
}!!

