/* bookkeeping for the multiple memory window capability; used by
   PreLauncher and MPresenter classes. */!!

inherit(Object, #MultMem, nil, 2, nil)!!

setClassVars(MultMem, #($windowArray /* array of memory window objects */
$showArray
  /* array of show state; replaces $presenterDict[4] */
$memoryWindowMax /* maximum number allowed */
$memoryWindowCount /* current memory windows */))!!

now(class(MultMem))!!

/* Return true if bad index, false otherwise.  NOTE THE REVERSE LOGIC:
   a bad index returns 0; a good index returns nil. */
Def badIndex?(self, index)
{
  /* reject illegal values */
  if not(index) cor (index < 0) cor (index >= $memoryWindowMax)
    ^0;
  endif;
  
  ^nil;
}
!!

/* Set current show status. */
Def setShowStatus(self, index, show)
{
  /* reject bad index */
  if badIndex?(self, index)
    ^nil;
  endif;
  
  $showArray[index] := show;
  
  ^0;
}
!!

/* Get current show status. */
Def getShowStatus(self, index)
{
  /* reject bad index */
  if badIndex?(self, index)
    ^nil;
  endif;
  
  ^$showArray[index];
}
!!

/* Allocate the entry in the table. */
Def memoryWindowObject(self, index)
{
  /* reject bad index */
  if badIndex?(self, index)
    ^nil;
  endif;
  
  ^$windowArray[index];
}
!!

/* Generate a label of the form "TheMemoryPresenterXX" where
   "XX" is 01, 02, ... n. */
Def memoryWindowLabel(self, index)
{
  /* reject bad index */
  if badIndex?(self, index)
    ^nil;
  endif;
  
  /* if more than 99 presenters supported, change 2 -> 3 */
  ^"TheMemoryPresenter" + right(asString(index), 2, "00");
}
!!

/* Free the entry in the table. */
Def freeMemoryIndex(self, index)
{
  /* reject bad index */
  if badIndex?(self, index)
    ^nil;
  endif;
  
  $windowArray[index] := nil;
  $memoryWindowCount :=  $memoryWindowCount - 1;
  
  ^0;
}
!!

/* Allocate the entry in the table. */
Def allocateMemoryIndex(self, index, object)
{
  $windowArray[index] := object;
  $memoryWindowCount :=  $memoryWindowCount + 1;
  
  ^0;
}
!!

/* Return the index of an available memory window entry, or nil if none. */
Def getFreeMemoryWindowIndex(self | index)
{
  /* early exit if already full */
  if ($memoryWindowCount = $memoryWindowMax)
    ^nil;
  endif;
  
  /* loop through until an empty one is found */
  index := 0;
  loop
  while (index < $memoryWindowMax)
  begin
    if not($windowArray[index])
      ^index;
    endif;
    index := index + 1;
  endLoop;
  
  ^nil;
}
!!

/* Return "..." if more than zero memory windows open, "" otherwise.
   Used to construct memory menu entry in PreLauncher/WM_INITMENU. */
Def memoryMenuSuffix(self)
{
  if (memoryWindowCount(self) > 0)
     ^"...";
  endif;
  ^"";
}
!!

/* Return the number of open memory windows. */
Def memoryWindowCount(self)
{
  ^$memoryWindowCount;
}
!!

/* return the maximum number of memory windows allowed. */
Def memoryWindowMax(self)
{
  ^$memoryWindowMax;
}
!!

now(MultMem)!!

/* MultMem Class Initialization Code */
$memoryWindowMax := 20;
$memoryWindowCount := 0;
$windowArray := new(Array, $memoryWindowMax);
$showArray := new(Array, $memoryWindowMax);