/* A CStruct that is itself a nested field within another
struct. */!!

inherit(CStruct, #SubStruct, #(offset), 2, nil)!!

now(SubStructClass)!!

now(SubStruct)!!

/* Return the contents of the field with the given
  name. */
Def at(self, name | field)
{ errorIfNil(field := fieldAt(self, name),
  #fieldNameError);
  ^fetch(field, data, offset);
}!!

/* Store a value in the field with the given name. */
Def put(self, val, name | field)
{ errorIfNil(field := fieldAt(self, name),
  #putFieldNameError);
  ^store(field, data, val, offset);
}!!


/* Store a logical element of an arrayed field. Where
  val is the value of the element to be stored, name is
  the field name and offs is the element offset in
  the array where the value is to be stored. */
Def putElement(self, val, name, offs | field)
{ errorIfNil(field := fieldAt(self, name),
  #putFieldNameError);
  storeElement(field, data, val, offs, offset);
  ^val;
}!!

/* Set the receiver iVars to the specified values. */
Def setFields(self, f, struct, offs)
{ fields := f;
  data := struct;
  offset := offs;
}!!

/* Return the contents of the field with the given
  name. Same as at method, except returns nil if
  given field name is invalid. */
Def shortAt(self, name | field)
{ if field := fieldAt(self, name)
  then ^fetch(field, data, offset);
  endif;
  ^nil;
}!!
