/* utilities for dialog manipulation */!!

inherit(Dialog, #DialogUtilities, nil, 2, nil)!!

now(class(DialogUtilities))!!

now(DialogUtilities)!!

/* set the top index of a listbox. */
Def setTopIndex(self, listBoxIndex, top)
{
  ^Call SendMessage(itemHandle(self, listBoxIndex), LB_SETTOPINDEX, top, 0L);
}!!

/* set scroll range directly. */
Def localSetScrollRange(self, controlID)
{
  Call SetScrollRange(itemHandle(self, controlID), SB_CTL, 0, 100, 1);
  ^0;
}!!

/* Set scroll bar position directly. */
Def localSetScrollPos(self, controlID, pos)
{
  Call SetScrollPos(itemHandle(self, controlID), SB_CTL, pos, 1);
  ^0;
}!!

/* Must do redraw through Windows; Actor hides direct access. */
Def localRedrawOn(self, controlID)
{
  Call SendMessage(itemHandle(self, controlID), WM_SETREDRAW, 1, 0L);
  ^0;
}!!

/* Must do redraw through Windows; Actor hides direct access. */
Def localRedrawOff(self, controlID)
{
  Call SendMessage(itemHandle(self, controlID), WM_SETREDRAW, 0, 0L);
  ^0;
}!!

/* get the top index of a listbox. */
Def getTopIndex(self, listBoxIndex)
{
  ^Call SendMessage(itemHandle(self, listBoxIndex), LB_GETTOPINDEX, 0, 0L);
}!!

/* calculate scroll bar position; if entire width visible, position is 0;
   otherwise, ranges from offset = 0 -> 0 to offset = max - width -> 100 
   NOTES: 09/20/93 - Nghia
   if (max == width) -> UAE divide by 0
*/
Def calculateThumbPosition(self, offset, max, width)
{  
  if (max <= width)
    ^0;
  else
    ^((offset*100) / (max - width));
  endif;
}!!

/* calculate offset from thumb position.  50 is added for rounding. */
Def calculateOffset(self, pos, max, width)
{
  ^asInt(((pos * (max - width)) + 50) / 100);
}!!
