/* class comment */!!

inherit(ProvidedLibs, #Sds2abiLib, nil, 2, nil)!!

now(class(Sds2abiLib))!!

/* semiPRIVATE -- should only be called via require(TclassLib)
   Define entry points and load library.  Define any structs required.
*/
Def provide(self, path)
{
  ^initialise(new(self:ancestor), path)
}!!

now(Sds2abiLib)!!

/* 6/27/1996 15:55 */
Def Sds2AbiSetTraceEnable(self TraceEnable)
{ 
  if pcallLock(self) then
    lastError := pcall(procs[#SDS2ABISETTRACEENABLE], TraceEnable);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD) then
    displayFormattedError(ErrorTextLibClass$Inst, 
       lastError, CHECK_MODE, nil, nil, nil);
    ^nil;
  endif;

  ^GOOD;
}!!

/* 6/27/1996 16:14 */
Def Sds2AbiGetTraceEnable(self | TraceEnable)
{ 
  TraceEnable := new(Struct,4);
  if pcallLock(self) then
    lastError := pcall(procs[#SDS2ABIGETTRACEENABLE], TraceEnable);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD) then
    displayFormattedError(ErrorTextLibClass$Inst, 
       lastError, CHECK_MODE, nil, nil, nil);
    ^nil;
  endif;

  ^wordAt(TraceEnable,0);
}!!

/* 6/27/1996 16:14 */
Def Sds2AbiGetTraceBreak(self | TraceBreak)
{ 
  TraceBreak := new(Struct,4);
  if pcallLock(self) then
    lastError := pcall(procs[#SDS2ABIGETBREAKONFULL], TraceBreak);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD) then
    displayFormattedError(ErrorTextLibClass$Inst, 
       lastError, CHECK_MODE, nil, nil, nil);
    ^nil;
  endif;

  ^wordAt(TraceBreak,0);
}
!!

/* 6/27/1996 15:55 */
Def Sds2AbiSetTraceBreak(self TraceBreak)
{ 
  if pcallLock(self) then
    lastError := pcall(procs[#SDS2ABISETBREAKONFULL], TraceBreak);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD) then
    displayFormattedError(ErrorTextLibClass$Inst, 
       lastError, CHECK_MODE, nil, nil, nil);
    ^nil;
  endif;

  ^GOOD;
}!!

/* PRIVATE
   Define all entry points for library as prototypes.
*/
Def addImportProcs(self)
{
  add( self, #SDS2ABISETBREAKONFULL, 1, #(0));  
  add( self, #SDS2ABIGETBREAKONFULL, 1, #(1));  
  add( self, #SDS2ABISETTRACEENABLE, 1, #(0));  
  add( self, #SDS2ABIGETTRACEENABLE, 1, #(1));  
}
!!