/* Presenter class of the trigger specification window. */!!

inherit(MaxSizeWindow, #TriggerPresenter, #(activeLevel /* currently active level */
levelWin 
hFont   /* holds font size */
charWidth
charHeight
nonScrollArea /* size of header area that isn't scrolled */
theTrigger /* trigger instance for this window */
), 2, nil)!!

now(class(TriggerPresenter))!!

/* Return the default window style. */
Def style(self)
{ ^(WS_SYSMENU bitOr WS_MINIMIZEBOX bitOr WS_OVERLAPPED);
}!!

/* PUBLIC */
Def open(self | newInstance)
{
  newInstance := newStyle(TriggerPresenter, nil, nil, "Trigger",
                   nil, nil, style(self));
  if newInstance then show(newInstance, SW_SHOW) endif ; 
  ^newInstance ;
}!!

Def openWithPosAndState(self, sizeRect showVal | newInstance )
{ 
  if (sizeRect = nil) then
    sizeRect := rect(100,100,500,240);
  endif;  

  newInstance := newStyle(TriggerPresenter, nil, nil, "Trigger",
                   sizeRect, nil, style(self));

  if newInstance then show(newInstance, showVal) endif ;
  ^newInstance ;
}!!

Def wndClass(self)
{ ^"TriggerPresenter"
}!!

/* return name of trigger icon */
Def wndIcon(self)
{ ^"trigger" }
!!

now(TriggerPresenter)!!

/* 8/20/1996 15:51 */
Def WM_LBUTTONDOWN(self wp lp)
{ 
  showList(eventList1,nil);
  showList(eventList2,nil);
}!!

/* 8/22/1996 17:49 */
Def checkSelChange(self preSel | rc msg1 msg2 c0 c10 c13)
{ 
  rc := nil;
  if ((eventSel1 <> 0) and (preSel = 0) and level2Flag) then
    msg1 := "Only one event can be set in trigger.";
    msg2 := "The event set in trigger level-2 will be removed.";
    c0 := asString(asChar(0));
    c10 := asString(asChar(10));
    c13 := asString(asChar(13));
    rc := Call MessageBox(getHWnd(self),msg1+c10+c13+msg2+c0,
                          "Trigger Setting Warning",
                          MB_OKCANCEL bitOr MB_ICONEXCLAMATION);                        
  endif;
  if ((rc = IDOK) or (eventSel1 = 0)) then
    level2Flag := 1;  /* force clear box setting */
    handleEnable2(self,0,0);
    trigEventNameSet(theTrigger,""); /* avctive level is level 1 */
    eventSel2 := -1;
    level0(self);
    ^GOOD;
  endif;
  level0(self);
  if (rc = IDCANCEL) then
    ^nil;
  endif;  
  ^GOOD;
}!!

/* 8/22/1996 17:32 */
Def checkPcBkptSet(self hList hEnable | pcStart)
{ 
  evtSetActiveEvent($commonEventLib,"PC_Breakpoint");
  evtSetActiveField($commonEventLib,"address");
  pcStart := evtGetStart($commonEventLib);
  if (size(leftJustify(pcStart)) = 0) then
    if (trigEditPcBkpt(self) <> 1) then
      trigEventEnableSet(theTrigger,0);
      level1Flag := nil;  /* force clear box setting */
      setCheck(hEnable,nil);
      ^nil;
    endif;  
  endif;
  trigActionSet(theTrigger,2);
  trigActionClear(theTrigger,1);
  ^GOOD;
}!!

/* 5/28/1996 14:17 */
Def updateCheckBox(self)
{ /* update check bus for execution breakpoint setting */
  if (setupCheckBox(self,level1Enable) = 0)
    level1Flag := nil;
  else
    level1Flag := 1;  
  endif;
  if (setupCheckBox(self,level2Enable) = 0)
    level2Flag := nil;
  else
    level2Flag := 1;
  endif;
  disable(eventList2);
  disable(level2Enable);
}!!

/* 5/22/1996 11:16 */
Def trigEditPcBkpt(self)
{ 
  ^trigDlgPcBkpt(TriggerLibClass$Inst,getHWnd(self),descriptor($commonEventLib));
}
!!

/* 5/16/1996 9:50 */
/* trigger action used to recognize breakpoint
   1 => bus breakpoint
   2 => PC breakpoint 
*/   
Def initControlValue(self | rText EvtName2)
{ 
  level0(self);
  trigEventSet(theTrigger,eventMap[0]);
  trigActionSet(theTrigger,1);      /* bus breakpoint */
  setupList(eventList1);
  eventSel1 := selectString(eventList1, trigEventNameGet(theTrigger));
  if eventSel1 then
    if eventSel1 = 0
      trigActionSet(theTrigger,2);  /* PC breakpoint */
      trigActionClear(theTrigger,1);
    else
      trigActionClear(theTrigger,2);
      trigActionSet(theTrigger,1);
    endif;  
    setupCheckBox(self, level1Enable);
  else
    disable(level1Enable);
    evtSetActiveEvent($commonEventLib,"PC_Breakpoint");
    evtSetActiveField($commonEventLib,"address");
    evtSetStart($commonEventLib,"");
  endif;    
  level1(self);
  trigEventSet(theTrigger,eventMap[0]);
  trigActionSet(theTrigger,1);
  setupList2(eventList2,eventSel1);
  EvtName2 := trigEventNameGet(theTrigger);
  if EvtName2
    if EvtName2 = "PC_Breakpoint"
      trigActionSet(theTrigger,2);
      trigActionClear(theTrigger,1);
    else
      trigActionClear(theTrigger,2);
      trigActionSet(theTrigger,1);
    endif; 
    selectString(eventList2,EvtName2); 
  endif;
    
  setupCheckBox(self, level2Enable);
  level1Flag := getCheck(level1Enable);
  if not(level1Flag) then
    disable(level2Enable);
    disable(eventList2);
  endif;
  level2Flag := getCheck(level2Enable);
}!!

/* 5/16/1996 9:47 */
Def newWinControl(self)
{ 
  eventMap := asOrderedCollection(new(Collection,2));
  add(eventMap,TRIG_EV_0_COND);
  add(eventMap,TRIG_EV_1_COND);
  eventList1 := newEventWindow(TriggerEventWindow,0x1001,
                      self,eventMap[0]);
  eventList2 := newEventWindow(TriggerEventWindow,0x1002,
                      self,eventMap[0]);
  level1Enable := newCheck(Button,0x1011,self,"Enable");
  level2Enable := newCheck(Button,0x1012,self,"Enable");
}!!

/* 5/15/1996 17:44 */
Def handleEnable2(self wp lp | checkValue rc )
{ 
  level1(self);
  if (level2Flag = nil) then
    if (getSelString(eventList2) = "PC_Breakpoint") then
      trigActionSet(theTrigger,2);
      trigActionClear(theTrigger,1);
    else
      trigActionClear(theTrigger,2);
      trigActionSet(theTrigger,1);
    endif;  
    level2Flag := 1;
    checkValue := 1;
  else
    level2Flag := nil;
    checkValue := 0;
  endif;
  setCheck(level2Enable,level2Flag);
  rc := trigEventEnableSet(theTrigger,checkValue);
}!!

/* 5/15/1996 17:40 */
Def handleEnable1(self wp lp | checkValue rc tmpSel bkptAddr warningStr 
        titleStr)
{ 
  level0(self);
  bkptAddr := sdsFindHWBkptAddr(SharedDataLibClass$Inst);
  if bkptAddr then
    warningStr := "Breakpoint at ROM location 0x"+asStringRadix(bkptAddr,16)+
                  " must be cleared !"+asString(asChar(0));
    titleStr := "Set Trigger"+asString(asChar(0));
    Call MessageBox(getHWnd(self),warningStr,titleStr,MB_OK bitOr MB_ICONASTERISK);
    level1Flag := 1; /* force clear box setting */
  endif;  
  if (level1Flag = nil) then
    tmpSel := getSelIdx(eventList1);
    if  tmpSel <> nil then
      if tmpSel = 0
        trigActionSet(theTrigger,2);
        trigActionClear(theTrigger,1);
      else
        trigActionClear(theTrigger,2);
        trigActionSet(theTrigger,1);
      endif;  
      level1Flag := 1;
      checkValue := 1;
      enable(eventList2);
      level1(self);
      if (selectString(eventList2,trigEventNameGet(theTrigger))) then
        enable(level2Enable);
      else
        disable(level2Enable);  
      endif;  
      level0(self);
    endif;  
  else
    level1Flag := nil;
    checkValue := 0;
    disable(level2Enable);
    disable(eventList2);
  endif;
  setCheck(level1Enable,level1Flag);
  rc := trigEventEnableSet(theTrigger,checkValue);
}!!

/* 5/15/1996 17:39 */
Def handleList2(self wp lp | tmpSel EvtName)
{ 
  level1(self);
  select
    case high(lp) = 1  /* CBN_SELCHANGE */
      enable(level2Enable);
      tmpSel := eventSel2;
      if ((eventSel2 := getSelIdx(eventList2)) = nil) then
        eventSel2 := getCount(eventList2) - 1;
        setCurSel(eventList2,eventSel2);
      endif;
      if ((EvtName := getSelString(eventList2)) = "PC_Breakpoint") then
        if (not(checkPcBkptSet(self,eventList2,level2Enable))) then
          if (not(tmpSel)) then
            tmpSel := -1;
          endif;
          setCurSel(eventList2,tmpSel);
          eventSel2 := tmpSel;
          disable(level2Enable);
          ^0;
        endif;  
      else
        trigActionClear(theTrigger,2);
        trigActionSet(theTrigger,1);
      endif;  
      trigEventNameSet(theTrigger,EvtName);
      level2Flag := nil;  /* force set box enable */
      handleEnable2(self,0,0);
    endCase;
    case high(lp) = 3
      setupList2(eventList2,eventSel1);
      if eventSel2 then  
        setCurSel(eventList2,eventSel2);
      else
        setCurSel(eventList2,-1);
      endif;  
    endCase;  
  endSelect; 
}!!

/* 5/15/1996 17:35 */
Def handleList1(self wp lp | tmpSel)
{
  level0(self);
  select 
    case high(lp) = 1    /* CBN_SELCHANGE */
      enable(level1Enable);
      tmpSel := eventSel1;
      if ((eventSel1 := getSelIdx(eventList1)) = nil) then
        eventSel1 := getCount(eventList1) - 1;
        setCurSel(eventList1,eventSel1);
      endif;
      if (checkSelChange(self,tmpSel) = nil) then
        if (not(tmpSel)) then
          tmpSel := -1;
        endif;
        setCurSel(eventList1,tmpSel);
        eventSel1 := tmpSel;
        ^0;
      endif;
      if eventSel1 = 0 
        if (not(checkPcBkptSet(self,eventList1,level1Enable))) then
          if (not(tmpSel)) then
            tmpSel := -1;
            disable(level1Enable);
          endif;
          setCurSel(eventList1,tmpSel);
          eventSel1 := tmpSel;
          disable(eventList2);
          ^0;
        endif;  
      else
        trigActionClear(theTrigger,2);
        trigActionSet(theTrigger,1);
      endif;
      trigEventNameSet(theTrigger,getSelString(eventList1));
      setupList2(eventList2,eventSel1);
      level1Flag := nil;   /* force set box enable */
      handleEnable1(self,0,0);
    endCase;  
    case high(lp) = 3    /* CBN_SETFOCUS */
      setupList(eventList1); 
      if eventSel1 then
        setCurSel(eventList1,eventSel1);  
      else
        setCurSel(eventList1,-1);
      endif;  
    endCase;    
  endSelect;
}!!

/* 5/13/1996 13:03 */
/* Control ID : eveneList1   = 0x1001
                eventList2   = 0x1002
                level1Enable = 0x1011
                level2Enable = 0x1012
*/
Def initControl(self)
{
  newWinControl(self);
  initControlValue(self);

  setCRect(eventList1,rect(140,17,300,17+charHeight*2));  
  setCRect(eventList2,rect(140,57,300,57+charHeight*2));  
  setCRect(level1Enable,rect(320,22,390,22+charHeight));
  setCRect(level2Enable,rect(320,60,390,60+charHeight));

  moveWindow(eventList1);
  moveWindow(eventList2);
  moveWindow(level1Enable);
  moveWindow(level2Enable);
}!!

/* 5/13/1996 15:22 */
Def setupCheckBox(self box | eventActive)
{ 
  Call SendMessage(getHWnd(box), BM_SETCHECK,
                   eventActive :=trigEventEnableGet(theTrigger), 0);
  if ( eventActive <> 0) then
    Call SendMessage(getHWnd(box), BM_SETCHECK, 1, 0);
    eventActive := 1;
  else  
    Call SendMessage(getHWnd(box),BM_SETCHECK,0,0);
  endif;
  ^eventActive;
}!!

/* 1/18/1996 15:26 */
Def trigDlgQualTrace(self|rc) {

   rc := trcDlgQTrace(TraceLibClass$Inst, handle(self));
/***
   if (rc = 1) 
      checkMenuItem(self, "Trace &Qualify...");
   else
      unCheckMenuItem(self, "Trace &Qualify...");
   endif;
***/
}
!!

/* 11/10/1994 17:25 */
Def trigExtInSelect(self | dlg){   
  dlg := new(ExtInSelectDialog);
  runModal(dlg, 426, ThePort);
  /*  426 is the dialogbox id for ExtInSelectDialog */
}

!!

/* PUBLIC
 */
Def charHeight(self){
  ^charHeight;
}
!!

/* PUBLIC
 */
Def charWidth(self){
  ^charWidth;
}
!!

/* Used only by event definition window */
Def childIsClosing(self, handle)
{
}
!!

/* termination processing */
Def close(self | temp)
{ 
  /* Notify parent of close -- pdr2 */
  if parent
  then
    childIsClosing( parent, self ) ;
  endif ;

  if TheTriggerPresenter then TheTriggerPresenter := nil endif ;
/*  closeSelf(levelWin); */
  close(self:ancestor);
}
!!

/* PRIVATE
   Respond when the user clicks on one of our buttons.  If the message
   isn't a BN_CLICKED message pass it up to our ancestor.
   NOTES: Nghia - 10/12/93
   Clear ESC key before processing command.
 */
/* Control ID : eveneList1   = 0x1001
                eventList2   = 0x1002
                level1Enable = 0x1011
                level2Enable = 0x1012
*/
Def command(self, menuId, lp | actionmsg id ){ 

  if actionmsg := action(menu, menuId) then
    /* Clear ESC key */
    if (TaskLibClass$Inst)
      checkAbort(TaskLibClass$Inst);
    endif;
    ^perform(self, actionmsg)
  else 
    select
      case menuId = 0x1001 
        handleList1(self,menuId,lp);
      endCase;  
      case menuId = 0x1002 
        handleList2(self,menuId,lp); 
      endCase;  
      case menuId = 0x1011 
        handleEnable1(self,menuId,lp);
      endCase;
      case menuId = 0x1012  
        handleEnable2(self,menuId,lp);
      endCase;
    endSelect; 
    ^command(self:ancestor, menuId, lp);  
  endif;
}!!

/* PUBLIC
   Return calculated font info.
 */
Def getFont(self)
{ ^hFont;
}
!!

/* PRIVATE */
Def init(self | buttonVal value mode){
  showWaitCurs();
  setFontSize(self);
  /* Globally open trigger server */
  theTrigger := triggerOpen( require( TriggerLib ), "", "default" ) ; 
  if not($commonEventLib)
    $commonEventLib := eventOpen( require(EventLib), "default" ) ; 
  endif;
  
/*  levelWin := newChild(TrigSpecWindow,0,self,nil);
  nonScrollArea := charHeight+4;  // reserve pixels for title area //
  activeLevel := 0;
  trigSeqLevelSet( theTrigger, 0 ) ;
  setupLevel(levelWin);
*/
  initMenus(self);
  initControl(self);
  
  mode := trigCounterFunctionGet(theTrigger);
  if( mode = TRIG_AS_COUNTER )
    trigCounterMode(self)
  else
   trigTimerMode(self);
  endif;

  mode := trigQualifierGet(theTrigger);
  /* don't check clock if micepack */
  if (mode = QUALIFY_AS_BUS) cor (micepack?(ProcLibClass$Inst))
    unCheckMenuItem(self,"C&lock");
    checkMenuItem(self,"&Bus");
  else
    checkMenuItem(self,"C&lock");
    unCheckMenuItem(self,"&Bus");
  endif;
  
  setSize(self,locRect);
/*  sizeKids(self); */
  showOldCurs();
}!!

/* PRIVATE
   Initialize the menus.
 */
Def initMenus(self | aMenu systemType proc)
{ 
  aMenu := new(OrderedCollection, 8);
  proc  := getSpecificProcessor(ProcLibClass$Inst);
  initMenu(self);
  
  add(aMenu, tuple("&File",tuple(
                      tuple("E&xit",   #trigExit))));
                      
  add(aMenu, tuple("&Edit",tuple(
                      tuple("E&vents...",    #trigEvent),
                      tuple("PC Breakpoint...", #trigEditPcBkpt))));

/* CAUTION: menu updates must be done to both sets of tuples below... */
/* Below modified by Jimmy 9/26/94 */
/*  Above modified by Jimmy 9/26/94 */
/*  add(aMenu, tuple("&Level",tuple(
                      tuple("Show Level &0",    #level0),
                      tuple("Show Level &1",    #level1),
                      tuple("Show Level &2",    #level2),
                      tuple("Show Level &3",    #level3))));
*/                                                                                                                                     
  attachMenuChoices(self,aMenu);
  addWindowAndHelp(self, "Tri&gger", HELP_ENTRY_TRIGGER);
  registerF1Help(CLIULibraryClass$Inst, HI_ENTRY_TRIGGER,
     getHWnd(self), HELP_ENTRY_TRIGGER);
  /* disable Clock menu if MICEpack connected */
  if micepack?(ProcLibClass$Inst)
    grayMenuItem(self, "C&lock");
  endif;
  drawMenu(self);
}!!

/* PRIVATE */
Def level0(self){
  trigSeqLevelSet( theTrigger, 0 ) ;
  activeLevel := 0;
/*  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 0 ) ;
  activeLevel := 0;
  invalidate(self);
  setupLevel(levelWin);
*/  
}
!!

/* PRIVATE */
Def level1(self){
  trigSeqLevelSet( theTrigger, 1 ) ;
  activeLevel := 1;
/*  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 1 ) ;
  activeLevel := 1;
  invalidate(self);
  setupLevel(levelWin);
*/  
}!!

/* PRIVATE
 */
Def level2(self){
/*  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 2 ) ;
  activeLevel := 2;
  setupLevel(levelWin);
  invalidate(self);
*/  
}
!!

/* PRIVATE
 */
Def level3(self){
/*  closeSelf(levelWin);
  trigSeqLevelSet( theTrigger, 3 ) ;
  activeLevel := 3;
  setupLevel(levelWin);
  invalidate(self);
*/  
}
!!

/* WINDOWS */
Def paint(self, hdc | aStr oldFont width)
{ 
/*  aStr := "Trigger  -  Level " + asString(activeLevel);*/
  aStr := "Trigger";
  setText(self,aStr);
  if oldFont := Call SelectObject(hdc,getFont(self))
    initTextColors(self,hdc);
    aStr := "Level 1 Breakpoint : ";
    Call TextOut(hdc, 20, 20, aStr, size(aStr));
    aStr := "Level 2 Breakpoint : ";
    Call TextOut(hdc, 20, 60, aStr, size(aStr));
    Call SelectObject(hdc,oldFont);
  endif;
  width := (charWidth(self) * 22)+(charWidth(self)/2);
/*  fill(rect(0,100,450,102),stock(BLACK_BRUSH),hdc);*/
}!!

/* PRIVATE
   Calculate font size given size of window.
   Currently just assigns smallest font size.
 */
Def setFontSize(self | hdc, tm, oldFont)
{ 
  /* Messing with Windows font sizes directly */
  hFont := Call CreateFont(16,6,0,0,
                     FW_NORMAL,0,0,0,ANSI_CHARSET,
                     OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                     DEFAULT_QUALITY, FIXED_PITCH bitOr FF_ROMAN,
                     asciiz("Tms Rmn"));
  tm := new(Struct, 32);
  hdc := getContext(self);
  oldFont := Call SelectObject(hdc,hFont);
  Call GetTextMetrics(hdc, tm);
  charWidth := asInt(wordAt(tm, 10));
  charHeight := asInt(wordAt(tm, 8)) + asInt(wordAt(tm, 0));
  if oldFont
    Call SelectObject(hdc,oldFont);
  endif;
  releaseContext(self, hdc);
}!!

/* PUBLIC
   Show self and all of the child windows.
 */
Def show(self, arg)
{ 
  show(self:WindowsObject, arg);
/*  show(levelWin,SW_NORMAL); */

  show(eventList1,SW_NORMAL);
  show(eventList2,SW_NORMAL);
  show(level1Enable,SW_NORMAL);
  show(level2Enable,SW_NORMAL);  
}!!

/* PRIVATE
   Place the push buttons at the top of the trigger window.
 */
Def sizeKids(self | startPos levelStart) {
/*  setCRect(levelWin,rect(0, nonScrollArea,
           461,(nonScrollArea + (charHeight*15) + (charHeight/2) + 2)));
  moveWindow(levelWin);
  invalidate(self);
*/  
}!!

Def sizeRect(self | rc offset ht wd)
{ offset := 0;
  ht := charHeight;
  if( not(ht) )
    ht := 16;  /* default height */
  endif;
  wd := charWidth;
  if( not(wd) )
    wd := 6;  /* default width */
  endif;
  if (x(screenSize()) > 800)
    rc :=rect(90, 40, (90 + (wd * 78) + (wd/3)), (40 + (ht*21)));
  else
    rc :=rect(90, 40, (90 + (wd * 78) + (wd/3)), (40 + (ht*20)));
  endif;
  ^rc;
}
!!

/* 9/21/1992 15:43 */
Def trigCounterMode(self)
{
/* map micepack counter -> timer */
/* (vincent: should not be the case)
  if micepack?(ProcLibClass$Inst)
    ^trigTimerMode(self);
  endif;
*/
  unCheckMenuItem(self,"Ti&mer");
  checkMenuItem(self,"&Counter");
/*  musicalBoxes(levelWin,TRIG_AS_COUNTER);
  invalidate(levelWin); 
*/  
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","counterTimer","counter");  
}
!!

/* PRIVATE
 */
Def trigEvent(self){ 
  showWaitCurs();
  if TheEventPresenter
  then 
    Call BringWindowToTop(getHWnd(TheEventPresenter)); 
    show( TheEventPresenter, SW_SHOWNORMAL ) ;
  else
    TheEventPresenter := open(EventWindow);
  endif;
  showOldCurs();
}
!!

/* PRIVATE
 */
Def trigExit(self)
{ 
  if (shouldClose(self))
  then
    close(self) ;
  else
    displayFormattedError(ErrorTextLibClass$Inst, 
       ER_INTERNAL, FORCE_POPUP, "File Exit Bug", 
       "shouldClose(self) said no", nil);
  endif ;
}
!!

/* PUBLIC */
Def trigger(self)
{ ^theTrigger }
!!

/* 6/1/1992 15:43 */
Def trigGoCounterMode(self){
  /* map micepack counter -> timer */
/* MICEpack does support counter mode
  if micepack?(ProcLibClass$Inst)
    ^trigGoTimerMode(self);
  endif;
*/
  trigCounterMode(self);
  trigCounterFunctionSet( theTrigger, TRIG_AS_COUNTER) ;
/*  setupLevel(levelWin);*/
}
!!

/* 6/1/1992 15:43 */
Def trigGoTimerMode(self){ 
  trigTimerMode(self);
  trigCounterFunctionSet( theTrigger, TRIG_AS_TIMER) ;
/*  setupLevel(levelWin);*/
}
!!

/* 9/21/1992 15:43 */
Def trigTimerMode(self){
/* only update menu entries if not micepack */
/* Vincent: should not be the case
  if not(micepack?(ProcLibClass$Inst))  */
    unCheckMenuItem(self,"&Counter");
    checkMenuItem(self,"Ti&mer");
/*  endif;  */
/*  musicalBoxes(levelWin,TRIG_AS_TIMER);
  invalidate(levelWin); 
*/  
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","counterTimer","timer");  
}
!!

/* 6/1/1992 15:02 */
Def trigTraceConf(self | dlg){   
  dlg := new(TraceControlDialog);
  runModal(dlg, DLG_TRACECON, ThePort);
}!!

/* 6/1/1992 15:43 */
Def trigUseBusCycles(self)
{
  unCheckMenuItem(self,"C&lock");
  checkMenuItem(self,"&Bus");
  trigQualifierSet( theTrigger, QUALIFY_AS_BUS );
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","trigMode","bus");  
}
!!

/* 6/1/1992 15:43 */
Def trigUseClockCycles(self)
{
  /* map clock -> bus for micepack */
  if micepack?(ProcLibClass$Inst)
    ^trigUseBusCycles(self);
  endif;
  unCheckMenuItem(self,"&Bus");
  checkMenuItem(self,"C&lock");
  trigQualifierSet( theTrigger, QUALIFY_AS_CLOCK );
  saveProfileEntry(TheProfileInfoObj,"TrigInfo","trigMode","clock");  
}
!!
