#define _REG68306_DEFINE_

typedef enum {
   R_GPR00,R_GPR01,R_GPR02,R_GPR03,R_GPR04,
   R_GPR05,R_GPR06,R_GPR07,R_GPR08,R_GPR09,
   R_GPR10,R_GPR11,R_GPR12,R_GPR13,R_GPR14,
   R_GPR15,R_GPR16,R_GPR17,R_GPR18,R_GPR19,
   R_GPR20,R_GPR21,R_GPR22,R_GPR23,R_GPR24,
   R_GPR25,R_GPR26,R_GPR27,R_GPR28,R_GPR29,
   R_GPR30,R_GPR31,
                          R_XER,      R_LR,        R_CTR,
   R_DSISR,   R_DAR,      R_DC,       R_SRR0,      R_SRR1,
   R_SPRG0,   R_SPRG1,    R_SPRG2,    R_SPRG3,     R_PVR,
   R_TB_READ, R_TBU_READ, R_TB_WRITE, R_TBU_WRITE, R_EIE,
   R_EID,     E_NRI,      R_CMPA,     R_CMPB,      R_CMPC,
   R_CMPD,    R_ICR,      R_DER,      R_COUNTA,    R_COUNTB,
   R_CMPE,    R_CMPF,     R_CMPG,     R_CMPH,      R_LCTRL1,
   R_LCTRL2,  R_ICTRL,    R_BAR,      R_DPDR,      R_DPIR,
   R_IMMR,    R_IC_CST,   R_IC_ADR,   R_IC_DAT,    R_DC_CST,
   R_DC_ADR,  R_DC_DAT,   R_MI_CTR,   R_MI_AP,     R_MI_EPN,
   R_MI_TWC,  R_MI_RPN,   R_MI_DBCAM, R_MI_DBRAM0, R_MI_DBRAM1,
   R_MD_CTR,  R_M_CASID,  R_MD_AP,    R_MD_EPN,    R_M_TWB,
   R_MD_TWC,  R_MD_RPN,   R_M_TW,     R_MD_DBCAM,  R_MD_DBRAM0,
   R_MD_DBRAM1, R_END=100,
   R_CR=0x80,
   MAX_CPU_REG_NUM
}CPU_REG;

typedef enum{
   R_HCS0C = 0XC0, R_LCS0C = 0XC2,  // 2 BYTES
   R_HCS1C = 0XC4, R_LCS1C = 0XC6,
   R_HCS2C = 0XC8, R_LCS2C = 0XCA,
   R_HCS3C = 0XCC, R_LCS3C = 0XCE,
   R_HCS4C = 0XD0, R_LCS4C = 0XD2,
   R_HCS5C = 0XD4, R_LCS5C = 0XD6,
   R_HCS6C = 0XD8, R_LCS6C = 0XDA,
   R_HCS7C = 0XDC, R_LCS7C = 0XDE,
   R_HDB0C = 0XE0, R_LDB0C = 0XE2,
   R_HDB1C = 0XE4, R_LDB1C = 0XE6,

   R_PDA   = 0XF0, R_PBA   = 0XF1,  // 1 BYTE
   R_PADD  = 0XF2, R_PBSS  = 0XF3,
   R_PAPA  = 0XF4, R_PBPA  = 0XF5,

   //R_ISR   = 0XF8, R_ICR   = 0XFA,  ** 2 BYTES

   R_RR    = 0XFC, R_WP    = 0XFD,  // 1 BYTE
   R_SYS   = 0XFE, R_TV    = 0XFF,
   MAX_INTERNAL_REG_NO
}M306_INTERNAL_REG;

typedef enum {
   M68K_REG,       /*  */
   INTERNAL_REG
} REG_MODE ;
