/****************************************************************************
**
**  Name:  LDEBUG.H
**
**  Description:
**      Header file for Debug Part definitions/prototypes, for IEEE 695 Loader.
**
**  $Log:   S:/tbird/arcppc/lelf/ldebug.h_v  $
** 
**    Rev 1.6   31 Mar 1997 08:45:42   hera
** 
**    Rev 1.5   24 Mar 1997 13:58:38   hera
**
**  Status:  CODED
**
**  $Header:   S:/tbird/arcppc/lelf/ldebug.h_v   1.6   31 Mar 1997 08:45:42   hera  $
**
**
*****************************************************************************/
#ifndef __LDEBUG__
#define __LDEBUG__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef __LSYM__
#include "lsym.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/*ELF*/
/*       Tag name                Tag Value*/ 
#define TAG_padding                0x0000
#define TAG_array_type             0x0001
#define TAG_class_type             0x0002
#define TAG_entry_point            0x0003
#define TAG_enumeration_type       0x0004
#define TAG_formal_parameter       0x0005
#define TAG_global_subroutine      0x0006
#define TAG_global_variable        0x0007
#define TAG_label                  0x000A
#define TAG_lexical_block          0x000B
#define TAG_local_variable         0x000C
#define TAG_member                 0x000D
#define TAG_pointer_type           0x000F
#define TAG_reference_type         0x0010
#define TAG_compile_unit           0x0011
#define TAG_source_file            0x0011
#define TAG_string_type            0x0012
#define TAG_structure_type         0x0013
#define TAG_subroutine             0x0014
#define TAG_subroutine_type        0x0015
#define TAG_typedef                0x0016
#define TAG_union_type             0x0017
#define TAG_unspecified_parameters 0x0018
#define TAG_variant                0x0019
#define TAG_common_block           0x001A
#define TAG_common_include         0x001B
#define TAG_inheritance            0x001C
#define TAG_inlined_subroutine     0x001D
#define TAG_module                 0x001E
#define TAG_ptr_to_member_type     0x001F
#define TAG_set_type               0x0020
#define TAG_subrange_type          0x0021
#define TAG_with_stmt              0x0022
#define TAG_lo_user                0x4080
#define TAG_hi_user                0xFFFF

/*   Attribute from name    Value*/
#define FORM_ADDR            0x1
#define FORM_REF             0x2
#define FORM_BLOCK2          0x3
#define FORM_BLOCK4          0x4
#define FORM_DATA2           0x5
#define FORM_DATA4           0x6
#define FORM_DATA8           0x7
#define FORM_STRING          0x8

/*   Attribute name         Value*/
#define AT_sibling          0x0012
#define AT_location         0x0023
#define AT_name             0x0038
#define AT_fund_type        0x0055
#define AT_mod_fund_type    0x0063
#define AT_user_def_type    0x0072
#define AT_mod_u_d_type     0x0083
#define AT_ordering         0x0095
#define AT_subscr_data      0x00A3
#define AT_byte_size        0x00B6
#define AT_bit_offset       0x00C5
#define AT_bit_size         0x00D6
#define AT_element_list     0x00F4
#define AT_stmt_list        0x0106
#define AT_low_pc           0x0111
#define AT_high_pc          0x0121
#define AT_language         0x0136
#define AT_member           0x0142
#define AT_discr            0x0152
#define AT_discr_value      0x0163
#define AT_string_length    0x0193
#define AT_common_reference 0x01A2
#define AT_comp_dir         0x01B8
#define AT_const_string     0x01C8
#define AT_const_halfword   0x01C5
#define AT_const_word       0x01C6
#define AT_const_dword      0x01C7
#define AT_const_block2     0x01C3
#define AT_const_block4     0x01C4
#define AT_containing_type  0x01D2
#define AT_default_address  0x01E1
#define AT_default_halfword 0x01E5
#define AT_default_dword    0x01E7
#define AT_default_string   0x01E8
#define AT_friends          0x01F3
#define AT_inline           0x0208
#define AT_is_optional      0x0218
#define AT_lower_ref        0x0222
#define AT_lower_halfword   0x0225
#define AT_lower_word       0x0226
#define AT_lower_dword      0x0227
#define AT_program          0x0238
#define AT_private          0x0248
#define AT_producer         0x0258
#define AT_protected        0x0268
#define AT_prototyped       0x0278
#define AT_public           0x0288
#define AT_pure_virtual     0x0298
#define AT_return_addr      0x02A3
#define AT_specification    0x02B2
#define AT_start_scope      0x02C4
#define AT_stride_size      0x02E4
#define AT_upper_ref        0x02F2
#define AT_upper_halfword   0x02F5
#define AT_upper_word       0x02F6
#define AT_upper_dword      0x02F7
#define AT_virtual          0x0308
#define AT_lo_user          0x2000
#define AT_hi_user          0x3FF0
/* Diab Data extension attributes <Judy 7/7/1997> */
#define AT_DIAB_pure_virtual 0x0293
#define AT_DIAB_virtual      0x0303
#define AT_DIAB_push_mask    0x2206
#define AT_DIAB_frame_size   0x2216
#define AT_DIAB_mangled      0x0508
#define AT_DIAB_source_file_names 0x8006
#define AT_DIAB_source_info  0x8106
/* eof.Diab Data extension attributes <Judy 7/7/1997> */

/*       Location   Value*/
#define  OP_REG      0x01
#define  OP_BASEREG  0x02
#define  OP_ADDR     0x03
#define  OP_CONST    0x04
#define  OP_DEREF2   0x05
#define  OP_DEREF    0x06
#define  OP_DEREF4   0x06
#define  OP_ADD      0x07
#define  OP_lo_user  0xE0
#define  OP_hi_user  0xFF

/*        Language           Value*/
#define   LANG_C89         0x00000001
#define   LANG_C           0x00000002
#define   LANG_ADA83       0x00000003
#define   LANG_C_PLUS_PLUS 0x00000004
#define   LANG_COBOL74     0x00000005
#define   LANG_COBOL85     0x00000006
#define   LANG_FORTRAN77   0x00000007
#define   LANG_FORTRAN90   0x00000008
#define   LANG_PASCAL83    0x00000009
#define   LANG_MODULA2     0x0000000A
#define   LANG_lo_user     0x00008000
#define   LANG_hi_user     0x0000FFFF

/*        Array_Ordering    Value*/
#define   ORD_row_major       0
#define   ORD_col_major       1

/*         Format           Value*/
#define   FMT_FT_C_C         0x0
#define   FMT_FT_C_X         0x1
#define   FMT_FT_X_C         0x2
#define   FMT_FT_X_X         0x3
#define   FMT_UT_C_C         0x4
#define   FMT_UT_C_X         0x5
#define   FMT_UT_X_C         0x6
#define   FMT_UT_X_X         0x7
#define   FMT_ET             0x8

/* Name of MRI procedure block containing C++ information (for Xray) */
#define XRAY_CPPNAME "__XRYCPP"

/* Begin Block types */
#define		BB_LOCAL_TYPE	 1 
#define		BB_GLOBAL_TYPE  2
#define		BB_MODULE		 3
#define		BB_EXTERN_FN	 4
#define		BB_LINE			 5
#define		BB_STATIC_FN	 6
#define		BB_ASMBLOCK		 10
#define		BB_ASMSECTION	 11
#define		BB_LIBRARY		 20

/* MACROS */
#define IS_BBFUNCTION(x)  ((x) == BB_STATIC_FN || (x) == BB_EXTERN_FN)
#define IS_ASMMODULE(x)   ((x) == BB_ASMBLOCK || (x) == BB_ASMMODULE)

/*
** NOTES: number of bytes to preserve at end of function block, if we are
** skipping over locals for ondemand loading.
** Revised to 7 from 8, to handle the case of an unnamed block immediately
**   followed by end-function (it was getting the wrong one, and out of sync).
*/

#define FN_ENDADDR_OFFSET  7
#define FN_ENDADDR_BYTES   FN_ENDADDR_OFFSET

/* ATN attribute record types */
#define ATN_AUTO           1  /* auto - stack-based var */
#define ATN_REGISTER       2  /* register var */
#define ATN_STATIC         3  /* static var */
#define ATN_EXTERN_FN      4  /* extern function */
#define ATN_EXTERN_VAR     5  /* external var */
#define ATN_LINENO         7  /* line number */
#define ATN_GLOBAL         8  /* compiler global */
#define ATN_LIFETIME       9  /* variable lifetime */
#define ATN_LOCKED_REG     10 /* locked register var */
#define ATN_DEFINE_CONST   16 /* C's #define constant */
#define ATN_STATIC_ASM     19 /* static assembly symbol */
#define ATN_CREATION_TIME  50 /* loadfile creation time, as stored */
#define ATN_CMDLINE        51 /* commandline (to linker) */
#define ATN_STATUS         52 /* execution status (of link) */
#define ATN_HOSTOS         53 /* host environment */
#define ATN_TOOL           54 /* tool used to create file */
#define ATN_COMMENT        55 /* comment string */
#define ATN_PROC_MISC      62 /* procedure miscellaneous */
#define ATN_VAR_MISC       63 /* variable miscellaneous */
#define ATN_MOD_MISC       64 /* module miscellaneous */
#define ATN_MISC_STR       65 /* module misc string */

/* types of procedure miscellaneous records (used in ATN62), also
   module miscellaneous records (used in ATN64)
*/
#define PMISC_1             1  /* procedure return address (R-label) */
#define PMISC_51           51  /* stack frame adjust */
#define MMISC_55           55  /* assembly procedure info */
#define PMISC_57           57  /* jump table description */
#define PMISC_77           77  /* undocumented (optimized code uses) */
#define PMISC_80           80  /* C++ information */

/* pmisc 80 record types (C++ information, defined in IEEE 695 Appendix F
   (MRI spec)).  Most of these (not all, see notes in handling routine
   in ldebug.c) are found in the XRAY information block, hence the name. */
#define XRAY_MBRFUNCTION   0x4d  /* 'M': member function */
#define XRAY_ARGLIST       0x42  /* 'B': default and reference arg list */
#define XRAY_SOURCEFILE    0x46  /* 'F': source file name */
#define XRAY_CLASS         0x54  /* 'T': class, C++ struct, C++ union */
#define XRAY_PMBR          0x7a  /* 'z': pointer to member */
#define XRAY_REF           0x52  /* 'R': reference var */

/* default argument masks (used by pmisc 80, type 'B') */
#define DEFARG_4BYTE       0x01
#define DEFARG_8BYTE       0x02
#define DEFARG_STR         0x03

#define STACK_SEC          "stack"     /* name of stack section */

/* Indicator for static assembler symbols (ATN19) */
#define ATN19_GLOBAL       1
#define ATN19_LOCAL        0

/* Indicator for constant definition */
#define ATN16_GLOBAL_DEF   1
#define ATN16_LOCAL_DEF    0
#define LONG_STR_256       0xDE
#define LONG_STR_MAX       0xDF

#define MAX_EXPAND_TYPE 1000
#define MAX_MODULE      1000
#define NUM_FUN_TYPE    23

typedef struct off2index
{
   U32 offset;
   U32 tindex;
   struct off2index* next;
}Offset2Index;

typedef struct {
      OFFSET_ADDR_TYPE lowpc;
      OFFSET_ADDR_TYPE hipc;
      SYM_DESCRIPTOR mDesc;
      char* srcname;
}Lowpc2MDesc;

typedef struct structinfo{
   char name[128];
   U32 typeIndex;
   U32 offset;
   U16 attribution;
   BYTE modifier;
   U32  utype;
   U16  pointerTimes;
   U16  tag; //Hera 1/23/98
   struct structinfo *next;
}StructInfo;

typedef struct classinfo{
   char name[128];
   U32 typeIndex;
   U32 offset;
   BOOLEAN isMethod;
   OFFSET_ADDR_RANGE_TYPE fnAddr; /* start and end address of the method function */
   U8  access;
   U16 attribution;
   BYTE modifier;
   U32  utype;
   U16  pointerTimes;
   U16  tag;//Hera 2/6/98
   struct classinfo *next;
}classInfo;
/* <Judy 7/9/97> */
typedef struct classLink{
   U32 foff;
   U32 size;
   struct classLink *next;
}ClassLink; //Hera 2/26/98

typedef struct classInfoLink {
      U32 *ptrCurrent;          // pointer to current ClassInfo
      struct classInfoLink *ptrNext;   //
} ClassInfoLink;

typedef struct classInfo{
      LPSTR className;                 // pointer class name
      struct classInfoLink *ptrParent; // pointer to parent of the class
      struct classInfoLink *ptrChild;  // pointer to child of the class
      U32 *ptrNextClass;               // pointer to next class
} ClassInfo;

/* eof <Judy 7/9/97> */

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

RETCODE ProcessDebugPart(HANDLE, BOOLEAN, U16, U16, U32 *);
RETCODE ProcessDbgTypes(HANDLE, LPSTR, U16);
RETCODE ProcessDbgModule(HANDLE, BOOLEAN, U16, U32,U32*, SYM_DESCRIPTOR *);
RETCODE ProcessDbgModuleOnDemand(HANDLE, U16);
RETCODE ProcessDbgGlobals(HANDLE, BOOLEAN);
RETCODE ProcessDbgFunctions(HANDLE, U16, BOOLEAN, U16, U32*);
RETCODE ProcessDbgClassFunctions(HANDLE, U16, BOOLEAN, U16, U32*, classInfo *, U32*);
RETCODE ProcessDbgFunctionStart(HANDLE, U32 *); /* <Judy 6/4/96> */
RETCODE ProcessDbgLocals(HANDLE, U16*, U32*);
RETCODE ProcessDbgLines(HANDLE, BOOLEAN, BOOLEAN);
RETCODE ProcessDbgLinesOnDemand(HANDLE,char *);
RETCODE ProcessDbgParameter(HANDLE hfile, U16* numParam, U32* TList);
/* Define in LASM.C */
RETCODE ProcessDbgAsmBlock(HANDLE, U32, LPSTR, BOOLEAN, SYM_DESCRIPTOR);
RETCODE StripPathString(LPSTR moduleName, LPSTR *newName);

/* Define in LTYPE.C */
RETCODE GetTypePtr(U32,U32);
RETCODE GetTypeRef(U32,U32);
RETCODE GetTypeTypedef(HANDLE, U32, TYPE_HEADER_TYPE *);
RETCODE GetTypeSU(HANDLE, U32, TYPE_HEADER_TYPE *);
RETCODE GetTypeClass(HANDLE, U32, TYPE_HEADER_TYPE *, BOOLEAN, U16);
RETCODE GetTypeEnum(HANDLE, U32, TYPE_HEADER_TYPE *);
RETCODE GetTypeArr(HANDLE, U32, TYPE_HEADER_TYPE *);
RETCODE GetTypeProc(HANDLE, U32, TYPE_HEADER_TYPE *);
RETCODE SetTypeClass(LPSTR name);  /* <Judy 7/9/97> */
RETCODE SetTypeClassInher(LPSTR name, LPSTR parentName);/* <Judy 7/9/97> */
//RETCODE GetInheritance(HANDLE hfile,U32 Offset,TYPE_HEADER_TYPE *parentTypeHdr,U32 *NextMember); /*Judy 7/9/97> */
RETCODE GetInheritance(HANDLE hfile,U32 *parentOffset, U32 *baseOffset,U32 *NextMember);

/* Define in Ldmangle.c */
RETCODE LdmangleDiabDemangle(LPSTR, LPSTR *);
RETCODE LdmangleDiabGetValue(HANDLE, LPSTR, U32* , U32*);
#endif
/****************************** EOF ****************************************/

