/****************************************************************************
**
**  Name:  cliulib.c
**
**  Description:
**     This is the CLI Utility Library to support the CLI Server.
**
**  $Log:   S:/tbird/arcppc/cliulib/cliulib.c_v  $
** 
**    Rev 1.0   17 Jan 1997 09:11:32   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:15:14   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:08:20   gene
** Initial revision.
** 
**    Rev 1.3   26 Apr 1993 15:34:58   tom
** UNIX filename support
** 
**    Rev 1.2.1.1   06 Apr 1993 15:20:18   tom
** Header cleanup.
**
**    Rev 1.2   23 Nov 1992 16:58:02   tom
** 7498: fix << and >> for shift counts larger than 31.
**
**    Rev 1.1   08 May 1992 11:52:30   tom
** added CLI active indication
**
**    Rev 1.0   01 Apr 1992 10:38:42   tom
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/cliulib/cliulib.c_v   1.0   17 Jan 1997 09:11:32   kevin  $
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _CLIULIB_
#include "cliulib.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
HANDLE permanentCliHandle = (HANDLE)NULL;  /* force definition here */

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/*--------------------------------------------------------------------------
**  CLISetActive
**
**  Purpose:
**     Mark the CLI as active.  Should only be called from CLI Server.
**
**  Input:
**     cliHandle:  The CLI Server handle.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLISetActive(HANDLE cliHandle)
{
  permanentCliHandle = cliHandle;
  return(GOOD);
}


/*--------------------------------------------------------------------------
**  CLIClearActive
**
**  Purpose:
**     Mark the CLI as inactive.  Should only be called from CLI Server.
**
**  Input:
**     None.
**
**  Output:
**     None.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIClearActive(void)
{
  permanentCliHandle = 0;
  return(GOOD);
}


/*--------------------------------------------------------------------------
**  CLIGetActive
**
**  Purpose:
**     Return an indication of whether the CLI is active or not.
**
**  Input:
**     None.
**
**  Output:
**     cliHandle:  The CLI Server handle; 0 indicates CLI Server inactive.
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIGetActive(HANDLE *cliHandle)
{
  *cliHandle = permanentCliHandle;
  return(GOOD);
}


/*--------------------------------------------------------------------------
**  CLILeftShift
**
**  Purpose:
**     Do a left shift operation (this operation is not available in Actor).
**
**  Input:
**     argument1:  first argument.
**     argument2:  second argument.
**
**  Output:
**     argument3:  argument1 << argument2
----------------------------------------------------------------------------*/
RETCODE EXPORT CLILeftShift (U32 argument1, U32 argument2, U32 FAR *argument3)
{
   if (argument2 > 31)
      *argument3 = 0;
   else
      *argument3 = argument1 << argument2;
   return(GOOD);
}

/*--------------------------------------------------------------------------
**  CLIRightShift
**
**  Purpose:
**     Do a right shift operation (this operation is not available in Actor).
**
**  Input:
**     argument1:  first argument.
**     argument2:  second argument.
**
**  Output:
**     argument3:  argument1 >> argument2
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIRightShift (U32 argument1, U32 argument2, U32 FAR *argument3)
{
   if (argument2 > 31)
      *argument3 = 0;
   else
      *argument3 = argument1 >> argument2;
   return(GOOD);
}

/*--------------------------------------------------------------------------
**  CLIBitwiseNegation
**
**  Purpose:
**     Do a bitwise negation (this operation is not available in Actor).
**
**  Input:
**     argument1:  first argument.
**
**  Output:
**     argument2:  ~argument1
----------------------------------------------------------------------------*/
RETCODE EXPORT CLIBitwiseNegation (U32 argument1, U32 FAR *argument2)
{
   *argument2 = ~argument1;
   return(GOOD);
}

/******************************** E O F ***********************************/
