/*****************************************************************************
** Name:  textgen.h
**
** Description:
**    Routines to access the CLI for the variable server.
**
** Status:   PRELIMINARY
**
** $Log:   S:/tbird/arcppc/varsrv/textgen.h_v  $
** 
**    Rev 1.1   04 Mar 1997 13:30:34   cjchen
** 
**    Rev 1.0   17 Jan 1997 09:29:36   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:44:06   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:24:52   gene
** Initial revision.
** 
**    Rev 1.3   12 May 1993 16:35:46   ron
** variable window enhancements: pass position of edit text
** 
**    Rev 1.2   28 May 1992 16:39:36   marilyn
** Added parameter frameNum to GetFormattedType.
** 
**    Rev 1.1   17 Apr 1992 16:22:06   marilyn
** Moved prototype of MakeCompositeVarName from textgen.c
** 
**    Rev 1.0   23 Mar 1992 11:02:48   marilyn
** Initial revision.
** 
** $Header:   S:/tbird/arcppc/varsrv/textgen.h_v   1.1   04 Mar 1997 13:30:34   cjchen  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _TEXTGEN_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _VARSERVR_
#include "varservr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *   EXTERNAL PROTOTYPES    *
                        *                          *
                        ****************************/

RETCODE GetFormattedType(DESCRIPTOR rootVarId,
                      STRING *textptr,
                      U32 linesForThisBuf,
                      U32 startLine,
                      DESCRIPTOR bufferNum,
                      U8 frameNum);


RETCODE GetCharSetBuf(DESCRIPTOR VSVarId,
                      DESCRIPTOR bufferNum,
                      U32 lineNum,
                      U16 *fieldWidth,
                      U16 startCol);

RETCODE  EditValueField(DESCRIPTOR varId,
                        DESCRIPTOR bufferNum,
                        U32 lineNum,
                        U16 editFieldCharOffset,
                        LPSTR newValueText,
                        VS_DISPLAY_PTR *displayBufPtr);


/******************************** E O F ***********************************/
