/***************************************************************************
**
**    Name:    daddq306.h
**
**    Description:
**        Internal definitions for the dequeuer server.
**
** 
** 
**    $Header:
*/

#define _DQ306_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/


                        /********************
                        **                 **
                        **  Definitions    **
                        **                 **
                        ********************/



typedef struct {
   BOOLEAN     frameValid;
   BOOLEAN     synched;
   BOOLEAN     programFrame;
   DESCRIPTOR  frameAddr;
   U16         data;
   U32         ifetch;
   S32         frameNo;
}FRAME_TYPE;


#define MAX_FRAME_NO         0x40L  // Read 64 trace frames each times.
#define MAX_FRAME_READ       0x40L  // Read 64 trace frames each times.

#define MAX_INST_LEN          6  // 11 word.
#define MAX_RDWR_LEN          32 // 64 word.
#define AVG_INST_LEN          2  // 2 word.

typedef enum { READ_NOSKIP, READ_SKIP }FRAME_READ_MODE;

typedef enum { PROGRAM_FRAME, DATA_FRAME }FRAME_READ_TYPE;

typedef enum {F_UD = 1, F_UP = 2, F_SD = 5, F_SP = 6, F_CPU = 7}FRAME_SPACE;

typedef enum {S_PROGRAM = 0x10, S_DATA, S_DONT_CARE}SPACE_TYPE;


typedef struct {
   S32 frameNo;
   U32 addr;
   U32 data;

   U16 dsPin    : 2;  // hardware pin define
   U16 sparePin : 1;
   U16 nDramPin : 1;
   U16 rwPin    : 1;
   U16 fcPin    : 3;
   U16 csPin    : 8;
   U16 portAB;

}TRC_FRAME;

#define TRACE_FRAME_WIDTH     16 // the length of each trace frame.


typedef struct {
   S32 frameNo;
   U32 addr;
   U16 data;
   U16 rwPin;
   U16 fcPin;
   U16 dsPin;
}DQ_FRAME;

typedef struct {
    DQ_FILTER       DqFilter;
    BOOLEAN         Search;
    U16             Offset;
    LPSTR           pattern;
    DESCRIPTOR      traceId;
    FRAME_TYPE      *dqFrame;

    U16 traceBufId;         // New add record for 306 DQ
    S32 frameStart,frameEnd;
    TRC_FRAME frameArray[MAX_FRAME_NO];
}DQ_STATE;
/********************************* E O F *******************************/
