/****************************************************************************
**
**  Name:  emucomm.h
**
**  Description:
**     Michelle MICE data/command communication routines.
**     include:
**
**  Status:  preliminary
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_COMM_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *      DEFINITIONS         *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *       PROTOTYPES         *
                         *                          *
                         ****************************/

/*********************************************************/
/* Communication Subroutine in START.ASM                 */
/*********************************************************/
#define  SPiclk     0x8000
#define  Baud_1152  (SPiclk+16)   // (16MHz/(8*115200))-1
#define  Baud_576   (SPiclk+34)   // (16MHz/(8*57600))-1
#define  Baud_384   (SPiclk+51)   // (16MHz/(8*38400))-1
#define  Baud_192   (SPiclk+103)  // (16MHz/(8*19200))-1
#define  Baud_96    (SPiclk+207)  // (16MHz/(8*9600))-1

VOID BaudRate(U16 Scale);
// Set baud rate,
// both transmit and receive must be stop before changing baud rate

VOID SetBaudRateTimer(U16 T);
//  set baud rate timer equal to T*0.1sec

U8   CommCtrl(U8 cmd);
//  Communication control
//  cmd --> 0: Serial Communication
//          1: Parallel Communcation
//          2: Fix Communication Mode
//  return al --> 0 : o.k.
//                1 : Communication Mode can not change
//                2 : illegal command

VOID SetWatchDog(U16 T);
//  set watchdog timer equal to T*10ms

VOID HltWatchDog(VOID);
//  halt WatchDog timer

VOID SetDmaCount(U16 dmaCnt);
//  start receive logic to transfer dmaCnt bytes
//  dmaCnt must be a non-zero value

U8   ReceiveByte(VOID);
//  get one byte from receive buffer

VOID CommRecover(VOID);
//  reset transmit logic, remaining data in transmit buffer will lost

U16  outSize(VOID);
//  remaining bytes in transmit buffer

VOID TransmitByte(U8 byteData);
//  put one byte to transmit buffer
//  if buffer is full, data will lost


/*********************************************************/
/* Communication Subroutine in EMUCOMM.C                 */
/*********************************************************/
int  CommSync(int len,U8 *buf[]);
VOID ReceiveStream(VOID);
VOID TransmitStream(VOID);

/******************************** E O F ***********************************/
