/***************************************************************************
**
**  Name:  emuerror.c
**
**  Description:
**     Michelle error handle processing, there are 4 levels used to
**     indicate the error extent. Each level has the domain to accept
**     the error conditions.
**
**     Two-dimention array to present this error table on the sw site:
**     [0~9][0~31] <--> [level-NO][Error-NO]
**     Transfered from fw's return code <--> U16; High-byte for "level-NO"
**                                                Low-byte for "Error-NO"
**
**     NOTE: should we support multiple-error ? I'll discuss this issue
**           with Matthew to find a reasonable solution then update version
**           of this document in these few days.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcppc/fw/603e/emuerror.c_v  $
** 
**    Rev 1.0   11 Feb 1997 16:16:48   kevin
** Initial revision.
** 
**    Rev 1.2   29 Nov 1996 14:24:54   gene
** modify OutputExceptReason for 5204, added 0x80 error code
** 
**    Rev 1.1   25 Jul 1996 18:10:34   gene
** added CANNOT_RESET error
** 
**    Rev 1.0   03 Jun 1996 14:18:52   gene
** Initial revision.
** 
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _CONSTR_
#include "const.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#include <string.h>
#include <dos.h>

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** EmuReportError
**
**  Description: report error by passing/returning an error code to host.
**               This code id included in the status field of
**               the transmiting data record.
**
**  Parameters:
**     input:
**
**
**     output:
**
**
****************************************************************************/
VOID EmuReportError(ERROR_NO errCode) {
   OutputStatus(errCode,ON);
}

/****************************************************************************
**
**  OutputExceptReason
**
**  Description: output the status of executive FW to outputStream
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID OutputExceptReason(BOOLEAN endData) {
U16 typeLen,errNo;

   switch (exceptBreak) {
      case 1 : /* Bus Request */
         errNo = BUS_REQUEST;
         break;
      case 0x2 : /* Target is not ready */
         errNo = NOT_READY;
         break;
      case 0x4 : /* Target can not step */
         errNo = STEP_ERROR;
         break;
      case 0x8 : /* Target is halted */
         errNo = MICE_HALT;
         break;
      case 0x10 : /* Target can not reset */
         errNo = CANNOT_RESET;
         break;
      case 0x20 : /* Target Vcc is off */
         errNo = NO_VCC;
         break;
      case 0x40 : /* Target Vcc is off */
         errNo = TARGET_RESET;
         break;
      case 0x80 : /* Invalid Sim accesses */
         errNo = SIM_INVALID;
         break;
   }
   typeLen = sizeof(U16);
   memcpy (&outputStream[0],&errNo,typeLen);
   outputStreamLen = typeLen;
   if (endData)
      outputStream[outputStreamLen++] = 0x00;/* Output stream length */
   exceptBreak = 0;
}

