/****************************************************************************
**
**  Name:  emusetup.h
**
**  Description:
**     Michelle setup-group routines.
**     include:
**     "Get the identity of the Michelle FW version, HW configuration
**      and HW model type",
**     "Set access size to be byte/word/dword-accessing",
**     "Set or read the memory-write verify-flag",
**     "Control ready using external/internal",
**     "Set or read the memory mapping",
**     "Read all setup information",
**     "Set control signals",
**    * "set or read the wait-state" --- This is a issue to be discussed.
**      We will decide this latter.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcppc/fw/603e/emusetup.h_v  $
** 
**    Rev 1.0   11 Feb 1997 16:16:56   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 14:19:06   gene
** Initial revision.
** 
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_SETUP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/


/****************************************************************************
**
**  EmuSetControl
**
**  Description: Michelle setup-group routine,
**
**  Parameters:
**     input:
**        signals -- U16
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetControl(U16 signals);

/****************************************************************************
**
**  EmuGetControl
**
**  Description: Michelle setup-group routine,
**
**  Parameters:
**     input:
**        signals -- U16
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
//VOID EmuGetControl(VOID);


/****************************************************************************
**
**  EmuGetStatus
**
**  Description: Michelle setup-group routine, to read the current setting
**               of the Michelle.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." be Normal return
**        "Emulator Fatal Error" for HW error
**        return data -- "length" + "events" + "qualify: + "trigger" +
**                       "MAP" + control signals" +
**                       "ready setting"
**
**                     * "ID" is a issue to be discussed later
**
*****************************************************************************/
VOID EmuGetStatus(VOID);

/****************************************************************************
**
**  EmuGetID()
**
**  Description: Michelle setup-group routine, to get the emulator's ID to
**               make sure that driver program has connected to a correct
**               emulator.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        return data -- "length" + "ID"
**
*****************************************************************************/
VOID EmuGetID(VOID);


/****************************************************************************
**
**  EmuSetReady()
**
**  Description: Michelle setup-group routine, to select the READY signal
**               source.
**               "src" = 0 --> Internal
**               "src" = 1 --> External
**
**  Parameters:
**     input:
**        src -- BOOLEAN (Or int)
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetReady(U16 flag);

/****************************************************************************
**
**  EmuGetReady()
**
**  Description: Michelle setup-group routine, to select the READY signal
**               source.
**               "src" = 0 --> Internal
**               "src" = 1 --> External
**
**  Parameters:
**     input:
**        src -- BOOLEAN (Or int)
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetReady(VOID);

/****************************************************************************
**
**  EmuSetAccessSize()
**
**  Description: Michelle setup-group routine, to set the bus access size.
**               "size" = 0 --> Byte-access (8-Bit),
**               "size" = 1 --> Byte-access (16-Bit),
**               "size" = 2 --> Byte-access (32-Bit)
**
**  Parameters:
**     input:
**        size -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetAccessSize(SIZE size);

/****************************************************************************
**
**  EmuGetAccessSize()
**
**  Description: Michelle setup-group routine, to set the bus access size.
**               "size" = 0 --> Byte-access (8-Bit),
**               "size" = 1 --> Byte-access (16-Bit),
**               "size" = 2 --> Byte-access (32-Bit)
**
**  Parameters:
**     input:
**        size -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetAccessSize(VOID);

/****************************************************************************
**
**  EmuSetWait()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetWait(U16 count);

/****************************************************************************
**
**  EmuGetWait()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetWait(VOID);

/****************************************************************************
**
**  EmuSetSync()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetSync(U16 state);

/****************************************************************************
**
**  EmuGetSync()
**
**  Description: Michelle setup-group routine, to insert wait state for
**               Michelle. Insert wait state, "count" id the number of
**               clocks of the wait-state.
**
**  Parameters:
**     input:
**        count -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetSync(VOID);


/****************************************************************************
**
**  EmuSetVerify
**
**  Description: Michelle setup-group routine, to verify the writting
**               action onto the memory. (Memory write verification)
**               "flag" = 0 --> Disable the verification
**               "flag" = 1 --> Enable the verification
**
**  Parameters:
**     input:
**        flag -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetVerify(U16 flag);

/****************************************************************************
**
**  EmuGetVerify
**
**  Description: Michelle setup-group routine, to verify the writting
**               action onto the memory. (Memory write verification)
**               "flag" = 0 --> Disable the verification
**               "flag" = 1 --> Enable the verification
**
**  Parameters:
**     input:
**        flag -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetVerify(VOID);

/***************************************************************************
**
**  EmuTimer
**
**  Description:
**
**
**
**
**  Parameters:
**     input:
**        flag -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuEpTimer(U16 timerFlag);

VOID EmuEnSwBkpt(VOID);
VOID EmuDisSwBkpt(VOID);
VOID EmuSetBkptCode(BKPT_OP_CODE bkptOpCode);

/******************************** E O F ***********************************/

