/****************************************************************************
**
**  Name:  emutrace.h
**
**  Description:
**     Michelle trace-group routines.
**     include:
**        "Free running target CPU   -- EmuGo()"
**        "Stop target CPU           -- EmuHalt()"
**        "Clear event               -- EmuClrEvent()"
**        "Set event                 -- EmuSetEvent()"
**        "Set execution break point -- EmuSetExBkpt()"
**        "Clear trigger setting     -- EmuClrTrig()"
**        "Define trigger setting    -- EmuSetTrig()"
**        "List trace                -- EmuListTrace()"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcppc/fw/603e/emutrace.h_v  $
** 
**    Rev 1.0   11 Feb 1997 16:17:00   kevin
** Initial revision.
** 
**    Rev 1.5   10 Sep 1996 14:43:58   gene
** change listTraceBuffer prototype
** 
**    Rev 1.4   06 Aug 1996 14:00:30   gene
** added EmuGoEpDelay()
** 
**    Rev 1.3   27 Jun 1996 10:58:26   gene
** added EmuTraceReset() prototype
** 
**    Rev 1.2   27 Jun 1996 09:00:18   gene
** modify ListTraceBuffer() prototype
** 
**    Rev 1.1   10 Jun 1996 11:02:24   gene
** 
**    Rev 1.0   03 Jun 1996 14:19:12   gene
** Initial revision.
** 
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_TRACE_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#define TRIG_NO    2
typedef struct {
   U16 defined;  /* not used */
   U16 ev[11]; /* event no: 1 ~ 9 ; cnt0 ~1 : 10, 11; 0: null */
   U16 op[5];  /* not used */
   U16 arm[7]; /* not used */
   U16 act[11]; /* bit :
                    0        1       2       3       4       5
                 "BREAK", "RESET", "SEQ", "TROFF", "NEXT", "INC0",
                    6       7      8         9        10
                  "RST0", "INC1", "RST1", "EXTIN", "EXTOUT"
                */
   U16 mode;  /* backward : 0 ; forward : 1 ; center : 2; delay : 3 */
   U16 delay;
} TRIGGER;

TRIGGER trigLevel[TRIG_NO];
TRIGGER trig; //template data

typedef struct {
   U16 addr,data;
} TRIG_OUT;

TRIG_OUT trigOut[13]; //  0  -  7   8   9   10     11      12
                      // ev0 - ev7,tc0,tc1,extin,level0-,level1-

#define FRAME_LEN    16

typedef struct {
 U16 startFrame,
     endFrame,
     frameLen;
}TRACE_INFO;

typedef struct {
 U8 frameDat[FRAME_LEN];
}TRACE_DATA;

typedef enum { FORWARD, CENTER, BACKWARD} TRACE_FLAG;

#define EVENT_NO  11

typedef enum { PRE_TRIG, CENTER_TRIG, POST_TRIG } TRIG_LOC;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/


/****************************************************************************
**
**  ReadTraceCount
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS ReadTraceCount(TRACE_INFO *traceData);

/****************************************************************************
**
**  EmuAbort
**
**  Description: Michelle trace-group routine, to abort the michelle.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data -- "length" + "PC" + "brealFlag"
**
**
****************************************************************************/
VOID EmuAbort(VOID);

/****************************************************************************
**
**  EmuGo
**
**  Description: Michelle trace-group routine, to set the target CPU free
**               running. Default free running target CPU from current PC.
**               "mode" is to indicate the mode of free-running.
**               "mode" = 0 --> no temporary breakpoint is specified.
**               "mode" = 1 --> set temporary breakpoint at "addr" location
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "breakFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
*****************************************************************************/
VOID EmuGo(S16 mode);

STATUS StartGo(S16 mode);

/****************************************************************************
**
**  EmuAbort
**
**  Description: Michelle trace-group routine, to abort the michelle.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data -- "length" + "PC" + "brealFlag"
**
**
****************************************************************************/
VOID EmuAbort(VOID);

/****************************************************************************
**
** EmuGetCpuStatus
**
**  Description: Michelle trace-group routine, to set the target CPU free
**               running. Default free running target CPU from current PC.
**               "mode" is to indicate the mode of free-running.
**               "mode" = 1 --> no temporary breakpoint is specified.
**               "mode" = 2 --> set temporary breakpoint at "addr" location
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "brealFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
****************************************************************************/
VOID EmuGetCpuStatus(VOID);

/****************************************************************************
**
**  EmuHalt
**
**  Description: Michelle trace-group routine, to stop the target CPU.
**               Stop execution of target CPU.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error
**        return data -- "length" + "PC"
**
**  NOTE: I want to delete this function because we can support "halt"
**        in sw/driver. there is no necessarity to have a task to do so
**        in fw. (Do get register for one-pass-process)
**
*****************************************************************************/
VOID EmuHalt(VOID);

/****************************************************************************
**
**  EmuSetEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     evId     -- int,
**     addrSpec -- unsigned int,
**     addrLo   -- unsigned long,
**     addrHi   -- unsigned long,
**     dataSpec -- unsigned int,
**     dataLo   -- unsigned int,
**     dataHi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetEvent(U16 evId, U8 *busEventData);

/****************************************************************************
**
**  EmuSetAllEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     evId     -- int,
**     addrSpec -- unsigned int,
**     addrLo   -- unsigned long,
**     addrHi   -- unsigned long,
**     dataSpec -- unsigned int,
**     dataLo   -- unsigned int,
**     dataHi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetAllEvent(U8 *busData,U8 *execData,U8 *extData);

/****************************************************************************
**
**  EmuSetExBkpt
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId  -- int,
**        addr  -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetExBkpt(U16 evId, ADDR *addr);

/***************************************************************************
**
**  EmuSetExtEvent
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId --
**        addr  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetExtEvent(U16 evData);

/****************************************************************************
**
**  EmuClrEvent
**
**  Description: Michelle trace-group routine, to clear the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**     input:
**        evId  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuClrEvent(U16 evId);

/****************************************************************************
**
**  EmuGetAllEvent
**
**  Description: Michelle trace-group routine, to get the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuGetAllEvent(VOID);

/****************************************************************************
**
**  EmuListTrace
**
**  Description: Michelle trace-group routine, to list raw data from the
**               trace buffer.
**               List trace buffer content in RAW data format which is
**               similar to the output of LOSTAN command in MICE-III.
**               The "frame" is the starting listing frame. If "frame" is
**               "-1", <ew MICE will return the number of frames in the
**               trace buffer.
**
**  Parameters:
**     input:
**        frame --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        list trace -- ("length" + "frame_data") *
**                      (min(256, "rest_frames_ in_trace_buffer"))
**        return count -- "length" + "number"
**
*****************************************************************************/
//VOID EmuListTrace(U16 traceBufId, U32 frameNo);
VOID EmuListTrace(U8 firstTime);

/***************************************************************************
**
**  EmuSetTraceBreak
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBreak(U16 breakFull);

/***************************************************************************
**
**  EmuSetTraceBuff
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBuff(U16 traceBufNum);

/***************************************************************************
**
**  EmuGetTraceInfo
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceInfo(VOID);

/***************************************************************************
**
**  EmuGetTraceDepth
**
**  Description:
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceDepth(U16 traceBufId);

/****************************************************************************
**
**  EmuClrTrig
**
**  Description: Michelle trace-group routine, to clear the trigger setting.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuClrTrig(U16 levelNo);

/****************************************************************************
**
**  EmuSetTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetTrig(U16 levelNo, U16 *events, U16 *actions, U16 mode);

/***************************************************************************
**
**  EmuGetAllTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuGetAllTrig(VOID);

/****************************************************************************
**
**  EmuSetTimerCounter
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetTimerCounter(U16 tcFlag, U32 tcData);

/****************************************************************************
**
**  EmuSetQualTrace
**
**  Description: trace-group routine, to define the qualify trace setting.
**
**  Parameters:
**     input:
**        U32  Addr -- address to qualify trace
**        U32  AddrMaks -- address mask ==> 0 don't care
**                                          1 compare bit
**        U16  QualStatus -- status ==>
**                bit  0   1   2   3   4   5   6-15
**                    FC0 FC1 FC2 R/W LDS UDS unused
**        U16  QualStatusMask -- status mask ==> 0 don't care
**                                               1 compare bit
**
**     output:
**        always return GOOD
**
*****************************************************************************/
VOID EmuSetQualTrace(U32 Addr, U32 AddrMask,U16 QualStatus,U16 QualStatusMask);

/****************************************************************************
**
**  EmuQualDisable
**
**  Description: trace-group routine, to disable the qualify trace setting.
**
**  Parameters:
**     input: VOID
**
**     output:
**        always return GOOD
**
*****************************************************************************/
VOID EmuDisableQual(VOID);

/******************************************************************************
**
**  ListTraceBuffer
**
**  Description:
**    List trace data from trace buffer
**
**  Parameters:
**    input:
**      U16 *counter --> a variable used to count bytes in tempTraceBuff
**    output:
**      none
**
*******************************************************************************/
STATUS ListTraceBuffer(U16 *counter,U8 *flagRead,U16 trcBreak);

/* EmuTraceReset() : reset trace buffer index, clear trace buffer content */
VOID EmuTraceReset(VOID);

VOID AccessExecEvent(ACCESS_MODE accessMode, U16 evId, EXEC_EVENT *execData);
STATUS AccessBusEvent(ACCESS_MODE accessMode, U16 evId, BUS_EVENT *execData);
VOID EmuGoEpDelay(BOOLEAN delay);
/******************************** E O F ***********************************/
